/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.api.tracks.ITrackReversable;
import mods.railcraft.api.tracks.ITrackTile;
import mods.railcraft.api.tracks.TrackSpec;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBaseRailLogic;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public abstract class TrackInstanceBase
implements ITrackInstance {
    private Block block;
    public TileEntity tileEntity;

    private Block getBlock() {
        if (this.block == null) {
            int id = this.getWorld().func_72798_a(this.getX(), this.getY(), this.getZ());
            this.block = Block.field_71973_m[id];
        }
        return this.block;
    }

    @Override
    public void setTile(TileEntity tile) {
        this.tileEntity = tile;
    }

    @Override
    public TileEntity getTile() {
        return this.tileEntity;
    }

    @Override
    public int getBasicRailMetadata(EntityMinecart cart) {
        return this.tileEntity.func_70322_n();
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        IToolCrowbar crowbar;
        ItemStack current;
        if (this instanceof ITrackReversable && (current = player.func_71045_bC()) != null && current.func_77973_b() instanceof IToolCrowbar && (crowbar = (IToolCrowbar)current.func_77973_b()).canWhack(player, current, this.getX(), this.getY(), this.getZ())) {
            ITrackReversable track;
            track.setReversed(!(track = (ITrackReversable)((Object)this)).isReversed());
            this.markBlockNeedsUpdate();
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            return true;
        }
        return false;
    }

    @Override
    public void onBlockPlaced() {
        this.switchTrack(true);
        this.testPower();
        this.markBlockNeedsUpdate();
    }

    @Override
    public void onBlockPlacedBy(EntityLiving entityliving) {
        if (entityliving == null) {
            return;
        }
        if (this instanceof ITrackReversable) {
            int dir = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            ((ITrackReversable)((Object)this)).setReversed(dir == 0 || dir == 1);
        }
        this.markBlockNeedsUpdate();
    }

    @Override
    public void onBlockRemoved() {
    }

    public void sendUpdateToClient() {
        ((ITrackTile)this.tileEntity).sendUpdateToClient();
    }

    public void markBlockNeedsUpdate() {
        this.getWorld().func_72845_h(this.tileEntity.field_70329_l, this.tileEntity.field_70330_m, this.tileEntity.field_70327_n);
    }

    protected boolean isRailValid(World world, int i, int j, int k, int meta) {
        boolean valid = true;
        if (!world.isBlockSolidOnSide(i, j - 1, k, ForgeDirection.UP)) {
            valid = false;
        }
        if (meta == 2 && !world.isBlockSolidOnSide(i + 1, j, k, ForgeDirection.UP)) {
            valid = false;
        } else if (meta == 3 && !world.isBlockSolidOnSide(i - 1, j, k, ForgeDirection.UP)) {
            valid = false;
        } else if (meta == 4 && !world.isBlockSolidOnSide(i, j, k - 1, ForgeDirection.UP)) {
            valid = false;
        } else if (meta == 5 && !world.isBlockSolidOnSide(i, j, k + 1, ForgeDirection.UP)) {
            valid = false;
        }
        return valid;
    }

    @Override
    public void onNeighborBlockChange(int id) {
        int meta = this.tileEntity.func_70322_n();
        boolean valid = this.isRailValid(this.getWorld(), this.tileEntity.field_70329_l, this.tileEntity.field_70330_m, this.tileEntity.field_70327_n, meta);
        if (!valid) {
            Block blockTrack = this.getBlock();
            blockTrack.func_71897_c(this.getWorld(), this.tileEntity.field_70329_l, this.tileEntity.field_70330_m, this.tileEntity.field_70327_n, 0, 0);
            this.getWorld().func_94575_c(this.tileEntity.field_70329_l, this.tileEntity.field_70330_m, this.tileEntity.field_70327_n, 0);
            return;
        }
        BlockRailBase blockTrack = (BlockRailBase)this.getBlock();
        if (id > 0 && Block.field_71973_m[id].func_71853_i() && this.isFlexibleRail() && new BlockBaseRailLogic(blockTrack, this.getWorld(), this.tileEntity.field_70329_l, this.tileEntity.field_70330_m, this.tileEntity.field_70327_n).func_94505_a() == 3) {
            this.switchTrack(false);
        }
        this.testPower();
    }

    protected void switchTrack(boolean flag) {
        int i = this.tileEntity.field_70329_l;
        int j = this.tileEntity.field_70330_m;
        int k = this.tileEntity.field_70327_n;
        BlockRailBase blockTrack = (BlockRailBase)this.getBlock();
        new BlockBaseRailLogic(blockTrack, this.getWorld(), i, j, k).func_94511_a(this.getWorld().func_72864_z(i, j, k), flag);
    }

    protected void testPower() {
        boolean powered;
        if (!(this instanceof ITrackPowered)) {
            return;
        }
        int i = this.tileEntity.field_70329_l;
        int j = this.tileEntity.field_70330_m;
        int k = this.tileEntity.field_70327_n;
        ITrackPowered r = (ITrackPowered)((Object)this);
        int meta = this.tileEntity.func_70322_n();
        boolean bl = powered = this.getWorld().func_72864_z(i, j, k) || this.testPowerPropagation(this.getWorld(), i, j, k, this.getTrackSpec(), meta, r.getPowerPropagation());
        if (powered != r.isPowered()) {
            r.setPowered(powered);
            Block blockTrack = this.getBlock();
            this.getWorld().func_72898_h(i, j, k, blockTrack.field_71990_ca);
            this.getWorld().func_72898_h(i, j - 1, k, blockTrack.field_71990_ca);
            if (meta == 2 || meta == 3 || meta == 4 || meta == 5) {
                this.getWorld().func_72898_h(i, j + 1, k, blockTrack.field_71990_ca);
            }
            this.sendUpdateToClient();
        }
    }

    protected boolean testPowerPropagation(World world, int i, int j, int k, TrackSpec spec, int meta, int maxDist) {
        return this.isConnectedRailPowered(world, i, j, k, spec, meta, true, 0, maxDist) || this.isConnectedRailPowered(world, i, j, k, spec, meta, false, 0, maxDist);
    }

    protected boolean isConnectedRailPowered(World world, int i, int j, int k, TrackSpec spec, int meta, boolean dir, int dist, int maxDist) {
        if (dist >= maxDist) {
            return false;
        }
        boolean powered = true;
        switch (meta) {
            case 0: {
                if (dir) {
                    ++k;
                    break;
                }
                --k;
                break;
            }
            case 1: {
                if (dir) {
                    --i;
                    break;
                }
                ++i;
                break;
            }
            case 2: {
                if (dir) {
                    --i;
                } else {
                    ++i;
                    ++j;
                    powered = false;
                }
                meta = 1;
                break;
            }
            case 3: {
                if (dir) {
                    --i;
                    ++j;
                    powered = false;
                } else {
                    ++i;
                }
                meta = 1;
                break;
            }
            case 4: {
                if (dir) {
                    ++k;
                } else {
                    --k;
                    ++j;
                    powered = false;
                }
                meta = 0;
                break;
            }
            case 5: {
                if (dir) {
                    ++k;
                    ++j;
                    powered = false;
                } else {
                    --k;
                }
                meta = 0;
            }
        }
        if (this.testPowered(world, i, j, k, spec, dir, dist, maxDist, meta)) {
            return true;
        }
        return powered && this.testPowered(world, i, j - 1, k, spec, dir, dist, maxDist, meta);
    }

    protected boolean testPowered(World world, int i, int j, int k, TrackSpec spec, boolean dir, int dist, int maxDist, int orientation) {
        int id = world.func_72798_a(i, j, k);
        Block blockTrack = this.getBlock();
        if (id == blockTrack.field_71990_ca) {
            int meta = world.func_72805_g(i, j, k);
            TileEntity tile = world.func_72796_p(i, j, k);
            if (tile instanceof ITrackTile) {
                ITrackInstance track = ((ITrackTile)tile).getTrackInstance();
                if (!(track instanceof ITrackPowered) || track.getTrackSpec() != spec) {
                    return false;
                }
                if (orientation == 1 && (meta == 0 || meta == 4 || meta == 5)) {
                    return false;
                }
                if (orientation == 0 && (meta == 1 || meta == 2 || meta == 3)) {
                    return false;
                }
                if (((ITrackPowered)track).isPowered()) {
                    if (world.func_72864_z(i, j, k) || world.func_72864_z(i, j + 1, k)) {
                        return true;
                    }
                    return this.isConnectedRailPowered(world, i, j, k, spec, meta, dir, dist + 1, maxDist);
                }
            }
        }
        return false;
    }

    @Override
    public Icon getIcon() {
        return this.getTrackSpec().getIcon();
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
    }

    @Override
    public boolean canUpdate() {
        return false;
    }

    @Override
    public void updateEntity() {
    }

    @Override
    public float getExplosionResistance(double srcX, double srcY, double srcZ, Entity exploder) {
        return 3.5f;
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
    }

    @Override
    public World getWorld() {
        return this.tileEntity.field_70331_k;
    }

    @Override
    public int getX() {
        return this.tileEntity.field_70329_l;
    }

    @Override
    public int getY() {
        return this.tileEntity.field_70330_m;
    }

    @Override
    public int getZ() {
        return this.tileEntity.field_70327_n;
    }

    @Override
    public boolean isFlexibleRail() {
        return false;
    }

    @Override
    public boolean canMakeSlopes() {
        return true;
    }

    @Override
    public float getRailMaxSpeed(EntityMinecart cart) {
        return 0.4f;
    }
}

