/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import java.util.List;
import mods.railcraft.client.render.LiquidRenderer;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.indicator.Indicator;
import mods.railcraft.common.gui.util.ToolTip;
import mods.railcraft.common.liquids.LiquidGauge;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.Icon;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public abstract class GuiContainerRailcraft
extends GuiContainer {
    private final RailcraftContainer container;
    public final String texturePath;

    public GuiContainerRailcraft(RailcraftContainer container, String texture) {
        super((Container)container);
        this.container = container;
        this.texturePath = texture;
    }

    public void func_73863_a(int mouseX, int mouseY, float par3) {
        super.func_73863_a(mouseX, mouseY, par3);
        int left = this.field_74198_m;
        int top = this.field_74197_n;
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)left, (float)top, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        InventoryPlayer playerInv = this.field_73882_e.field_71439_g.field_71071_by;
        if (playerInv.func_70445_o() == null) {
            List tips;
            for (LiquidGauge gauge : this.container.getGauges()) {
                if (!this.isMouseOverGauge(gauge, mouseX, mouseY)) continue;
                tips = gauge.getToolTip();
                if (tips == null) break;
                this.drawToolTips(tips, mouseX, mouseY);
                break;
            }
            for (Indicator indicator : this.container.getIndicators()) {
                if (!this.isMouseOverIndicator(indicator, mouseX, mouseY)) continue;
                tips = indicator.controller.getToolTip();
                if (tips == null) break;
                this.drawToolTips(tips, mouseX, mouseY);
                break;
            }
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    protected void func_74185_a(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b(this.texturePath);
        int x = (this.field_73880_f - this.field_74194_b) / 2;
        int y = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_74194_b, this.field_74195_c);
        for (LiquidGauge gauge : this.container.getGauges()) {
            this.drawLiquidGauge(gauge);
        }
        for (Indicator indicator : this.container.getIndicators()) {
            this.drawIndicator(indicator);
        }
    }

    private void drawButtons(int par1, int par2) {
        for (int var4 = 0; var4 < this.field_73887_h.size(); ++var4) {
            GuiButton var5 = (GuiButton)this.field_73887_h.get(var4);
            var5.func_73737_a(this.field_73882_e, par1, par2);
        }
    }

    protected void func_73864_a(int par1, int par2, int mouseButton) {
        super.func_73864_a(par1, par2, mouseButton);
        if (mouseButton == 2) {
            Slot var4 = this.getSlotAtPosition(par1, par2);
            int var5 = this.field_74198_m;
            int var6 = this.field_74197_n;
            boolean var7 = par1 < var5 || par2 < var6 || par1 >= var5 + this.field_74194_b || par2 >= var6 + this.field_74195_c;
            int var8 = -1;
            if (var4 != null) {
                var8 = var4.field_75222_d;
            }
            if (var7) {
                var8 = -999;
            }
            if (var8 != -1) {
                boolean var9 = var8 != -999 && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
                this.func_74191_a(var4, var8, mouseButton, var9 ? 1 : 0);
            }
        }
    }

    private Slot getSlotAtPosition(int par1, int par2) {
        for (int var3 = 0; var3 < this.field_74193_d.field_75151_b.size(); ++var3) {
            Slot var4 = (Slot)this.field_74193_d.field_75151_b.get(var3);
            if (!this.isMouseOverSlot(var4, par1, par2)) continue;
            return var4;
        }
        return null;
    }

    private boolean isMouseOverSlot(Slot par1Slot, int par2, int par3) {
        int var4 = this.field_74198_m;
        int var5 = this.field_74197_n;
        return (par2 -= var4) >= par1Slot.field_75223_e - 1 && par2 < par1Slot.field_75223_e + 16 + 1 && (par3 -= var5) >= par1Slot.field_75221_f - 1 && par3 < par1Slot.field_75221_f + 16 + 1;
    }

    private boolean isMouseOverGauge(LiquidGauge gauge, int mouseX, int mouseY) {
        int left = this.field_74198_m;
        int top = this.field_74197_n;
        return (mouseX -= left) >= gauge.x - 1 && mouseX < gauge.x + gauge.w + 1 && (mouseY -= top) >= gauge.y - 1 && mouseY < gauge.y + gauge.h + 1;
    }

    private boolean isMouseOverIndicator(Indicator indicator, int mouseX, int mouseY) {
        int left = this.field_74198_m;
        int top = this.field_74197_n;
        return (mouseX -= left) >= indicator.x - 1 && mouseX < indicator.x + indicator.w + 1 && (mouseY -= top) >= indicator.y - 1 && mouseY < indicator.y + indicator.h + 1;
    }

    private void drawToolTips(List toolTips, int mouseX, int mouseY) {
        if (toolTips.size() > 0) {
            int y;
            int left = this.field_74198_m;
            int top = this.field_74197_n;
            int lenght = 0;
            for (ToolTip tip : toolTips) {
                y = this.field_73886_k.func_78256_a(tip.text);
                if (y <= lenght) continue;
                lenght = y;
            }
            int x = mouseX - left + 12;
            y = mouseY - top - 12;
            int var14 = 8;
            if (toolTips.size() > 1) {
                var14 += 2 + (toolTips.size() - 1) * 10;
            }
            this.field_73735_i = 300.0f;
            GuiContainerRailcraft.field_74196_a.field_77023_b = 300.0f;
            int var15 = -267386864;
            this.func_73733_a(x - 3, y - 4, x + lenght + 3, y - 3, var15, var15);
            this.func_73733_a(x - 3, y + var14 + 3, x + lenght + 3, y + var14 + 4, var15, var15);
            this.func_73733_a(x - 3, y - 3, x + lenght + 3, y + var14 + 3, var15, var15);
            this.func_73733_a(x - 4, y - 3, x - 3, y + var14 + 3, var15, var15);
            this.func_73733_a(x + lenght + 3, y - 3, x + lenght + 4, y + var14 + 3, var15, var15);
            int var16 = 0x505000FF;
            int var17 = (var16 & 0xFEFEFE) >> 1 | var16 & 0xFF000000;
            this.func_73733_a(x - 3, y - 3 + 1, x - 3 + 1, y + var14 + 3 - 1, var16, var17);
            this.func_73733_a(x + lenght + 2, y - 3 + 1, x + lenght + 3, y + var14 + 3 - 1, var16, var17);
            this.func_73733_a(x - 3, y - 3, x + lenght + 3, y - 3 + 1, var16, var16);
            this.func_73733_a(x - 3, y + var14 + 2, x + lenght + 3, y + var14 + 3, var17, var17);
            boolean first = true;
            for (ToolTip tip : toolTips) {
                String line = tip.text;
                line = tip.color == -1 ? "\u00a77" + line : "\u00a7" + Integer.toHexString(tip.color) + line;
                this.field_73886_k.func_78261_a(line, x, y, -1);
                if (first) {
                    y += 2;
                    first = false;
                }
                y += 10;
            }
            this.field_73735_i = 0.0f;
            GuiContainerRailcraft.field_74196_a.field_77023_b = 0.0f;
        }
    }

    public void drawLiquidGauge(LiquidGauge gauge) {
        int guiX = (this.field_73880_f - this.field_74194_b) / 2;
        int guiY = (this.field_73881_g - this.field_74195_c) / 2;
        if (gauge.tank == null) {
            return;
        }
        LiquidStack liquid = gauge.tank.getLiquid();
        if (liquid == null) {
            return;
        }
        Icon liquidIcon = LiquidRenderer.getLiquidTexture(liquid);
        if (liquidIcon == null) {
            return;
        }
        float scale = (float)Math.min(liquid.amount, gauge.tank.getCapacity()) / (float)gauge.tank.getCapacity();
        this.field_73882_e.field_71446_o.func_98187_b(liquid.canonical().getTextureSheet());
        for (int col = 0; col < gauge.w / 16; ++col) {
            for (int row = 0; row <= gauge.h / 16; ++row) {
                this.func_94065_a(guiX + gauge.x + col * 16, guiY + gauge.y + row * 16 - 1, liquidIcon, 16, 16);
            }
        }
        this.field_73882_e.field_71446_o.func_98187_b(this.texturePath);
        this.func_73729_b(guiX + gauge.x, guiY + gauge.y - 1, gauge.x, gauge.y - 1, gauge.w, gauge.h - (int)Math.floor((float)gauge.h * scale) + 1);
        this.func_73729_b(guiX + gauge.x, guiY + gauge.y, this.field_74194_b, 0, gauge.w, gauge.h);
    }

    public void drawIndicator(Indicator indicator) {
        int x = (this.field_73880_f - this.field_74194_b) / 2;
        int y = (this.field_73881_g - this.field_74195_c) / 2;
        int scale = indicator.controller.getScaledLevel(indicator.h);
        this.func_73729_b(x + indicator.x, y + indicator.y + indicator.h - scale, indicator.u, indicator.v + indicator.h - scale, indicator.w, scale);
    }
}

