/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.buttons.GuiBetterButton;
import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.network.PacketCurrentItemNBT;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiTicket
extends GuiScreen {
    public static final String TEXTURE = "/mods/railcraft/textures/gui/ticket_gold.png";
    public static final int WRAP_WIDTH = 226;
    private final EntityPlayer player;
    private final ItemStack ticket;
    private boolean modified;
    private boolean readingManual;
    private int updateCount;
    private int imageWidth = 256;
    private int imageHeight = 192;
    private String dest = "";
    private GuiBetterButton buttonCancel;
    private GuiBetterButton buttonDone;
    private GuiBetterButton buttonHelp;

    public GuiTicket(EntityPlayer player, ItemStack stack) {
        this.player = player;
        this.ticket = stack;
        this.dest = ItemTicket.getDestination(this.ticket);
    }

    public void func_73876_c() {
        super.func_73876_c();
        ++this.updateCount;
    }

    public void func_73866_w_() {
        this.field_73887_h.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        ArrayList<GuiBetterButton> buttons = new ArrayList<GuiBetterButton>();
        this.buttonDone = new GuiBetterButton(0, 0, 4 + this.imageHeight, 65, 20, StatCollector.func_74838_a((String)"gui.done"));
        buttons.add(this.buttonDone);
        this.buttonHelp = new GuiBetterButton(1, 0, 4 + this.imageHeight, 65, 20, RailcraftLanguage.translate("gui.help"));
        buttons.add(this.buttonHelp);
        this.buttonCancel = new GuiBetterButton(2, 0, 4 + this.imageHeight, 65, 20, StatCollector.func_74838_a((String)"gui.cancel"));
        buttons.add(this.buttonCancel);
        GuiTools.newButtonRowAuto(this.field_73887_h, this.field_73880_f / 2 - 100, 200, buttons);
        this.updateButtons();
    }

    public void func_73874_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private void updateButtons() {
        this.buttonHelp.field_73744_e = this.readingManual ? StatCollector.func_74838_a((String)"gui.back") : RailcraftLanguage.translate("gui.help");
    }

    private void sendToServer() {
        if (this.modified) {
            NBTTagCompound nbt = InvTools.getItemData(this.ticket);
            nbt.func_74778_a("dest", this.dest);
            if (!nbt.func_74764_b("owner")) {
                nbt.func_74778_a("owner", this.player.field_71092_bJ);
            }
            PacketCurrentItemNBT pkt = new PacketCurrentItemNBT(this.ticket);
            PacketDispatcher.sendPacketToServer((Packet)pkt.getPacket());
        }
    }

    protected void func_73875_a(GuiButton button) {
        if (button.field_73742_g) {
            if (button == this.buttonCancel) {
                this.field_73882_e.func_71373_a((GuiScreen)null);
            } else if (button == this.buttonDone) {
                this.field_73882_e.func_71373_a((GuiScreen)null);
                this.sendToServer();
            } else if (button == this.buttonHelp) {
                this.readingManual = !this.readingManual;
            }
            this.updateButtons();
        }
    }

    protected void func_73869_a(char c, int key) {
        super.func_73869_a(c, key);
        switch (c) {
            case '\u0016': {
                this.dest = this.dest + GuiScreen.func_73870_l();
                this.modified = true;
                return;
            }
        }
        switch (key) {
            case 14: {
                if (this.dest.length() > 0) {
                    this.dest = this.dest.substring(0, this.dest.length() - 1);
                    this.modified = true;
                }
                return;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)c)) {
            this.dest = this.dest + c;
            this.modified = true;
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b(TEXTURE);
        int xOffset = (this.field_73880_f - this.imageWidth) / 2;
        int yOffset = 2;
        this.func_73729_b(xOffset, yOffset, 0, 0, this.imageWidth, this.imageHeight);
        if (this.readingManual) {
            GuiTools.drawCenteredString(this.field_73886_k, RailcraftLanguage.translate("gui.routing.ticket.manual.title"), yOffset + 30, this.field_73880_f);
            String text = RailcraftLanguage.translate("gui.routing.ticket.manual");
            this.field_73886_k.func_78279_b(text, xOffset + 16, yOffset + 30 + 16, 226, 0);
        } else {
            GL11.glPushMatrix();
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            GuiTools.drawCenteredString(this.field_73886_k, EnumChatFormatting.BOLD + RailcraftLanguage.translate("gui.routing.ticket.title"), yOffset + 15, this.field_73880_f / 2, 0xFFFFFF, true);
            GL11.glPopMatrix();
            GuiTools.drawCenteredString(this.field_73886_k, RailcraftLanguage.translate("gui.routing.ticket.line1"), yOffset + 65, this.field_73880_f);
            GuiTools.drawCenteredString(this.field_73886_k, RailcraftLanguage.translate("gui.routing.ticket.line2"), yOffset + 80, this.field_73880_f);
            String text = EnumChatFormatting.BLACK + this.dest;
            text = this.field_73886_k.func_78260_a() ? text + "_" : (this.updateCount / 6 % 2 == 0 ? text + "" + EnumChatFormatting.BLACK + "_" : text + "" + EnumChatFormatting.GRAY + "_");
            this.field_73886_k.func_78279_b(text, xOffset + 16, yOffset + 110, 226, 0);
        }
        super.func_73863_a(par1, par2, par3);
    }
}

