/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import java.util.Random;
import mods.railcraft.client.render.IInvRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRenderer
implements IItemRenderer {
    private IInvRenderer renderer;
    private final Random rand = new Random();

    public ItemRenderer(IInvRenderer renderer) {
        this.renderer = renderer;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        switch (helper) {
            case BLOCK_3D: {
                return false;
            }
        }
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case EQUIPPED: {
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                this.renderer.renderItem((RenderBlocks)data[0], item, IItemRenderer.ItemRenderType.EQUIPPED);
                break;
            }
            case INVENTORY: {
                this.renderer.renderItem((RenderBlocks)data[0], item, IItemRenderer.ItemRenderType.INVENTORY);
                break;
            }
            case ENTITY: {
                this.renderEntity((RenderBlocks)data[0], (EntityItem)data[1]);
            }
        }
    }

    protected void renderEntity(RenderBlocks render, EntityItem item) {
        this.rand.setSeed(187L);
        int num = 1;
        ItemStack stack = item.func_92059_d();
        if (stack.field_77994_a > 1) {
            num = 2;
        }
        if (stack.field_77994_a > 5) {
            num = 3;
        }
        if (stack.field_77994_a > 20) {
            num = 4;
        }
        float scale = 0.5f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        if (render.field_78668_c) {
            int color = stack.func_77973_b().func_82790_a(stack, 0);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        }
        for (int ii = 0; ii < num; ++ii) {
            GL11.glPushMatrix();
            if (ii > 0) {
                float x = (this.rand.nextFloat() * 2.0f - 1.0f) * 0.2f / scale;
                float y = (this.rand.nextFloat() * 2.0f - 1.0f) * 0.2f / scale;
                float z = (this.rand.nextFloat() * 2.0f - 1.0f) * 0.2f / scale;
                GL11.glTranslatef((float)x, (float)y, (float)z);
            }
            this.renderer.renderItem(render, stack, IItemRenderer.ItemRenderType.ENTITY);
            GL11.glPopMatrix();
        }
    }
}

