/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import mods.railcraft.client.render.LiquidRenderer;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.beta.TileTankIron;
import mods.railcraft.common.blocks.machine.beta.TileTankIronValve;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.liquids.TankManager;
import mods.railcraft.common.liquids.tanks.StandardTank;
import mods.railcraft.common.util.misc.FakeBlockRenderInfo;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

public class RenderIronTank
extends TileEntitySpecialRenderer {
    private static final FakeBlockRenderInfo fillBlock = new FakeBlockRenderInfo();

    public RenderIronTank() {
        float pix = 0.0625f;
        RenderIronTank.fillBlock.minX = 5.0f * pix;
        RenderIronTank.fillBlock.minZ = 5.0f * pix;
        RenderIronTank.fillBlock.maxX = 11.0f * pix;
        RenderIronTank.fillBlock.maxZ = 11.0f * pix;
        RenderIronTank.fillBlock.texture = new Icon[6];
    }

    private void prepFillTexture(LiquidStack liquid) {
        String texSheet = LiquidRenderer.setupFlowingLiquidTexture(liquid, RenderIronTank.fillBlock.texture);
        if (texSheet != null) {
            this.func_76897_a(texSheet);
        }
    }

    private float getVerticalScaleSide(TileMultiBlock tile) {
        int y = tile.getPatternPositionY();
        if (!RailcraftConfig.allowTankStacking()) {
            --y;
        }
        return (float)y - 0.3125f;
    }

    private int getTankHeight(TileMultiBlock tile) {
        int height = tile.getPattern().getPatternHeight();
        if (!RailcraftConfig.allowTankStacking()) {
            height -= 2;
        }
        return height;
    }

    private void draw() {
        this.preGL();
        RenderFakeBlock.renderBlockForEntity(fillBlock, null, 0, 0, 0, false, true);
        this.postGL();
    }

    private void preGL() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
    }

    private void postGL() {
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public void func_76894_a(TileEntity tile, double x, double y, double z, float f) {
        TileTankIron ironTank;
        TileTankIronValve valve;
        if (!((TileMultiBlock)tile).isStructureValid()) {
            return;
        }
        if (tile instanceof TileTankIronValve && (valve = (TileTankIronValve)tile).isFilling()) {
            TankManager tMan = valve.getTankManager();
            LiquidStack liquid = null;
            if (tMan != null) {
                liquid = tMan.getTank(0).getLiquid();
            }
            if (liquid != null && liquid.amount > 0 && Item.field_77698_e[liquid.itemID] != null) {
                float yOffset;
                GL11.glPushMatrix();
                if (valve.getPattern().getPatternMarkerChecked(valve.getPatternPositionX(), valve.getPatternPositionY() - 1, valve.getPatternPositionZ()) == 'A') {
                    this.prepFillTexture(liquid);
                    int height = this.getTankHeight(valve);
                    yOffset = (float)height / 2.0f;
                    float vScale = (float)height - 2.0f;
                    GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + yOffset - (float)height + 1.0f), (float)((float)z + 0.5f));
                    GL11.glScalef((float)1.0f, (float)vScale, (float)1.0f);
                    this.draw();
                } else if (valve.getPattern().getPatternMarkerChecked(valve.getPatternPositionX() - 1, valve.getPatternPositionY(), valve.getPatternPositionZ()) == 'A') {
                    this.prepFillTexture(liquid);
                    float vScale = this.getVerticalScaleSide(valve);
                    yOffset = 0.5f - vScale / 2.0f + 0.1875f;
                    GL11.glTranslatef((float)((float)x - 0.5f + 0.3125f), (float)((float)y + yOffset), (float)((float)z + 0.5f));
                    GL11.glScalef((float)1.0f, (float)vScale, (float)1.0f);
                    this.draw();
                } else if (valve.getPattern().getPatternMarkerChecked(valve.getPatternPositionX() + 1, valve.getPatternPositionY(), valve.getPatternPositionZ()) == 'A') {
                    this.prepFillTexture(liquid);
                    float vScale = this.getVerticalScaleSide(valve);
                    yOffset = 0.5f - vScale / 2.0f + 0.1875f;
                    GL11.glTranslatef((float)((float)x + 1.5f - 0.3125f), (float)((float)y + yOffset), (float)((float)z + 0.5f));
                    GL11.glScalef((float)1.0f, (float)vScale, (float)1.0f);
                    this.draw();
                } else if (valve.getPattern().getPatternMarkerChecked(valve.getPatternPositionX(), valve.getPatternPositionY(), valve.getPatternPositionZ() - 1) == 'A') {
                    this.prepFillTexture(liquid);
                    float vScale = this.getVerticalScaleSide(valve);
                    yOffset = 0.5f - vScale / 2.0f + 0.1875f;
                    GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + yOffset), (float)((float)z - 0.5f + 0.3125f));
                    GL11.glScalef((float)1.0f, (float)vScale, (float)1.0f);
                    this.draw();
                } else if (valve.getPattern().getPatternMarkerChecked(valve.getPatternPositionX(), valve.getPatternPositionY(), valve.getPatternPositionZ() + 1) == 'A') {
                    this.prepFillTexture(liquid);
                    float vScale = this.getVerticalScaleSide(valve);
                    yOffset = 0.5f - vScale / 2.0f + 0.1875f;
                    GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + yOffset), (float)((float)z + 1.5f - 0.3125f));
                    GL11.glScalef((float)1.0f, (float)vScale, (float)1.0f);
                    this.draw();
                }
                GL11.glPopMatrix();
            }
        }
        if (!(ironTank = (TileTankIron)tile).isMaster() || ironTank.func_70320_p()) {
            return;
        }
        int height = this.getTankHeight(ironTank);
        float yOffset = (float)height / 2.0f;
        float vScale = height - 2;
        float hScale = ironTank.getPattern().getPatternWidthX() - 2;
        TankManager tankManager = ironTank.getTankManager();
        if (tankManager == null) {
            return;
        }
        StandardTank tank = tankManager.getTank(0);
        if (tank == null) {
            return;
        }
        LiquidStack liquid = tank.getLiquid();
        if (liquid != null && liquid.amount > 0 && Item.field_77698_e[liquid.itemID] != null) {
            this.preGL();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + yOffset + 0.01f), (float)((float)z + 0.5f));
            GL11.glScalef((float)hScale, (float)vScale, (float)hScale);
            int[] displayLists = LiquidRenderer.getLiquidDisplayLists(liquid);
            if (displayLists != null) {
                GL11.glPushMatrix();
                float cap = tank.getCapacity();
                float level = Math.min((float)liquid.amount, cap) / cap;
                this.func_76897_a(liquid.canonical().getTextureSheet());
                GL11.glCallList((int)displayLists[(int)(level * 99.0f)]);
                GL11.glPopMatrix();
            }
            this.postGL();
        }
    }
}

