/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.wall;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import mods.railcraft.client.sounds.RailcraftSound;
import mods.railcraft.common.blocks.aesthetics.wall.EnumWallAlpha;
import mods.railcraft.common.blocks.aesthetics.wall.EnumWallBeta;
import mods.railcraft.common.blocks.aesthetics.wall.ItemWall;
import mods.railcraft.common.blocks.aesthetics.wall.WallInfo;
import mods.railcraft.common.blocks.aesthetics.wall.WallProxy;
import mods.railcraft.common.blocks.aesthetics.wall.WallProxyApha;
import mods.railcraft.common.blocks.aesthetics.wall.WallProxyBeta;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class BlockRailcraftWall
extends BlockWall {
    private static BlockRailcraftWall alpha;
    private static BlockRailcraftWall beta;
    public static int currentRenderPass;
    private final int renderId;
    public final WallProxy proxy;
    private final boolean alphaBlend;

    public static BlockRailcraftWall getBlockAlpha() {
        return alpha;
    }

    public static BlockRailcraftWall getBlockBeta() {
        return beta;
    }

    public static void registerBlocks() {
        int renderId;
        int id;
        if (alpha == null && (id = RailcraftConfig.getBlockId("block.wall.alpha")) > 0) {
            renderId = Railcraft.getProxy().getRenderId();
            alpha = new BlockRailcraftWall(id, renderId, true, new WallProxyApha());
            alpha.func_71864_b("railcraft.wall.alpha");
            GameRegistry.registerBlock((Block)alpha, ItemWall.class, (String)alpha.func_71917_a());
            for (Enum enum_ : EnumWallAlpha.VALUES) {
                switch (1.$SwitchMap$mods$railcraft$common$blocks$aesthetics$wall$EnumWallAlpha[enum_.ordinal()]) {
                    case 1: {
                        MinecraftForge.setBlockHarvestLevel((Block)alpha, (int)enum_.ordinal(), (String)"shovel", (int)0);
                        break;
                    }
                    case 2: {
                        MinecraftForge.setBlockHarvestLevel((Block)alpha, (int)enum_.ordinal(), (String)"pickaxe", (int)3);
                        break;
                    }
                    default: {
                        MinecraftForge.setBlockHarvestLevel((Block)alpha, (int)enum_.ordinal(), (String)"pickaxe", (int)2);
                    }
                }
                RailcraftLanguage.instance().registerItemName(((EnumWallAlpha)enum_).getItem(), ((EnumWallAlpha)enum_).getTag());
                ItemRegistry.registerItem(((EnumWallAlpha)enum_).getTag(), ((EnumWallAlpha)enum_).getItem());
                if (enum_ == EnumWallAlpha.SNOW && enum_ == EnumWallAlpha.ICE) continue;
                ForestryPlugin.addBackpackItem("builder", ((EnumWallAlpha)enum_).getItem());
            }
        }
        if (beta == null && (id = RailcraftConfig.getBlockId("block.wall.beta")) > 0) {
            renderId = Railcraft.getProxy().getRenderId();
            beta = new BlockRailcraftWall(id, renderId, false, new WallProxyBeta());
            beta.func_71864_b("railcraft.wall.beta");
            GameRegistry.registerBlock((Block)beta, ItemWall.class, (String)beta.func_71917_a());
            for (Enum enum_ : EnumWallBeta.VALUES) {
                switch (1.$SwitchMap$mods$railcraft$common$blocks$aesthetics$wall$EnumWallBeta[enum_.ordinal()]) {
                    default: 
                }
                MinecraftForge.setBlockHarvestLevel((Block)beta, (int)enum_.ordinal(), (String)"pickaxe", (int)2);
                RailcraftLanguage.instance().registerItemName(((EnumWallBeta)enum_).getItem(), ((EnumWallBeta)enum_).getTag());
                ItemRegistry.registerItem(((EnumWallBeta)enum_).getTag(), ((EnumWallBeta)enum_).getItem());
                ForestryPlugin.addBackpackItem("builder", ((EnumWallBeta)enum_).getItem());
            }
        }
    }

    public static void initialize() {
        EnumWallAlpha.initialize();
        EnumWallBeta.initialize();
    }

    public BlockRailcraftWall(int id, int renderId, boolean alphaBlend, WallProxy proxy) {
        super(id, Block.field_72007_bm);
        this.renderId = renderId;
        this.alphaBlend = alphaBlend;
        this.proxy = proxy;
        this.func_71884_a(RailcraftSound.getInstance());
        this.func_71849_a(CreativePlugin.TAB);
    }

    public Icon func_71858_a(int side, int meta) {
        WallInfo wall = this.proxy.fromMeta(meta);
        Block source = wall.getSource();
        if (source == null) {
            return Block.field_71978_w.func_71858_a(side, 0);
        }
        return source.func_71858_a(side, wall.getSourceMeta());
    }

    public int func_71857_b() {
        return this.renderId;
    }

    public int func_71856_s_() {
        return this.alphaBlend ? 1 : 0;
    }

    public boolean canRenderInPass(int pass) {
        currentRenderPass = pass;
        if (!this.alphaBlend) {
            return this.func_71856_s_() == pass;
        }
        return pass == 0 || pass == 1;
    }

    public boolean func_82538_d(IBlockAccess world, int x, int y, int z) {
        int blockId = world.func_72798_a(x, y, z);
        if (Block.field_71973_m[blockId] instanceof BlockRailcraftWall) {
            return true;
        }
        if (blockId != this.field_71990_ca && blockId != Block.field_71993_bv.field_71990_ca) {
            Block block = Block.field_71973_m[blockId];
            return block != null && block.field_72018_cp.func_76218_k() && block.func_71886_c() ? block.field_72018_cp != Material.field_76266_z : false;
        }
        return true;
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return true;
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (WallInfo wall : this.proxy.values()) {
            if (!wall.isEnabled()) continue;
            list.add(wall.getItem());
        }
    }

    public float func_71934_m(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        WallInfo wall = this.proxy.fromMeta(meta);
        return wall.getBlockHardness(world, x, y, z);
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int meta = world.func_72805_g(x, y, z);
        WallInfo wall = this.proxy.fromMeta(meta);
        return wall.getExplosionResistance(entity);
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$mods$railcraft$common$blocks$aesthetics$wall$EnumWallAlpha;
        static final /* synthetic */ int[] $SwitchMap$mods$railcraft$common$blocks$aesthetics$wall$EnumWallBeta;

        static {
            $SwitchMap$mods$railcraft$common$blocks$aesthetics$wall$EnumWallBeta = new int[EnumWallBeta.values().length];
            $SwitchMap$mods$railcraft$common$blocks$aesthetics$wall$EnumWallAlpha = new int[EnumWallAlpha.values().length];
            try {
                1.$SwitchMap$mods$railcraft$common$blocks$aesthetics$wall$EnumWallAlpha[EnumWallAlpha.SNOW.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$mods$railcraft$common$blocks$aesthetics$wall$EnumWallAlpha[EnumWallAlpha.OBSIDIAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

