/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.IExplosiveCart;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.detector.BlockDetector;
import mods.railcraft.common.carts.EntityCartEnergy;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.misc.SafeNBTWrapper;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public class TileDetector
extends RailcraftTileEntity {
    public static final float SENSITIVITY = 0.2f;
    public ForgeDirection direction = ForgeDirection.UP;
    public int powerState = 0;
    private int update = MiscTools.getRand().nextInt();

    @Override
    public String func_70303_b() {
        return RailcraftLanguage.translate(BlockDetector.getBlockNameFromMetadata(this.func_70322_n()));
    }

    public List getCarts() {
        return CartTools.getMinecartsOnAllSides(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0.2f);
    }

    public int testCarts() {
        block10: {
            List carts;
            int meta;
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block9: {
                                    meta = this.func_70322_n();
                                    carts = this.getCarts();
                                    if (meta == BlockDetector.EnumDetector.ANY.ordinal()) {
                                        return carts.isEmpty() ? 0 : 15;
                                    }
                                    if (meta != BlockDetector.EnumDetector.EMPTY.ordinal()) break block9;
                                    for (EntityMinecart cart : carts) {
                                        if (!cart.canBeRidden() || cart.field_70153_n != null) continue;
                                        return 15;
                                    }
                                    break block10;
                                }
                                if (meta != BlockDetector.EnumDetector.MOB.ordinal()) break block11;
                                for (EntityMinecart cart : carts) {
                                    if (cart.field_70153_n == null || !(cart.field_70153_n instanceof IMob)) continue;
                                    return 15;
                                }
                                break block10;
                            }
                            if (meta != BlockDetector.EnumDetector.POWERED.ordinal()) break block12;
                            for (EntityMinecart cart : carts) {
                                if (!cart.isPoweredCart()) continue;
                                return 15;
                            }
                            break block10;
                        }
                        if (meta != BlockDetector.EnumDetector.PLAYER.ordinal()) break block13;
                        for (EntityMinecart cart : carts) {
                            if (!(cart.field_70153_n instanceof EntityPlayer)) continue;
                            return 15;
                        }
                        break block10;
                    }
                    if (meta != BlockDetector.EnumDetector.EXPLOSIVE.ordinal()) break block14;
                    for (EntityMinecart cart : carts) {
                        if (!(cart instanceof IExplosiveCart)) continue;
                        return 15;
                    }
                    break block10;
                }
                if (meta != BlockDetector.EnumDetector.ENERGY.ordinal()) break block15;
                for (EntityMinecart cart : carts) {
                    if (!(cart instanceof EntityCartEnergy)) continue;
                    return 15;
                }
                break block10;
            }
            if (meta != BlockDetector.EnumDetector.AGE.ordinal()) break block10;
            for (EntityMinecart cart : carts) {
                if (cart.field_70153_n instanceof EntityAgeable) {
                    EntityAgeable ageable = (EntityAgeable)cart.field_70153_n;
                    return ageable.func_70631_g_() ? 0 : 15;
                }
                if (cart.field_70153_n == null) continue;
                return 15;
            }
        }
        return 0;
    }

    public boolean blockActivated(EntityPlayer player) {
        return false;
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74774_a("direction", (byte)this.direction.ordinal());
        data.func_74774_a("powerState", (byte)this.powerState);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        SafeNBTWrapper safe = new SafeNBTWrapper(data);
        this.direction = ForgeDirection.getOrientation((int)safe.getByte("direction"));
        this.powerState = data.func_74771_c("powerState");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.powerState);
        data.writeByte(this.direction.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powerState = data.readByte();
        this.direction = ForgeDirection.getOrientation((int)data.readByte());
        this.markBlockForUpdate();
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_70316_g() {
        int newPowerState;
        ++this.update;
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        if ((this.updateInterval() == 0 || this.update % this.updateInterval() == 0) && (newPowerState = this.testCarts()) != this.powerState) {
            this.powerState = newPowerState;
            this.sendUpdateToClient();
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, RailcraftBlocks.getBlockDetector().field_71990_ca);
            MiscTools.notifyBlocksOfNeighborChangeOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, RailcraftBlocks.getBlockDetector().field_71990_ca, this.direction);
        }
    }

    protected short updateInterval() {
        return 0;
    }

    @Override
    public short getId() {
        return (short)this.func_70322_n();
    }

    public void onBlockRemoval() {
    }
}

