/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.detector.TileDetectorFilter;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.gui.slots.ISlotController;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileDetectorItem
extends TileDetectorFilter
implements IGuiReturnHandler {
    private PrimaryMode primaryMode = PrimaryMode.ANYTHING;
    private FilterMode filterMode = FilterMode.AT_LEAST;

    public TileDetectorItem() {
        super(9);
    }

    @Override
    public int testCarts() {
        List carts = CartTools.getMinecartsOnAllSides(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0.2f);
        block8: for (EntityMinecart cart : carts) {
            IInventory cartInv = null;
            if (cart instanceof IInventory) {
                cartInv = (IInventory)cart;
            }
            if (cartInv == null || cartInv.func_70302_i_() <= 0) continue;
            switch (this.primaryMode) {
                case ANYTHING: {
                    return 15;
                }
                case EMPTY: {
                    if (!InvTools.isInventoryEmpty(cartInv)) continue block8;
                    return 15;
                }
                case FULL: {
                    if (!InvTools.isInventoryFull(cartInv)) continue block8;
                    return 15;
                }
                case FILTERED: {
                    if (!this.matchesFilter(cartInv)) continue block8;
                    return 15;
                }
                case NOT_EMPTY: {
                    if (InvTools.isInventoryEmpty(cartInv)) continue block8;
                    return 15;
                }
                case ANALOG: {
                    return Container.func_94526_b((IInventory)cartInv);
                }
            }
        }
        return 0;
    }

    private boolean matchesFilter(IInventory cartInv) {
        block5: for (int i = 0; i < this.getFilters().func_70302_i_(); ++i) {
            ItemStack filter = this.getFilters().func_70301_a(i);
            if (filter == null) continue;
            int amountFilter = InvTools.countItems((IInventory)this.getFilters(), filter);
            int amountCart = InvTools.countItems(cartInv, filter);
            switch (this.filterMode) {
                case EXACTLY: {
                    if (amountCart == amountFilter) continue block5;
                    return false;
                }
                case AT_LEAST: {
                    if (amountCart >= amountFilter) continue block5;
                    return false;
                }
                case AT_MOST: {
                    if (amountCart <= amountFilter) continue block5;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74774_a("primaryMode", (byte)this.primaryMode.ordinal());
        data.func_74774_a("filterMode", (byte)this.filterMode.ordinal());
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.primaryMode = PrimaryMode.values()[data.func_74771_c("primaryMode")];
        this.filterMode = FilterMode.values()[data.func_74771_c("filterMode")];
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte((byte)this.primaryMode.ordinal());
        data.writeByte((byte)this.filterMode.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.primaryMode = PrimaryMode.values()[data.readByte()];
        this.filterMode = FilterMode.values()[data.readByte()];
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte((byte)this.primaryMode.ordinal());
        data.writeByte((byte)this.filterMode.ordinal());
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        this.primaryMode = PrimaryMode.values()[data.readByte()];
        this.filterMode = FilterMode.values()[data.readByte()];
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.DETECTOR_ITEM, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    public PrimaryMode getPrimaryMode() {
        return this.primaryMode;
    }

    public FilterMode getFilterMode() {
        return this.filterMode;
    }

    public void setPrimaryMode(PrimaryMode primaryMode) {
        this.primaryMode = primaryMode;
    }

    public void setFilterMode(FilterMode filterMode) {
        this.filterMode = filterMode;
    }

    public ISlotController getSlotController() {
        return new ISlotController(){

            @Override
            public boolean isSlotEnabled() {
                return TileDetectorItem.this.getPrimaryMode() == PrimaryMode.FILTERED;
            }
        };
    }

    public static enum FilterMode {
        AT_LEAST,
        AT_MOST,
        EXACTLY;


        public String toString() {
            return RailcraftLanguage.translate("gui.detector.item." + this.name().toLowerCase(Locale.ENGLISH));
        }
    }

    public static enum PrimaryMode {
        EMPTY,
        FULL,
        ANYTHING,
        FILTERED,
        NOT_EMPTY,
        ANALOG;


        public String toString() {
            return RailcraftLanguage.translate("gui.detector.item." + this.name().toLowerCase(Locale.ENGLISH));
        }
    }
}

