/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.detector.TileDetectorFilter;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.gui.util.IMultiButtonState;
import mods.railcraft.common.gui.util.MultiButtonController;
import mods.railcraft.common.liquids.LiquidManager;
import mods.railcraft.common.liquids.TankToolkit;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class TileDetectorTank
extends TileDetectorFilter
implements IGuiReturnHandler {
    private final MultiButtonController buttonController = MultiButtonController.getController(ButtonState.ANALOG.ordinal(), ButtonState.values());

    public TileDetectorTank() {
        super(1);
    }

    public MultiButtonController getButtonController() {
        return this.buttonController;
    }

    public LiquidStack getFilterLiquid() {
        ItemStack filter = this.getFilters().func_70301_a(0);
        if (filter != null) {
            return LiquidManager.instance().getLiquidInContainer(filter);
        }
        return null;
    }

    @Override
    public int testCarts() {
        List carts = CartTools.getMinecartsOnAllSides(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0.2f);
        for (EntityMinecart cart : carts) {
            if (!(cart instanceof ITankContainer)) continue;
            TankToolkit tank = new TankToolkit((ITankContainer)cart);
            boolean liquidMatches = false;
            LiquidStack filterLiquid = this.getFilterLiquid();
            LiquidStack tankLiquid = tank.drain(ForgeDirection.UNKNOWN, 1, false);
            if (filterLiquid == null) {
                liquidMatches = true;
            } else if (filterLiquid.isLiquidEqual(tankLiquid)) {
                liquidMatches = true;
            } else if (tank.canPutLiquid(ForgeDirection.UNKNOWN, filterLiquid)) {
                liquidMatches = true;
            }
            boolean quantityMatches = false;
            ButtonState state = (ButtonState)this.buttonController.getButtonState();
            block0 : switch (state) {
                case VOID: {
                    quantityMatches = true;
                    break;
                }
                case EMPTY: {
                    if (filterLiquid != null && tank.isTankEmpty(filterLiquid)) {
                        quantityMatches = true;
                        break;
                    }
                    if (filterLiquid != null || !tank.areTanksEmpty()) break;
                    quantityMatches = true;
                    break;
                }
                case NOT_EMPTY: {
                    if (filterLiquid != null && tank.getLiquidQty(filterLiquid) > 0) {
                        quantityMatches = true;
                        break;
                    }
                    if (filterLiquid != null || !tank.isLiquidInTank()) break;
                    quantityMatches = true;
                    break;
                }
                case FULL: {
                    if (filterLiquid != null && tank.isTankFull(filterLiquid)) {
                        quantityMatches = true;
                        break;
                    }
                    if (filterLiquid != null || !tank.areTanksFull()) break;
                    quantityMatches = true;
                    break;
                }
                default: {
                    float level = filterLiquid != null ? tank.getLiquidLevel(filterLiquid) : tank.getLiquidLevel();
                    switch (state) {
                        case ANALOG: {
                            return (int)(15.0f * level);
                        }
                        case QUARTER: {
                            quantityMatches = level >= 0.25f;
                            break block0;
                        }
                        case HALF: {
                            quantityMatches = level >= 0.5f;
                            break block0;
                        }
                        case MOST: {
                            quantityMatches = level >= 0.75f;
                            break block0;
                        }
                        case LESS_THAN_QUARTER: {
                            quantityMatches = level < 0.25f;
                            break block0;
                        }
                        case LESS_THAN_HALF: {
                            quantityMatches = level < 0.5f;
                            break block0;
                        }
                        case LESS_THAN_MOST: {
                            quantityMatches = level < 0.75f;
                            break block0;
                        }
                        case LESS_THAN_FULL: {
                            quantityMatches = level < 1.0f;
                        }
                    }
                }
            }
            return liquidMatches && quantityMatches ? 15 : 0;
        }
        return 0;
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.DETECTOR_TANK, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74774_a("state", (byte)this.buttonController.getCurrentState());
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.buttonController.setCurrentState(data.func_74771_c("state"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.buttonController.getCurrentState());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.buttonController.setCurrentState(data.readByte());
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.buttonController.getCurrentState());
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        this.buttonController.setCurrentState(data.readByte());
    }

    public static enum ButtonState implements IMultiButtonState
    {
        VOID("L = ?"),
        EMPTY("L = 0%"),
        NOT_EMPTY("L > 0%"),
        FULL("L = 100%"),
        QUARTER("L >= 25%"),
        HALF("L >= 50%"),
        MOST("L >= 75%"),
        LESS_THAN_QUARTER("L < 25%"),
        LESS_THAN_HALF("L < 50%"),
        LESS_THAN_MOST("L < 75%"),
        LESS_THAN_FULL("L < 100%"),
        ANALOG("L = ~");

        private final String label;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private ButtonState() {
            void label;
            this.label = label;
        }

        @Override
        public String getLabel() {
            return this.label;
        }
    }
}

