/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.detector.TileDetector;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class TileDetectorVillager
extends TileDetector
implements IGuiReturnHandler {
    private int profession;
    private Mode mode = Mode.ANY;

    private boolean cartHasVillager() {
        for (EntityMinecart cart : this.getCarts()) {
            if (!(cart.field_70153_n instanceof EntityVillager)) continue;
            return true;
        }
        return false;
    }

    private boolean cartHasProfesion() {
        for (EntityMinecart cart : this.getCarts()) {
            EntityVillager villager;
            if (!(cart.field_70153_n instanceof EntityVillager) || (villager = (EntityVillager)cart.field_70153_n).func_70946_n() != this.profession) continue;
            return true;
        }
        return false;
    }

    @Override
    public int testCarts() {
        switch (this.mode) {
            case ANY: {
                return this.cartHasVillager() ? 15 : 0;
            }
            case NONE: {
                return !this.cartHasVillager() ? 15 : 0;
            }
            case EQUALS: {
                return this.cartHasProfesion() ? 15 : 0;
            }
            case NOT: {
                return !this.cartHasProfesion() ? 15 : 0;
            }
        }
        return 0;
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.DETECTOR_VILLAGER, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setProfession(int profession) {
        this.profession = profession;
    }

    public int getProfession() {
        return this.profession;
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("profession", this.profession);
        data.func_74774_a("mode", (byte)this.mode.ordinal());
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.profession = data.func_74762_e("profession");
        this.mode = Mode.values()[data.func_74771_c("mode")];
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeInt(this.profession);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.profession = data.readInt();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeInt(this.profession);
        data.writeByte(this.mode.ordinal());
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        this.profession = data.readInt();
        this.mode = Mode.values()[data.readByte()];
    }

    public static enum Mode {
        ANY,
        NONE,
        NOT,
        EQUALS;

    }
}

