/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import buildcraft.api.gates.IAction;
import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineItem;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.gui.indicator.IIndicatorController;
import mods.railcraft.common.gui.util.ToolTip;
import mods.railcraft.common.plugins.buildcraft.actions.Actions;
import mods.railcraft.common.plugins.buildcraft.triggers.IHasWork;
import mods.railcraft.common.util.crafting.RollingMachineCraftingManager;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.InventoryCopy;
import mods.railcraft.common.util.inventory.InventoryMapper;
import mods.railcraft.common.util.inventory.ItemStackSizeSorter;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class TileRollingMachine
extends TileMachineItem
implements ISpecialInventory,
IPowerReceptor,
ISidedInventory,
IHasWork {
    private static final int PROCESS_TIME = 100;
    private static final int ACTIVATION_POWER = 5;
    private static final int MAX_RECEIVE = 100;
    private static final int MAX_ENERGY = 500;
    private static final int SLOT_RESULT = 0;
    private InventoryCrafting craftMatrix = new InventoryCrafting((Container)new RollingContainer(), 3, 3);
    private IInventory invResult = new InventoryMapper(this, 0, 1, false);
    private IInventory invBuffer = new InventoryMapper(this, 1, 4);
    private IPowerProvider provider;
    public boolean useLast;
    private boolean isWorking;
    private boolean paused;
    private int progress;
    private int update;
    public int guiEnergy;
    private final Set actions = new HashSet();
    private IIndicatorController energyIndicator = new EnergyIndicator();

    public IIndicatorController getEnergyIndicator() {
        return this.energyIndicator;
    }

    public TileRollingMachine() {
        super(5);
        if (PowerFramework.currentFramework != null) {
            this.provider = PowerFramework.currentFramework.createPowerProvider();
            this.initPowerProvider();
        }
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.ROLLING_MACHINE;
    }

    private void initPowerProvider() {
        if (PowerFramework.currentFramework != null) {
            this.provider.configure(0, 1, 100, 5, 500);
            this.provider.configurePowerPerdition(1, 40);
        }
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.provider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.provider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public int powerRequest(ForgeDirection side) {
        if (this.provider != null) {
            return (int)Math.ceil(Math.min((float)this.provider.getMaxEnergyReceived(), (float)this.provider.getMaxEnergyStored() - this.provider.getEnergyStored()));
        }
        return 0;
    }

    @Override
    public Icon getBlockTexture(int side) {
        return this.getMachineType().getTexture(side);
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("progress", this.progress);
        if (this.provider != null) {
            PowerFramework.currentFramework.savePowerProvider(this, data);
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            if (this.craftMatrix.func_70301_a(i) == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.craftMatrix.func_70301_a(i).func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        data.func_74782_a("Crafting", (NBTBase)nbttaglist);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        int i;
        super.func_70307_a(data);
        this.progress = data.func_74762_e("progress");
        if (PowerFramework.currentFramework != null) {
            PowerFramework.currentFramework.loadPowerProvider(this, data);
            this.initPowerProvider();
        }
        NBTTagList nbttaglist = data.func_74761_m("Crafting");
        for (i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            this.craftMatrix.func_70299_a(i, null);
        }
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.craftMatrix.func_70302_i_()) continue;
            this.craftMatrix.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        }
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        if (player.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) > 64.0) {
            return false;
        }
        GuiHandler.openGui(EnumGui.ROLLING_MACHINE, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case UP: {
                return 1;
            }
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        switch (side) {
            case UP: {
                return 4;
            }
        }
        return 1;
    }

    public void func_70296_d() {
        this.craftMatrix.func_70296_d();
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        InvTools.dropInventory((IInventory)this.craftMatrix, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 100;
    }

    public InventoryCrafting getCraftMatrix() {
        return this.craftMatrix;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        ++this.update;
        if (Game.isNotHost(this.field_70331_k)) {
            return;
        }
        if (PowerFramework.currentFramework != null) {
            this.provider.update(this);
        }
        for (int inputSlot = 0; inputSlot < this.invBuffer.func_70302_i_(); ++inputSlot) {
            ItemStack inputStack = this.invBuffer.func_70301_a(inputSlot);
            if (inputStack == null) continue;
            if (inputStack.field_77994_a <= 0) {
                this.invBuffer.func_70299_a(inputSlot, null);
                continue;
            }
            if (!inputStack.func_77985_e()) {
                this.invBuffer.func_70299_a(inputSlot, null);
                InvTools.dropItem(inputStack, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
                continue;
            }
            ItemStack outputStack = null;
            for (int recipeSlot = 0; recipeSlot < this.craftMatrix.func_70302_i_(); ++recipeSlot) {
                ItemStack craftingStack = this.craftMatrix.func_70301_a(recipeSlot);
                if (!InvTools.isItemEqual(inputStack, craftingStack) || outputStack != null && craftingStack.field_77994_a >= outputStack.field_77994_a) continue;
                outputStack = craftingStack;
            }
            if (outputStack != null && outputStack.field_77994_a < outputStack.func_77976_d()) {
                this.invBuffer.func_70298_a(inputSlot, 1);
                ++outputStack.field_77994_a;
                break;
            }
            if (outputStack != null) continue;
            this.invBuffer.func_70299_a(inputSlot, null);
            InvTools.dropItem(inputStack, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        List chests = InvTools.getAdjacentInventories(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        Iterator it = chests.iterator();
        while (it.hasNext()) {
            IInventory chest = (IInventory)it.next();
            if (chest.func_70302_i_() >= 27) continue;
            it.remove();
        }
        for (int slot = 0; slot < this.craftMatrix.func_70302_i_(); ++slot) {
            ItemStack stack = this.craftMatrix.func_70301_a(slot);
            if (stack == null || !stack.func_77985_e() || stack.field_77994_a != 1) continue;
            for (IInventory inv : chests) {
                ItemStack request = InvTools.removeOneItem(inv, stack);
                if (request == null) continue;
                ++stack.field_77994_a;
                break;
            }
            if (stack.field_77994_a > 1) break;
        }
        if (this.update % 16 == 0) {
            this.processActions();
        }
        if (this.paused) {
            return;
        }
        ItemStack recipe = RollingMachineCraftingManager.getInstance().findMatchingRecipe(this.craftMatrix, this.field_70331_k);
        if (recipe != null && this.canMakeMore()) {
            if (this.progress >= 100) {
                this.isWorking = false;
                if (InvTools.isRoomForStack(recipe, this.invResult)) {
                    for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
                        this.craftMatrix.func_70298_a(i, 1);
                    }
                    InvTools.moveItemStack(recipe, this.invResult);
                    this.useLast = false;
                    this.progress = 0;
                }
            } else {
                this.isWorking = true;
                if (PowerFramework.currentFramework != null) {
                    float energy = this.getPowerProvider().useEnergy(5.0f, 5.0f, true);
                    if (energy >= 5.0f) {
                        ++this.progress;
                    }
                } else {
                    ++this.progress;
                }
            }
        } else {
            this.progress = 0;
            this.isWorking = false;
        }
    }

    @Override
    public boolean hasWork() {
        return this.isWorking;
    }

    public void setPaused(boolean p) {
        this.paused = p;
    }

    private void processActions() {
        this.paused = false;
        for (IAction action : this.actions) {
            if (action != Actions.PAUSE) continue;
            this.paused = true;
        }
        this.actions.clear();
    }

    @Override
    public void actionActivated(IAction action) {
        this.actions.add(action);
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        ItemStack slot;
        if (stack == null || !stack.func_77985_e() || stack.field_77994_a <= 0) {
            return 0;
        }
        stack = stack.func_77946_l();
        Object inv = this.craftMatrix;
        if (!doAdd) {
            inv = new InventoryCopy((IInventory)inv);
        }
        ArrayList<ItemStack> slots = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            slot = inv.func_70301_a(i);
            if (!InvTools.isItemEqual(slot, stack)) continue;
            slots.add(slot);
        }
        if (!slots.isEmpty()) {
            int used = 0;
            while (stack.field_77994_a > 0) {
                ItemStackSizeSorter.sort(slots);
                slot = (ItemStack)slots.get(0);
                if (slot.field_77994_a >= slot.func_77976_d()) break;
                ++slot.field_77994_a;
                --stack.field_77994_a;
                ++used;
            }
            return used;
        }
        return 0;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int max) {
        IInventory inv = this.invResult;
        if (!doRemove) {
            inv = new InventoryCopy(this.invResult);
        }
        return InvTools.removeItems(inv, max);
    }

    public boolean canMakeMore() {
        if (RollingMachineCraftingManager.getInstance().findMatchingRecipe(this.craftMatrix, this.field_70331_k) == null) {
            return false;
        }
        if (this.useLast) {
            return true;
        }
        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            ItemStack slot = this.craftMatrix.func_70301_a(i);
            if (slot == null || slot.field_77994_a > 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 0;
    }

    private static class RollingContainer
    extends Container {
        private RollingContainer() {
        }

        public boolean func_75145_c(EntityPlayer entityplayer) {
            return true;
        }
    }

    private class EnergyIndicator
    implements IIndicatorController {
        List tips = new ArrayList();
        ToolTip tip = new ToolTip();

        private EnergyIndicator() {
            this.tips.add(this.tip);
        }

        @Override
        public List getToolTip() {
            this.tip.text = String.format("%d MJ", TileRollingMachine.this.guiEnergy);
            return this.tips;
        }

        @Override
        public int getScaledLevel(int size) {
            float e = Math.min(TileRollingMachine.this.guiEnergy, 500);
            return (int)(e * (float)size / 500.0f);
        }
    }
}

