/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class TileSmoker
extends TileMachineBase {
    private static final Random rand = MiscTools.getRand();
    private boolean powered;

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.SMOKER;
    }

    @Override
    public Icon getBlockTexture(int side) {
        return this.getMachineType().getTexture(side);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isHost(this.field_70331_k) || this.powered) {
            return;
        }
        if (!this.field_70331_k.func_72799_c(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n)) {
            return;
        }
        double px = (float)this.field_70329_l + rand.nextFloat();
        double py = (float)this.field_70330_m + rand.nextFloat() * 0.5f + 1.0f;
        double pz = (float)this.field_70327_n + rand.nextFloat();
        EffectManager.instance.chimneyEffect(this.field_70331_k, px, py, pz);
    }

    @Override
    public void onNeighborBlockChange(int id) {
        this.powered = PowerPlugin.isBlockBeingPowered(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.sendUpdateToClient();
    }

    @Override
    public boolean isBlockSolidOnSide(ForgeDirection side) {
        return side != ForgeDirection.UP;
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.powered = data.func_74767_n("powered");
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74757_a("powered", this.powered);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
    }
}

