/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.IPipeConnection;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.beta.EngineTools;
import mods.railcraft.common.gui.indicator.IIndicatorController;
import mods.railcraft.common.gui.util.ToolTip;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileEngine
extends TileMachineBase
implements IPowerReceptor,
IPipeConnection {
    private ForgeDirection direction = ForgeDirection.UP;
    private float pistonProgress = 0.0f;
    public float currentOutput = 0.0f;
    private int pistonStage;
    private boolean powered;
    private boolean isActive;
    private boolean needsInit = true;
    public float energy;
    public float extraEnergy;
    private EnergyStage energyStage = EnergyStage.BLUE;
    private IPowerProvider provider = PowerFramework.currentFramework.createPowerProvider();
    private IIndicatorController energyIndicator = new EnergyIndicator();

    public IIndicatorController getEnergyIndicator() {
        return this.energyIndicator;
    }

    public float getCurrentOutput() {
        return this.currentOutput;
    }

    public float getEnergy() {
        return this.energy;
    }

    public TileEngine() {
        this.initEnergyProvider();
    }

    private void initEnergyProvider() {
        this.provider.configure(0, 2, this.maxEnergyReceived(), 1, this.maxEnergy());
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isNotHost(this.field_70331_k)) {
            if (this.pistonStage != 0) {
                this.pistonProgress += this.getPistonSpeed();
                if (this.pistonProgress > 1.0f) {
                    this.pistonStage = 0;
                    this.pistonProgress = 0.0f;
                }
            } else if (this.isActive) {
                this.pistonStage = 1;
            }
            return;
        }
        if (this.needsInit) {
            this.needsInit = false;
            this.checkPower();
        }
        if (!this.powered && this.energy > 1.0f) {
            this.energy -= 1.0f;
        }
        this.provider.update(this);
        if (this.getEnergyStage() == EnergyStage.OVERHEAT) {
            this.overheat();
        } else if (this.pistonStage != 0) {
            this.pistonProgress += this.getPistonSpeed();
            if ((double)this.pistonProgress > 0.5 && this.pistonStage == 1) {
                IPowerReceptor receptor;
                IPowerProvider recProv;
                float extracted;
                this.pistonStage = 2;
                TileEntity tile = MiscTools.getBlockTileEntityOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.direction);
                if (EngineTools.isPoweredTile(tile) && (extracted = this.extractEnergy((recProv = (receptor = (IPowerReceptor)tile).getPowerProvider()).getMinEnergyReceived(), recProv.getMaxEnergyReceived(), true)) > 0.0f) {
                    recProv.receiveEnergy(extracted, this.direction.getOpposite());
                }
            } else if (this.pistonProgress >= 1.0f) {
                this.pistonProgress = 0.0f;
                this.pistonStage = 0;
            }
        } else if (this.powered) {
            TileEntity tile = MiscTools.getBlockTileEntityOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.direction);
            if (EngineTools.isPoweredTile(tile)) {
                IPowerReceptor receptor = (IPowerReceptor)tile;
                IPowerProvider recProv = receptor.getPowerProvider();
                if (this.extractEnergy(recProv.getMinEnergyReceived(), recProv.getMaxEnergyReceived(), false) > 0.0f) {
                    this.pistonStage = 1;
                    this.setActive(true);
                } else {
                    this.setActive(false);
                }
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        this.burn();
    }

    protected void overheat() {
        this.subtractEnergy(5.0f);
    }

    protected abstract void burn();

    private void setActive(boolean isActive) {
        if (this.isActive != isActive) {
            this.isActive = isActive;
            this.sendUpdateToClient();
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public float getPistonSpeed() {
        if (Game.isHost(this.field_70331_k)) {
            return Math.max(0.16f * this.getEnergyLevel(), 0.01f);
        }
        switch (this.getEnergyStage()) {
            case BLUE: {
                return 0.01f;
            }
            case GREEN: {
                return 0.02f;
            }
            case YELLOW: {
                return 0.04f;
            }
            case ORANGE: {
                return 0.08f;
            }
            case RED: {
                return 0.16f;
            }
        }
        return 0.0f;
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        IToolWrench wrench;
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current != null && current.func_77973_b() instanceof IToolWrench && (wrench = (IToolWrench)current.func_77973_b()).canWrench(player, this.field_70329_l, this.field_70330_m, this.field_70327_n) && Game.isHost(this.field_70331_k) && this.getEnergyStage() == EnergyStage.OVERHEAT) {
            this.resetEnergyStage();
            wrench.wrenchUsed(player, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return true;
        }
        return super.blockActivated(player, side);
    }

    @Override
    public boolean rotateBlock(ForgeDirection axis) {
        return this.switchOrientation();
    }

    @Override
    public void onBlockPlacedBy(EntityLiving entityliving) {
        super.onBlockPlacedBy(entityliving);
        this.switchOrientation();
        this.checkPower();
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        this.checkPower();
    }

    private void checkPower() {
        boolean p = PowerPlugin.isBlockBeingPowered(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (this.powered != p) {
            this.powered = p;
            this.sendUpdateToClient();
        }
    }

    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public boolean canConnectRedstone(int dir) {
        return true;
    }

    public boolean switchOrientation() {
        for (int i = this.direction.ordinal() + 1; i <= this.direction.ordinal() + 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)(i % 6));
            TileEntity tile = MiscTools.getBlockTileEntityOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, dir);
            if (!EngineTools.isPoweredTile(tile)) continue;
            this.direction = dir;
            this.sendUpdateToClient();
            if (Game.isNotHost(this.field_70331_k)) {
                this.markBlockForUpdate();
            }
            return true;
        }
        return false;
    }

    public ForgeDirection getOrientation() {
        return this.direction;
    }

    @Override
    public boolean isBlockSolidOnSide(ForgeDirection side) {
        return this.direction.getOpposite() == side;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.provider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.provider;
    }

    @Override
    public int powerRequest(ForgeDirection side) {
        return 0;
    }

    @Override
    public void doWork() {
        if (Game.isNotHost(this.field_70331_k)) {
            return;
        }
        float e = this.provider.useEnergy(1.0f, this.maxEnergyReceived(), true) * 0.95f;
        this.extraEnergy += e;
        this.addEnergy(e);
    }

    public float getEnergyLevel() {
        return this.energy / (float)this.maxEnergy();
    }

    protected EnergyStage computeEnergyStage() {
        float energyLevel = this.getEnergyLevel();
        if (energyLevel < 0.2f) {
            return EnergyStage.BLUE;
        }
        if (energyLevel < 0.4f) {
            return EnergyStage.GREEN;
        }
        if (energyLevel < 0.6f) {
            return EnergyStage.YELLOW;
        }
        if (energyLevel < 0.8f) {
            return EnergyStage.ORANGE;
        }
        if (energyLevel < 1.0f) {
            return EnergyStage.RED;
        }
        return EnergyStage.OVERHEAT;
    }

    public final EnergyStage getEnergyStage() {
        if (Game.isHost(this.field_70331_k)) {
            if (this.energyStage == EnergyStage.OVERHEAT) {
                return this.energyStage;
            }
            EnergyStage newStage = this.computeEnergyStage();
            if (this.energyStage != newStage) {
                this.energyStage = newStage;
                this.sendUpdateToClient();
            }
        }
        return this.energyStage;
    }

    public final void resetEnergyStage() {
        EnergyStage newStage = this.computeEnergyStage();
        if (this.energyStage != newStage) {
            this.energyStage = newStage;
            this.sendUpdateToClient();
        }
    }

    public void addEnergy(float addition) {
        this.energy += addition;
        if (this.energy > (float)this.maxEnergy()) {
            this.energy = this.maxEnergy();
        }
    }

    public void subtractEnergy(float subtraction) {
        this.energy -= subtraction;
        if (this.energy < 0.0f) {
            this.energy = 0.0f;
        }
    }

    public float extractEnergy(int min, int max, boolean doExtract) {
        float extracted;
        if (this.energy < (float)min) {
            return 0.0f;
        }
        float combinedMax = (float)this.maxEnergyExtracted() + this.extraEnergy * 0.5f;
        float actualMax = (float)max > combinedMax ? combinedMax : (float)max;
        if (this.energy >= actualMax) {
            extracted = actualMax;
            if (doExtract) {
                this.energy -= actualMax;
                this.extraEnergy -= Math.min(actualMax, this.extraEnergy);
            }
        } else {
            extracted = this.energy;
            if (doExtract) {
                this.energy = 0.0f;
                this.extraEnergy = 0.0f;
            }
        }
        return extracted;
    }

    public float getProgress() {
        return this.pistonProgress;
    }

    public abstract int maxEnergy();

    public abstract int maxEnergyExtracted();

    public abstract int maxEnergyReceived();

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74774_a("direction", (byte)this.direction.ordinal());
        data.func_74757_a("powered", this.powered);
        data.func_74776_a("energy", this.energy);
        data.func_74776_a("currentOutput", this.currentOutput);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.direction = ForgeDirection.getOrientation((int)data.func_74771_c("direction"));
        this.powered = data.func_74767_n("powered");
        this.energy = data.func_74760_g("energy");
        this.currentOutput = data.func_74760_g("currentOutput");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.direction.ordinal());
        data.writeByte(this.getEnergyStage().ordinal());
        data.writeBoolean(this.isActive);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.direction = ForgeDirection.getOrientation((int)data.readByte());
        this.energyStage = EnergyStage.values()[data.readByte()];
        this.isActive = data.readBoolean();
    }

    @Override
    public boolean isPipeConnected(ForgeDirection side) {
        return side != this.direction;
    }

    public static enum EnergyStage {
        BLUE,
        GREEN,
        YELLOW,
        ORANGE,
        RED,
        OVERHEAT;

    }

    private class EnergyIndicator
    implements IIndicatorController {
        List tips = new ArrayList();
        ToolTip tip = new ToolTip();

        private EnergyIndicator() {
            this.tips.add(this.tip);
        }

        @Override
        public List getToolTip() {
            this.tip.text = String.format("%.0f MJ", Float.valueOf(TileEngine.this.energy));
            return this.tips;
        }

        @Override
        public int getScaledLevel(int size) {
            float e = Math.min(TileEngine.this.energy, (float)TileEngine.this.maxEnergy());
            return (int)(e * (float)size / (float)TileEngine.this.maxEnergy());
        }
    }
}

