/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderLiquidBase;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.liquids.LiquidManager;
import mods.railcraft.common.liquids.TankToolkit;
import mods.railcraft.common.liquids.tanks.StandardTank;
import mods.railcraft.common.plugins.buildcraft.actions.Actions;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.InventoryCopy;
import mods.railcraft.common.util.inventory.InventoryMapper;
import mods.railcraft.common.util.inventory.PhantomInventory;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class TileLiquidUnloader
extends TileLoaderLiquidBase
implements ISidedInventory,
ISpecialInventory,
ITankContainer,
IGuiReturnHandler {
    private static final int CAPACITY = 8000;
    private static final int TRANSFER_RATE = 80;
    private boolean waitTillEmpty = true;
    private final PhantomInventory invFilter = new PhantomInventory(1);

    public TileLiquidUnloader() {
        StandardTank tank = new StandardTank(8000, this);
        tank.setTankPressure(1);
        this.tankManager.addTank(tank);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.LIQUID_UNLOADER;
    }

    public PhantomInventory getLiquidFilter() {
        return this.invFilter;
    }

    @Override
    public Icon getBlockTexture(int side) {
        if (side > 1) {
            return this.getMachineType().getTexture(6);
        }
        return this.getMachineType().getTexture(side);
    }

    public LiquidStack getFilterLiquid() {
        if (this.invFilter.func_70301_a(0) != null) {
            return LiquidManager.instance().getLiquidInContainer(this.invFilter.func_70301_a(0));
        }
        return null;
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        return super.blockActivated(player, side);
    }

    @Override
    public void func_70316_g() {
        ItemStack bottomSlot;
        super.func_70316_g();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        ItemStack topSlot = this.func_70301_a(0);
        if (topSlot != null && !LiquidManager.instance().isContainer(topSlot)) {
            this.func_70299_a(0, null);
            this.dropItem(topSlot);
        }
        if ((bottomSlot = this.func_70301_a(1)) != null && !LiquidManager.instance().isContainer(bottomSlot)) {
            this.func_70299_a(1, null);
            this.dropItem(bottomSlot);
        }
        if (this.clock % 8 == 0) {
            LiquidManager.instance().processContainers(this.tankManager.getTank(0), this, 0, 1, false, true);
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            LiquidStack available;
            IPipe pipe;
            if (ForgeDirection.UP == side) continue;
            TileEntity tile = MiscTools.getBlockTileEntityOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, side);
            ITankContainer nearbyTank = null;
            side = side.getOpposite();
            if (tile instanceof ITankContainer) {
                nearbyTank = (ITankContainer)tile;
            } else if (tile instanceof IPipeTile && (pipe = ((IPipeTile)tile).getPipe()) instanceof ITankContainer) {
                nearbyTank = (ITankContainer)pipe;
            }
            if (nearbyTank == null || (available = this.tankManager.getTank(0).drain(80, false)) == null) continue;
            int used = nearbyTank.fill(side, available, true);
            this.tankManager.getTank(0).drain(used, true);
        }
        EntityMinecart cart = CartTools.getMinecartOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0.1f, ForgeDirection.UP);
        if (cart != this.currentCart) {
            this.setPowered(false);
            this.currentCart = cart;
            this.cartWasSent();
        }
        if (cart == null) {
            return;
        }
        if (!(cart instanceof ITankContainer)) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
                this.setPowered(true);
            }
            return;
        }
        if (this.isSendCartGateAction()) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
                this.setPowered(true);
            }
            return;
        }
        ItemStack minecartSlot1 = this.getCartFilters().func_70301_a(0);
        ItemStack minecartSlot2 = this.getCartFilters().func_70301_a(1);
        if (!(minecartSlot1 == null && minecartSlot2 == null || CartTools.doesCartMatchFilter(minecartSlot1, cart) || CartTools.doesCartMatchFilter(minecartSlot2, cart))) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
                this.setPowered(true);
            }
            return;
        }
        if (this.actions.contains(Actions.PAUSE)) {
            return;
        }
        TankToolkit tankCart = new TankToolkit((ITankContainer)cart);
        this.flow = 0;
        LiquidStack drained = tankCart.drain(ForgeDirection.DOWN, RailcraftConfig.getTankCartFillRate(), false);
        if (this.getFilterLiquid() == null || this.getFilterLiquid().isLiquidEqual(drained)) {
            this.flow = this.tankManager.getTank(0).fill(drained, true);
            tankCart.drain(ForgeDirection.DOWN, this.flow, true);
        }
        if (this.flow > 0) {
            this.setPowered(false);
        }
        if (this.flow <= 0 && !this.isPowered() && CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
            if (!this.waitTillEmpty()) {
                this.setPowered(true);
            } else if (this.getFilterLiquid() != null && tankCart.isTankEmpty(this.getFilterLiquid())) {
                this.setPowered(true);
            } else if (tankCart.areTanksEmpty()) {
                this.setPowered(true);
            }
        }
    }

    @Override
    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74757_a("waitTillEmpty", this.waitTillEmpty);
        this.getLiquidFilter().writeToNBT("invFilter", data);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.waitTillEmpty = data.func_74767_n("waitTillEmpty");
        if (data.func_74764_b("filter")) {
            NBTTagCompound filter = data.func_74775_l("filter");
            this.getLiquidFilter().readFromNBT("Items", filter);
        } else {
            this.getLiquidFilter().readFromNBT("invFilter", data);
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.waitTillEmpty);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.waitTillEmpty = data.readBoolean();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeBoolean(this.waitTillEmpty);
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        this.waitTillEmpty = data.readBoolean();
    }

    public boolean waitTillEmpty() {
        return this.waitTillEmpty;
    }

    public void setWaitTillEmpty(boolean wait) {
        this.waitTillEmpty = wait;
    }

    public ForgeDirection getOrientation() {
        return ForgeDirection.UP;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.UNLOADER_LIQUID, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.DOWN) {
            return 1;
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (LiquidManager.instance().isEmptyContainer(stack)) {
            ItemStack ret;
            Object slot = new InventoryMapper(this, 0, 1);
            if (!doAdd) {
                slot = new InventoryCopy((IInventory)slot);
            }
            if ((ret = InvTools.moveItemStack(stack.func_77946_l(), slot)) != null && stack.field_77994_a != ret.field_77994_a) {
                return stack.field_77994_a - ret.field_77994_a;
            }
            if (ret == null) {
                return stack.field_77994_a;
            }
        }
        return 0;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        IInventory inv = this;
        if (!doRemove) {
            inv = new InventoryCopy(inv);
        }
        return new ItemStack[]{inv.func_70298_a(1, maxItemCount)};
    }
}

