/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import mods.railcraft.api.core.IPostConnection;
import mods.railcraft.client.util.textures.SheetTextureStitched;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.ISignalTile;
import mods.railcraft.common.blocks.signals.MaterialStructure;
import mods.railcraft.common.blocks.signals.TileBoxBlockRelay;
import mods.railcraft.common.blocks.signals.TileBoxCapacitor;
import mods.railcraft.common.blocks.signals.TileBoxController;
import mods.railcraft.common.blocks.signals.TileBoxReceiver;
import mods.railcraft.common.blocks.signals.TileSignalBlockSignal;
import mods.railcraft.common.blocks.signals.TileSignalDistantSignal;
import mods.railcraft.common.blocks.signals.TileSignalDualHeadBlockSignal;
import mods.railcraft.common.blocks.signals.TileSignalDualHeadDistantSignal;
import mods.railcraft.common.blocks.signals.TileSignalFoundation;
import mods.railcraft.common.blocks.signals.TileSwitchLever;
import mods.railcraft.common.blocks.signals.TileSwitchMotor;
import mods.railcraft.common.items.IActivationBlockingItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockSignal
extends BlockContainer
implements IPostConnection {
    public static Icon[] texturesBox;
    public static Icon[] texturesLampTop;
    public static Icon[] texturesLampBottom;
    public static Icon[] texturesLampBox;
    public static Icon[] texturesSignalSingle;
    public static Icon[] texturesSignalDual;
    public static Icon[] texturesSwitch;
    public static Icon[] texturesSwitchTarget;
    public static Icon texturesSwitchLever;
    private final int renderType;

    public BlockSignal(int id, int renderType) {
        super(id, (Material)new MaterialStructure());
        this.renderType = renderType;
        this.func_71864_b("railcraft.signal");
        this.func_71884_a(Block.field_71977_i);
        this.func_71894_b(15.0f);
        this.func_71849_a(CreativeTabs.field_78029_e);
        GameRegistry.registerTileEntity(TileBoxController.class, (String)"RCTileStructureControllerBox");
        GameRegistry.registerTileEntity(TileBoxReceiver.class, (String)"RCTileStructureReceiverBox");
        GameRegistry.registerTileEntity(TileBoxCapacitor.class, (String)"RCTileStructureCapacitorBox");
        GameRegistry.registerTileEntity(TileBoxBlockRelay.class, (String)"RCTileStructureSignalBox");
        GameRegistry.registerTileEntity(TileSwitchMotor.class, (String)"RCTileStructureSwitchMotor");
        GameRegistry.registerTileEntity(TileSwitchLever.class, (String)"RCTileStructureSwitchLever");
        GameRegistry.registerTileEntity(TileSignalDistantSignal.class, (String)"RCTileStructureDistantSignal");
        GameRegistry.registerTileEntity(TileSignalDualHeadBlockSignal.class, (String)"RCTileStructureDualHeadBlockSignal");
        GameRegistry.registerTileEntity(TileSignalBlockSignal.class, (String)"RCTileStructureBlockSignal");
        GameRegistry.registerTileEntity(TileSignalDualHeadDistantSignal.class, (String)"RCTileStructureDualHeadDistantSignal");
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (EnumSignal type : EnumSignal.getCreativeList()) {
            if (!type.isEnabled()) continue;
            list.add(type.getItem());
        }
    }

    public int func_71899_b(int meta) {
        return meta;
    }

    public void func_94332_a(IconRegister iconRegister) {
        texturesBox = SheetTextureStitched.unstitchIcons(iconRegister, "railcraft:signal.box", 6);
        texturesLampBox = SheetTextureStitched.unstitchIcons(iconRegister, "railcraft:signal.lamp.box", 4);
        texturesLampTop = SheetTextureStitched.unstitchIcons(iconRegister, "railcraft:signal.lamp.top", 4);
        texturesLampBottom = SheetTextureStitched.unstitchIcons(iconRegister, "railcraft:signal.lamp.bottom", 4);
        texturesSignalSingle = SheetTextureStitched.unstitchIcons(iconRegister, "railcraft:signal.single", 5);
        texturesSignalDual = SheetTextureStitched.unstitchIcons(iconRegister, "railcraft:signal.dual", 5);
        texturesSwitch = SheetTextureStitched.unstitchIcons(iconRegister, "railcraft:signal.switch", 2);
        texturesSwitchTarget = SheetTextureStitched.unstitchIcons(iconRegister, "railcraft:signal.switch.target", 2);
        texturesSwitchLever = iconRegister.func_94245_a("railcraft:signal.switch.throw");
        EnumSignal.BOX_BLOCK_RELAY.setIcon(iconRegister.func_94245_a("railcraft:signal.box.block.relay"));
        EnumSignal.BOX_CAPACITOR.setIcon(iconRegister.func_94245_a("railcraft:signal.box.capacitor"));
        EnumSignal.BOX_CONTROLLER.setIcon(iconRegister.func_94245_a("railcraft:signal.box.controller"));
        EnumSignal.BOX_RECEIVER.setIcon(iconRegister.func_94245_a("railcraft:signal.box.receiver"));
        EnumSignal.SWITCH_MOTOR.setIcon(iconRegister.func_94245_a("railcraft:signal.switch.motor"));
        EnumSignal.SWITCH_LEVER.setIcon(iconRegister.func_94245_a("railcraft:signal.switch.lever"));
    }

    public Icon func_71858_a(int side, int meta) {
        EnumSignal type = EnumSignal.fromId(meta);
        switch (type) {
            case DUAL_HEAD_BLOCK_SIGNAL: 
            case DUAL_HEAD_DISTANT_SIGNAL: {
                return texturesSignalDual[0];
            }
            case DISTANT_SIGNAL: 
            case BLOCK_SIGNAL: {
                return texturesSignalSingle[0];
            }
        }
        return type.getIcon();
    }

    public boolean func_71903_a(World world, int i, int j, int k, EntityPlayer player, int side, float u1, float u2, float u3) {
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() instanceof IActivationBlockingItem) {
            return false;
        }
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).blockActivated(side, player);
        }
        return false;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).rotateBlock(axis);
        }
        return false;
    }

    public ForgeDirection[] getValidRotations(World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).getValidRotations();
        }
        return super.getValidRotations(world, x, y, z);
    }

    public void func_85105_g(World world, int i, int j, int k, int meta) {
        super.func_85105_g(world, i, j, k, meta);
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            ((TileSignalFoundation)tile).onBlockPlaced();
        }
    }

    public void func_71860_a(World world, int i, int j, int k, EntityLiving entityliving, ItemStack stack) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            ((TileSignalFoundation)tile).onBlockPlacedBy(entityliving);
        }
    }

    public void func_71863_a(World world, int x, int y, int z, int side) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileSignalFoundation) {
            TileSignalFoundation structure = (TileSignalFoundation)tile;
            if (structure.getSignalType().needsSupport() && !world.isBlockSolidOnSide(x, y - 1, z, ForgeDirection.UP)) {
                world.func_94578_a(x, y, z, true);
            } else {
                structure.onNeighborBlockChange(side);
            }
        }
    }

    public void func_71852_a(World world, int i, int j, int k, int id, int meta) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            ((TileSignalFoundation)tile).onBlockRemoval(world, i, j, k);
        }
        super.func_71852_a(world, i, j, k, id, meta);
    }

    public void func_71902_a(IBlockAccess world, int i, int j, int k) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            ((TileSignalFoundation)tile).setBlockBoundsBasedOnState(world, i, j, k);
        } else {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public AxisAlignedBB func_71872_e(World world, int i, int j, int k) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).getCollisionBoundingBoxFromPool(world, i, j, k);
        }
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return super.func_71872_e(world, i, j, k);
    }

    public AxisAlignedBB func_71911_a_(World world, int i, int j, int k) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).getSelectedBoundingBoxFromPool(world, i, j, k);
        }
        return AxisAlignedBB.func_72332_a().func_72299_a((double)i + this.field_72026_ch, (double)j + this.field_72023_ci, (double)k + this.field_72024_cj, (double)i + this.field_72021_ck, (double)j + this.field_72022_cl, (double)k + this.field_72019_cm);
    }

    public int getLightValue(IBlockAccess world, int i, int j, int k) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof ISignalTile) {
            return ((ISignalTile)tile).getLightValue();
        }
        return 0;
    }

    public float func_71934_m(World world, int par2, int par3, int par4) {
        int md = world.func_72805_g(par4, par2, par3);
        return EnumSignal.fromId(md).getHardness();
    }

    public boolean isBlockSolidOnSide(World world, int i, int j, int k, ForgeDirection side) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).isBlockSolidOnSide(world, i, j, k, side);
        }
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return this.renderType;
    }

    public TileEntity func_72274_a(World var1) {
        return null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return EnumSignal.fromId(metadata).getBlockEntity();
    }

    public boolean func_71853_i() {
        return true;
    }

    public boolean canConnectRedstone(IBlockAccess world, int i, int j, int k, int dir) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).canConnectRedstone(dir);
        }
        return false;
    }

    public boolean isBlockNormalCube(World world, int i, int j, int k) {
        return false;
    }

    public int func_71865_a(IBlockAccess world, int i, int j, int k, int side) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).getPowerOutput(world, i, j, k, side);
        }
        return 0;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public boolean canBeReplacedByLeaves(World world, int x, int y, int z) {
        return false;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, World world, int x, int y, int z) {
        return false;
    }

    @Override
    public boolean connectsAt(World world, int i, int j, int k, ForgeDirection side) {
        TileEntity t = world.func_72796_p(i, j, k);
        return t instanceof ISignalTile;
    }
}

