/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.signals.IControllerTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SimpleSignalController;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.ItemSignalTuner;
import mods.railcraft.common.blocks.signals.TileBoxBase;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class TileBoxController
extends TileBoxBase
implements IControllerTile,
IGuiReturnHandler {
    private boolean powered;
    protected int update = MiscTools.getRand().nextInt();
    public SignalAspect defaultAspect = SignalAspect.GREEN;
    public SignalAspect poweredAspect = SignalAspect.RED;
    private boolean prevBlinkState;
    private final SimpleSignalController controller = new SimpleSignalController(this.func_70303_b(), this);

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.BOX_CONTROLLER;
    }

    @Override
    public boolean blockActivated(int side, EntityPlayer player) {
        if (player.func_70093_af()) {
            return false;
        }
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() instanceof ItemSignalTuner) {
            return super.blockActivated(side, player);
        }
        GuiHandler.openGui(EnumGui.BOX_CONTROLLER, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    public void func_70316_g() {
        ++this.update;
        if (Game.isNotHost(this.field_70331_k)) {
            this.controller.tickClient();
            if (this.controller.getAspect().isBlinkAspect() && this.prevBlinkState != SignalAspect.isBlinkOn()) {
                this.prevBlinkState = SignalAspect.isBlinkOn();
                this.markBlockForUpdate();
            }
            return;
        }
        this.controller.tickServer();
        SignalAspect prevAspect = this.controller.getAspect();
        if (this.controller.isBeingPaired()) {
            this.controller.setAspect(SignalAspect.BLINK_YELLOW);
        } else if (this.controller.isPaired()) {
            this.controller.setAspect(this.determineAspect());
        } else {
            this.controller.setAspect(SignalAspect.BLINK_RED);
        }
        if (prevAspect != this.controller.getAspect()) {
            this.sendUpdateToClient();
        }
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        boolean p;
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        boolean bl = p = PowerPlugin.isBlockBeingPowered(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n) || PowerPlugin.isBlockBeingPowered(this.field_70331_k, this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) || Block.field_72075_av.field_71990_ca == blockId && PowerPlugin.isRedstonePowered(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (p != this.powered) {
            this.powered = p;
            this.sendUpdateToClient();
        }
    }

    private SignalAspect determineAspect() {
        SignalAspect newAspect = this.powered ? this.poweredAspect : this.defaultAspect;
        for (int side = 2; side < 6; ++side) {
            TileBoxBase tile;
            TileEntity t = this.tileCache.getTileOnSide(ForgeDirection.getOrientation((int)side));
            if (!(t instanceof TileBoxBase) || !(tile = (TileBoxBase)t).canTransferAspect()) continue;
            newAspect = SignalAspect.mostRestrictive(newAspect, tile.getBoxSignalAspect());
        }
        return newAspect;
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74757_a("Powered", this.powered);
        data.func_74768_a("defaultAspect", this.defaultAspect.ordinal());
        data.func_74768_a("PoweredAspect", this.poweredAspect.ordinal());
        this.controller.writeToNBT(data);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.powered = data.func_74767_n("Powered");
        this.defaultAspect = SignalAspect.values()[data.func_74762_e("defaultAspect")];
        this.poweredAspect = SignalAspect.values()[data.func_74762_e("PoweredAspect")];
        this.controller.readFromNBT(data);
        if (data.func_74764_b("ReceiverX")) {
            int x = data.func_74762_e("ReceiverX");
            int y = data.func_74762_e("ReceiverY");
            int z = data.func_74762_e("ReceiverZ");
            this.controller.registerLegacyReceiver(x, y, z);
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.defaultAspect.ordinal());
        data.writeByte(this.poweredAspect.ordinal());
        this.controller.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.defaultAspect = SignalAspect.values()[data.readByte()];
        this.poweredAspect = SignalAspect.values()[data.readByte()];
        this.controller.readPacketData(data);
        this.markBlockForUpdate();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.defaultAspect.ordinal());
        data.writeByte(this.poweredAspect.ordinal());
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        this.defaultAspect = SignalAspect.values()[data.readByte()];
        this.poweredAspect = SignalAspect.values()[data.readByte()];
    }

    @Override
    public boolean connectToBoxAt(int i, int j, int k, int side) {
        TileEntity tile = this.field_70331_k.func_72796_p(i, j, k);
        if (tile instanceof TileBoxBase) {
            return ((TileBoxBase)tile).canTransferAspect();
        }
        return false;
    }

    @Override
    public SignalAspect getBoxSignalAspect() {
        return this.controller.getAspect();
    }

    @Override
    public boolean canReceiveAspect() {
        return true;
    }

    @Override
    public SimpleSignalController getController() {
        return this.controller;
    }
}

