/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.signals.IReceiverTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SignalController;
import mods.railcraft.api.signals.SimpleSignalReceiver;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.IAspectActionManager;
import mods.railcraft.common.blocks.signals.ItemSignalTuner;
import mods.railcraft.common.blocks.signals.TileBoxBase;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.buildcraft.triggers.IAspectProvider;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class TileBoxReceiver
extends TileBoxBase
implements IAspectActionManager,
IGuiReturnHandler,
IReceiverTile,
IAspectProvider {
    protected int update = MiscTools.getRand().nextInt();
    private boolean prevBlinkState;
    private boolean[] powerOnAspects = new boolean[SignalAspect.values().length];
    private final SimpleSignalReceiver receiver = new SimpleSignalReceiver(this.func_70303_b(), this);

    public TileBoxReceiver() {
        this.powerOnAspects[SignalAspect.GREEN.ordinal()] = true;
    }

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.BOX_RECEIVER;
    }

    @Override
    public boolean blockActivated(int side, EntityPlayer player) {
        if (player.func_70093_af()) {
            return false;
        }
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() instanceof ItemSignalTuner) {
            return super.blockActivated(side, player);
        }
        GuiHandler.openGui(EnumGui.BOX_RECEIVER, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    public void func_70316_g() {
        ++this.update;
        if (Game.isNotHost(this.getWorld())) {
            this.receiver.tickClient();
            if (this.receiver.getAspect().isBlinkAspect() && this.prevBlinkState != SignalAspect.isBlinkOn()) {
                this.prevBlinkState = SignalAspect.isBlinkOn();
                this.markBlockForUpdate();
            }
            return;
        }
        this.receiver.tickServer();
        SignalAspect prevAspect = this.receiver.getAspect();
        if (this.receiver.isBeingPaired()) {
            this.receiver.setAspect(SignalAspect.BLINK_YELLOW);
        } else if (!this.receiver.isPaired()) {
            this.receiver.setAspect(SignalAspect.BLINK_RED);
        }
        if (prevAspect != this.receiver.getAspect()) {
            this.updateNeighbors();
            this.sendUpdateToClient();
        }
    }

    @Override
    public void onControllerAspectChange(SignalController con, SignalAspect aspect) {
        this.updateNeighbors();
        this.sendUpdateToClient();
    }

    private void updateNeighbors() {
        int blockID = this.getBlockId();
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, blockID);
        for (int side = 2; side < 6; ++side) {
            ForgeDirection forgeSide = ForgeDirection.getOrientation((int)side);
            TileEntity tile = this.tileCache.getTileOnSide(forgeSide);
            if (!(tile instanceof TileBoxBase)) continue;
            TileBoxBase box = (TileBoxBase)tile;
            box.onNeighborStateChange(this);
        }
    }

    @Override
    public int getPowerOutput(IBlockAccess world, int i, int j, int k, int side) {
        TileEntity tile = MiscTools.getBlockTileEntityOnSide(this.field_70331_k, i, j, k, MiscTools.getOppositeSide(side));
        if (tile instanceof TileBoxBase) {
            return 0;
        }
        return this.powerOnAspects[this.receiver.getAspect().ordinal()] ? 15 : 0;
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        byte[] array = new byte[this.powerOnAspects.length];
        for (int i = 0; i < this.powerOnAspects.length; ++i) {
            array[i] = (byte)(this.powerOnAspects[i] ? 1 : 0);
        }
        data.func_74773_a("PowerOnAspect", array);
        this.receiver.writeToNBT(data);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        if (data.func_74764_b("PowerOnAspect")) {
            byte[] array = data.func_74770_j("PowerOnAspect");
            for (int i = 0; i < this.powerOnAspects.length; ++i) {
                this.powerOnAspects[i] = array[i] == 1;
            }
        }
        this.receiver.readFromNBT(data);
        if (data.func_74764_b("ControllerX")) {
            int cx = data.func_74762_e("ControllerX");
            int cy = data.func_74762_e("ControllerY");
            int cz = data.func_74762_e("ControllerZ");
            this.receiver.registerLegacyController(cx, cy, cz);
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.receiver.writePacketData(data);
        this.writeGuiData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.receiver.readPacketData(data);
        this.readGuiData(data);
        this.markBlockForUpdate();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        int bits = 0;
        for (int i = 0; i < this.powerOnAspects.length; ++i) {
            bits = (byte)(bits | (this.powerOnAspects[i] ? 1 : 0) << i);
        }
        data.writeByte(bits);
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        byte bits = data.readByte();
        for (int bit = 0; bit < this.powerOnAspects.length; ++bit) {
            this.powerOnAspects[bit] = (bits >> bit & 1) == 1;
        }
        this.updateNeighbors();
    }

    @Override
    public boolean connectToBoxAt(int i, int j, int k, int side) {
        TileEntity tile = this.field_70331_k.func_72796_p(i, j, k);
        if (tile instanceof TileBoxBase) {
            return ((TileBoxBase)tile).canReceiveAspect();
        }
        return false;
    }

    @Override
    public boolean isEmitingRedstone() {
        return this.powerOnAspects[this.receiver.getAspect().ordinal()];
    }

    @Override
    public boolean doesActionOnAspect(SignalAspect aspect) {
        return this.powerOnAspects[aspect.ordinal()];
    }

    @Override
    public void doActionOnAspect(SignalAspect aspect, boolean trigger) {
        this.powerOnAspects[aspect.ordinal()] = trigger;
        this.updateNeighbors();
    }

    @Override
    public SignalAspect getBoxSignalAspect() {
        return this.receiver.getAspect();
    }

    @Override
    public boolean canTransferAspect() {
        return true;
    }

    @Override
    public SimpleSignalReceiver getReceiver() {
        return this.receiver;
    }

    @Override
    public SignalAspect getTriggerAspect() {
        return this.getBoxSignalAspect();
    }
}

