/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.tracks.ITrackEmitter;
import mods.railcraft.api.tracks.ITrackReversable;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

public class TrackDetectorDirection
extends TrackBaseRailcraft
implements ITrackReversable,
ITrackEmitter {
    private boolean reversed = false;
    private byte delay = 0;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.DETECTOR_DIRECTION;
    }

    @Override
    public Icon getIcon() {
        if (this.getPowerOutput() != 0) {
            if (this.isReversed()) {
                return this.getIcon(3);
            }
            return this.getIcon(1);
        }
        if (this.isReversed()) {
            return this.getIcon(2);
        }
        return this.getIcon(0);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void updateEntity() {
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        if (this.delay > 0) {
            this.delay = (byte)(this.delay - 1);
            if (this.delay == 0) {
                this.notifyNeighbors();
            }
        }
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        int meta = this.tileEntity.func_70322_n();
        if (meta == 1 || meta == 2 || meta == 3) {
            if (this.isReversed() && cart.field_70159_w < 0.0 || !this.isReversed() && cart.field_70159_w > 0.0) {
                this.setTrackPowering();
            }
        } else if ((meta == 0 || meta == 4 || meta == 5) && (this.isReversed() && cart.field_70179_y > 0.0 || !this.isReversed() && cart.field_70179_y < 0.0)) {
            this.setTrackPowering();
        }
    }

    private void notifyNeighbors() {
        this.getWorld().func_72898_h(this.getX(), this.getY(), this.getZ(), RailcraftBlocks.getBlockTrack().field_71990_ca);
        this.getWorld().func_72898_h(this.getX(), this.getY() - 1, this.getZ(), RailcraftBlocks.getBlockTrack().field_71990_ca);
        this.sendUpdateToClient();
    }

    private void setTrackPowering() {
        boolean notify = this.delay == 0;
        this.delay = (byte)3;
        if (notify) {
            this.notifyNeighbors();
        }
    }

    @Override
    public int getPowerOutput() {
        return this.delay > 0 ? 15 : 0;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("direction", this.reversed);
        nbttagcompound.func_74774_a("delay", this.delay);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.reversed = nbttagcompound.func_74767_n("direction");
        this.delay = nbttagcompound.func_74771_c("delay");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.delay);
        data.writeBoolean(this.reversed);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.delay = data.readByte();
        this.reversed = data.readBoolean();
        this.markBlockNeedsUpdate();
    }
}

