/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.ILinkableCart;
import mods.railcraft.api.carts.IMinecart;
import mods.railcraft.common.carts.CartContainerBase;
import mods.railcraft.common.carts.CartUtils;
import mods.railcraft.common.carts.DamageSourceTrain;
import mods.railcraft.common.carts.IDirectionalCart;
import mods.railcraft.common.carts.ItemLocomotive;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.carts.Train;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.ItemOveralls;
import mods.railcraft.common.items.ItemWhistleTuner;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.EnumColor;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class EntityLocomotive
extends CartContainerBase
implements IDirectionalCart,
IGuiReturnHandler,
ILinkableCart,
IMinecart {
    private static final byte HAS_FUEL_DATA_ID = 16;
    private static final byte PRIMARY_COLOR_DATA_ID = 25;
    private static final byte SECONDARY_COLOR_DATA_ID = 26;
    private static final byte LOCOMOTIVE_MODE_DATA_ID = 27;
    private static final byte LOCOMOTIVE_SPEED_DATA_ID = 28;
    private static final double DRAG_FACTOR = 0.9;
    private static final float NORMAL_FORCE = 0.15f;
    private static final float HS_FORCE = 0.52500004f;
    private static final byte FUEL_USE_INTERVAL = 8;
    private static final byte KNOCKBACK = 1;
    private static final int WHISTLE_INTERVAL = 256;
    private static final int WHISTLE_DELAY = 160;
    private static final int WHISTLE_CHANCE = 4;
    private boolean secure = true;
    private int fuel;
    private int update = MiscTools.getRand().nextInt();
    private int whistleDelay;
    private int tempIdle;
    private float whistlePitch = this.getNewWhistlePitch();
    protected float renderYaw;
    public LocoMode clientMode = LocoMode.SHUTDOWN;
    public LocoSpeed clientSpeed = LocoSpeed.MAX;

    public EntityLocomotive(World world) {
        super(world);
        this.setPrimaryColor(EnumColor.LIGHT_GRAY.ordinal());
        this.setSecondaryColor(EnumColor.GRAY.ordinal());
    }

    public EntityLocomotive(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y + (double)this.field_70129_M, z);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)0);
        this.field_70180_af.func_75682_a(27, (Object)0);
        this.field_70180_af.func_75682_a(28, (Object)0);
    }

    public void initEntityFromItem(ItemStack item) {
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt == null) {
            return;
        }
        if (nbt.func_74764_b("primaryColor")) {
            this.setPrimaryColor(nbt.func_74771_c("primaryColor"));
        }
        if (nbt.func_74764_b("secondaryColor")) {
            this.setSecondaryColor(nbt.func_74771_c("secondaryColor"));
        }
        if (nbt.func_74764_b("whistlePitch")) {
            this.whistlePitch = nbt.func_74760_g("whistlePitch");
        }
        if (nbt.func_74764_b("owner")) {
            CartTools.setCartOwner((EntityMinecart)this, nbt.func_74779_i("owner"));
        }
    }

    private float getNewWhistlePitch() {
        return 1.0f + (float)this.field_70146_Z.nextGaussian() * 0.2f;
    }

    @Override
    public List getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getCartItem());
        return items;
    }

    @Override
    public ItemStack getCartItem() {
        ItemStack item = this.getCartItemBase();
        if (this.secure && CartTools.doesCartHaveOwner((EntityMinecart)this)) {
            ItemLocomotive.setOwnerData(item, CartTools.getCartOwner((EntityMinecart)this));
        }
        ItemLocomotive.setItemColorData(item, this.getPrimaryColor(), this.getSecondaryColor());
        ItemLocomotive.setItemWhistleData(item, this.whistlePitch);
        return item;
    }

    protected abstract ItemStack getCartItemBase();

    public LocoMode getMode() {
        return LocoMode.VALUES[this.field_70180_af.func_75683_a(27)];
    }

    public void setMode(LocoMode mode) {
        if (this.getMode() != mode) {
            this.field_70180_af.func_75692_b(27, (Object)((byte)mode.ordinal()));
        }
    }

    public LocoSpeed getSpeed() {
        return LocoSpeed.VALUES[this.field_70180_af.func_75683_a(28)];
    }

    public void setSpeed(LocoSpeed speed) {
        if (this.getSpeed() != speed) {
            this.field_70180_af.func_75692_b(28, (Object)((byte)speed.ordinal()));
        }
    }

    public boolean hasFuel() {
        return this.field_70180_af.func_75683_a(16) != 0;
    }

    public void setHasFuel(boolean powered) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)(powered ? 1 : 0)));
    }

    public boolean isRunning() {
        return this.fuel > 0 && this.getMode() == LocoMode.RUNNING && !this.isIdle() && !this.isShutdown();
    }

    public boolean isIdle() {
        if (this.isShutdown()) {
            return false;
        }
        return this.tempIdle > 0 || this.getMode() == LocoMode.IDLE || Train.isTrainLockedDown((EntityMinecart)this);
    }

    public boolean isShutdown() {
        return this.getMode() == LocoMode.SHUTDOWN;
    }

    public void forceIdle(int ticks) {
        this.tempIdle = Math.max(this.tempIdle, ticks);
    }

    @Override
    public void reverse() {
        this.field_70177_z += 180.0f;
        this.field_70159_w = -this.field_70159_w;
        this.field_70179_y = -this.field_70179_y;
    }

    @Override
    public void setRenderYaw(float yaw) {
        this.renderYaw = yaw;
    }

    public abstract String getWhistle();

    public final void whistle() {
        if (RailcraftConfig.playSounds() && this.whistleDelay <= 0) {
            this.field_70170_p.func_72956_a((Entity)this, this.getWhistle(), 1.0f, this.whistlePitch);
            this.whistleDelay = 160;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.update;
        if (Game.isNotHost(this.field_70170_p)) {
            return;
        }
        this.updateFuel();
        if (this.whistleDelay > 0) {
            --this.whistleDelay;
        }
        if (this.tempIdle > 0) {
            --this.tempIdle;
        }
        if (this.update % 256 == 0 && this.isRunning() && this.field_70146_Z.nextInt(4) == 0) {
            this.whistle();
        }
        if (this.isShutdown()) {
            double yaw = (double)this.field_70177_z * Math.PI / 180.0;
            double cos = Math.cos(yaw);
            double sin = Math.sin(yaw);
            float limit = 0.05f;
            if (this.field_70159_w > (double)limit && cos < 0.0) {
                this.field_70177_z += 180.0f;
            } else if (this.field_70159_w < (double)(-limit) && cos > 0.0) {
                this.field_70177_z += 180.0f;
            } else if (this.field_70179_y > (double)limit && sin < 0.0) {
                this.field_70177_z += 180.0f;
            } else if (this.field_70179_y < (double)(-limit) && sin > 0.0) {
                this.field_70177_z += 180.0f;
            }
        }
    }

    protected void func_94101_h() {
        this.field_70159_w *= this.getDrag();
        this.field_70181_x *= 0.0;
        this.field_70179_y *= this.getDrag();
        LocoSpeed speed = this.getSpeed();
        if (this.isRunning()) {
            float force = 0.15f;
            switch (speed) {
                case REVERSE: {
                    force = -force;
                    break;
                }
                case MAX: {
                    boolean highSpeed = this.getEntityData().func_74767_n("HighSpeed");
                    if (!highSpeed) break;
                    force = 0.52500004f;
                }
            }
            double yaw = (double)this.field_70177_z * Math.PI / 180.0;
            this.field_70159_w += Math.cos(yaw) * (double)force;
            this.field_70179_y += Math.sin(yaw) * (double)force;
        }
        if (speed != LocoSpeed.MAX) {
            float limit = 0.4f;
            switch (speed) {
                case REVERSE: 
                case SLOWEST: {
                    limit = 0.1f;
                    break;
                }
                case SLOWER: {
                    limit = 0.2f;
                    break;
                }
                case SLOW: {
                    limit = 0.3f;
                }
            }
            this.field_70159_w = Math.copySign(Math.min(Math.abs(this.field_70159_w), (double)limit), this.field_70159_w);
            this.field_70179_y = Math.copySign(Math.min(Math.abs(this.field_70179_y), (double)limit), this.field_70179_y);
        }
    }

    protected void updateFuel() {
        int newFuel;
        if (this.update % 8 == 0 && this.fuel > 0) {
            if (this.isRunning()) {
                LocoSpeed speed = this.getSpeed();
                switch (speed) {
                    case REVERSE: 
                    case SLOWEST: {
                        this.fuel -= 2;
                        break;
                    }
                    case SLOWER: {
                        this.fuel -= 4;
                        break;
                    }
                    case SLOW: {
                        this.fuel -= 6;
                        break;
                    }
                    default: {
                        this.fuel -= 8;
                        break;
                    }
                }
            } else if (this.isIdle()) {
                --this.fuel;
            } else if (this.isShutdown()) {
                this.fuel = 0;
            }
            if (this.fuel < 0) {
                this.fuel = 0;
            }
        }
        while (this.fuel <= 8 && !this.isShutdown() && (newFuel = this.getMoreGoJuice()) > 0) {
            this.fuel += newFuel;
        }
        this.setHasFuel(this.fuel > 0);
    }

    private boolean cartVelocityIsGreaterThan(float vel) {
        return Math.abs(this.field_70159_w) > (double)vel || Math.abs(this.field_70179_y) > (double)vel;
    }

    private boolean isKillabledEntity(Entity entity) {
        if (entity.field_70154_o instanceof EntityMinecart) {
            return false;
        }
        if (!(entity instanceof EntityLiving)) {
            return false;
        }
        return ((EntityLiving)entity).func_70667_aM() < 100;
    }

    public int getDamageToRoadKill(EntityLiving entity) {
        if (entity instanceof EntityPlayer && ItemOveralls.isPlayerWearing((EntityPlayer)entity)) {
            ItemStack pants = ((EntityPlayer)entity).func_71124_b(2);
            InvTools.damageItem(pants, 5);
            return 4;
        }
        return 25;
    }

    public void func_70108_f(Entity entity) {
        if (Game.isHost(this.field_70170_p)) {
            EntityLocomotive otherLoco;
            LinkageManager lm;
            if (entity.field_70128_L) {
                return;
            }
            if (entity != this.field_70153_n && this.cartVelocityIsGreaterThan(0.2f) && this.isKillabledEntity(entity)) {
                EntityLiving living = (EntityLiving)entity;
                if (RailcraftConfig.locomotiveDamageMobs()) {
                    living.func_70097_a((DamageSource)DamageSourceTrain.INSTANCE, this.getDamageToRoadKill(living));
                }
                if (living.func_70630_aN() > 0) {
                    float yaw = (this.field_70177_z - 90.0f) * (float)Math.PI / 180.0f;
                    living.func_70024_g((double)(-MathHelper.func_76126_a((float)yaw) * 1.0f * 0.5f), 0.2, (double)(MathHelper.func_76134_b((float)yaw) * 1.0f * 0.5f));
                }
                return;
            }
            if (entity instanceof EntityLocomotive && !(lm = LinkageManager.instance(this.field_70170_p)).areInSameTrain((EntityMinecart)this, (EntityMinecart)(otherLoco = (EntityLocomotive)entity)) && this.cartVelocityIsGreaterThan(0.2f) && otherLoco.cartVelocityIsGreaterThan(0.2f) && (Math.abs(this.field_70159_w - entity.field_70159_w) > (double)0.3f || Math.abs(this.field_70179_y - entity.field_70179_y) > (double)0.3f)) {
                this.explode();
                if (!otherLoco.field_70128_L) {
                    otherLoco.explode();
                }
                return;
            }
        }
        super.func_70108_f(entity);
    }

    protected void explode() {
        CartUtils.explodeCart((EntityMinecart)this);
        this.func_70106_y();
    }

    public abstract int getMoreGoJuice();

    @Override
    public double getDrag() {
        return 0.9;
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() instanceof ItemWhistleTuner) {
            if (RailcraftConfig.playSounds() && this.whistleDelay <= 0) {
                this.whistlePitch = this.getNewWhistlePitch();
                this.whistle();
                current.func_77972_a(1, (EntityLiving)player);
            }
            return true;
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound data) {
        super.func_70014_b(data);
        data.func_74757_a("isInReverse", this.field_70499_f);
        data.func_74774_a("locomode", (byte)this.getMode().ordinal());
        data.func_74774_a("locospeed", (byte)this.getSpeed().ordinal());
        data.func_74774_a("primaryColor", this.getPrimaryColor());
        data.func_74774_a("secondaryColor", this.getSecondaryColor());
        data.func_74776_a("whistlePitch", this.whistlePitch);
        data.func_74768_a("fuel", this.fuel);
        data.func_74757_a("secure", this.secure);
    }

    public void func_70037_a(NBTTagCompound data) {
        super.func_70037_a(data);
        this.field_70499_f = data.func_74767_n("isInReverse");
        this.setMode(LocoMode.values()[data.func_74771_c("locomode")]);
        this.setSpeed(LocoSpeed.values()[data.func_74771_c("locospeed")]);
        this.setPrimaryColor(data.func_74771_c("primaryColor"));
        this.setSecondaryColor(data.func_74771_c("secondaryColor"));
        this.whistlePitch = data.func_74760_g("whistlePitch");
        this.fuel = data.func_74762_e("fuel");
        this.secure = data.func_74767_n("secure");
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.clientMode.ordinal());
        data.writeByte(this.clientSpeed.ordinal());
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        this.setMode(LocoMode.VALUES[data.readByte()]);
        this.setSpeed(LocoSpeed.VALUES[data.readByte()]);
    }

    public boolean canBeRidden() {
        return false;
    }

    public int func_70302_i_() {
        return 0;
    }

    public boolean isPoweredCart() {
        return true;
    }

    @Override
    public boolean isLinkable() {
        return true;
    }

    @Override
    public boolean canLinkWithCart(EntityMinecart cart) {
        if (cart instanceof EntityLocomotive) {
            return true;
        }
        LinkageManager lm = LinkageManager.instance(this.field_70170_p);
        boolean links = false;
        EntityMinecart linkA = lm.getLinkedCartA((EntityMinecart)this);
        if (linkA != null && !(linkA instanceof EntityLocomotive)) {
            return false;
        }
        EntityMinecart linkB = lm.getLinkedCartB((EntityMinecart)this);
        return linkB == null || linkB instanceof EntityLocomotive;
    }

    @Override
    public boolean hasTwoLinks() {
        return true;
    }

    @Override
    public float getLinkageDistance(EntityMinecart cart) {
        return 1.25f;
    }

    @Override
    public float getOptimalDistance(EntityMinecart cart) {
        return 0.9f;
    }

    @Override
    public boolean canBeAdjusted(EntityMinecart cart) {
        return true;
    }

    @Override
    public void onLinkCreated(EntityMinecart cart) {
    }

    @Override
    public void onLinkBroken(EntityMinecart cart) {
    }

    public abstract String[] getLocomotiveTextures();

    public final byte getPrimaryColor() {
        return this.field_70180_af.func_75683_a(25);
    }

    public final byte getSecondaryColor() {
        return this.field_70180_af.func_75683_a(26);
    }

    public final void setPrimaryColor(int color) {
        this.field_70180_af.func_75692_b(25, (Object)((byte)color));
    }

    public final void setSecondaryColor(int color) {
        this.field_70180_af.func_75692_b(26, (Object)((byte)color));
    }

    public static enum LocoSpeed {
        MAX,
        SLOW,
        SLOWER,
        SLOWEST,
        REVERSE;

        public static final LocoSpeed[] VALUES;

        static {
            VALUES = LocoSpeed.values();
        }
    }

    public static enum LocoMode {
        RUNNING,
        IDLE,
        SHUTDOWN;

        public static final LocoMode[] VALUES;

        static {
            VALUES = LocoMode.values();
        }
    }
}

