/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.core.items.IMinecartItem;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockRail;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemCart
extends ItemMinecart
implements IMinecartItem {
    private final EnumCart type;
    private int rarity = 0;

    public ItemCart(int i, EnumCart cart) {
        super(i, 0);
        this.field_77777_bU = RailcraftConfig.getMinecartStackSize();
        this.type = cart;
        this.func_77655_b(cart.getTag());
        this.func_77656_e(0);
        this.func_77627_a(true);
        BlockDispenser.field_82527_a.func_82595_a((Object)this, null);
    }

    public void func_94581_a(IconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("railcraft:" + MiscTools.cleanTag(this.func_77658_a()));
    }

    public ItemCart setRarity(int rarity) {
        this.rarity = rarity;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.values()[this.rarity];
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int i, int j, int k, int l, float par8, float par9, float par10) {
        if (Game.isNotHost(world)) {
            return false;
        }
        EntityMinecart placedCart = this.placeCart(player.field_71092_bJ, stack, world, i, j, k);
        if (placedCart != null) {
            --stack.field_77994_a;
            return true;
        }
        return false;
    }

    public EnumCart getCartType() {
        return this.type;
    }

    @Override
    public boolean canBePlacedByNonPlayer(ItemStack cart) {
        return true;
    }

    @Override
    public EntityMinecart placeCart(String owner, ItemStack cartStack, World world, int i, int j, int k) {
        int i1 = world.func_72798_a(i, j, k);
        if (BlockRail.func_72184_d((int)i1) && !CartTools.isMinecartAt(world, i, j, k, 0.0f)) {
            EntityMinecart cart = this.type.makeCart(cartStack, world, (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f);
            CartTools.setCartOwner(cart, owner);
            if (world.func_72838_d((Entity)cart)) {
                return cart;
            }
        }
        return null;
    }

    public static EnumCart getCartType(ItemStack cart) {
        if (cart != null && cart.func_77973_b() instanceof ItemCart) {
            return ((ItemCart)cart.func_77973_b()).getCartType();
        }
        return null;
    }
}

