/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.core;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.util.misc.Game;

public class StartupChecks {
    private static String latest = Railcraft.getVersion();
    private static boolean versionCheckCompleted;
    private static boolean hasUpdated;
    private static final String RELEASE_URL = "http://bit.ly/Ppj5UI";
    private static final String BETA_URL = "http://bit.ly/WYwIjf";

    public static void checkForNewVersion() {
        if (!RailcraftConfig.doUpdateCheck()) {
            return;
        }
        VersionCheckThread versionCheckThread = new VersionCheckThread();
        versionCheckThread.start();
    }

    public static boolean hasRailcraftUpdated() {
        return hasUpdated;
    }

    public static boolean isVersionCheckComplete() {
        return versionCheckCompleted;
    }

    public static String getLatestVersion() {
        return latest;
    }

    private static class VersionCheckThread
    extends Thread {
        public VersionCheckThread() {
            super("Railcraft Version Check");
        }

        @Override
        public void run() {
            try {
                String location = StartupChecks.RELEASE_URL;
                if (!Railcraft.getVersion().endsWith("0")) {
                    location = StartupChecks.BETA_URL;
                }
                URLConnection connection = null;
                while (location != null && !location.isEmpty()) {
                    URL url = new URL(location);
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; ru; rv:1.9.0.11) Gecko/2009060215 Firefox/3.0.11 (.NET CLR 3.5.30729)");
                    connection.connect();
                    location = connection.getHeaderField("Location");
                }
                if (connection == null) {
                    return;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                latest = reader.readLine();
                reader.close();
                ((HttpURLConnection)connection).disconnect();
                String[] currentTokens = Railcraft.getVersion().trim().split("\\.");
                String[] latestTokens = latest.trim().split("\\.");
                if (currentTokens.length != latestTokens.length) {
                    Game.log(Level.INFO, "Could not parse version check, an updated version is probably available: {0}", latest);
                    hasUpdated = true;
                    return;
                }
                for (int i = 0; i < currentTokens.length; ++i) {
                    int c = Integer.valueOf(currentTokens[i]);
                    int l = Integer.valueOf(latestTokens[i]);
                    if (l > c) {
                        Game.log(Level.INFO, "An updated version of Railcraft is available from <http://railcraft.info>: {0}", latest);
                        hasUpdated = true;
                    }
                    if (c <= l) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                Game.log(Level.WARNING, "Latest Version Check Failed: {0}", ex);
            }
            versionCheckCompleted = true;
        }
    }
}

