/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.liquids;

import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class TankToolkit
implements ITankContainer {
    private ITankContainer tankContainer;

    public TankToolkit(ITankContainer c) {
        this.tankContainer = c;
    }

    public int getLiquidQty(LiquidStack liquid) {
        if (liquid == null) {
            return 0;
        }
        int amount = 0;
        for (ILiquidTank tank : this.getTanks(ForgeDirection.UNKNOWN)) {
            if (!liquid.isLiquidEqual(tank.getLiquid())) continue;
            amount += tank.getLiquid().amount;
        }
        return amount;
    }

    public boolean isTankEmpty(LiquidStack liquid) {
        return this.getLiquidQty(liquid) <= 0;
    }

    public boolean isTankFull(LiquidStack liquid) {
        if (liquid == null) {
            return false;
        }
        liquid = liquid.copy();
        liquid.amount = 1;
        int fill = this.fill(ForgeDirection.UNKNOWN, liquid, false);
        return fill <= 0;
    }

    public boolean areTanksFull() {
        for (ILiquidTank tank : this.getTanks(ForgeDirection.UNKNOWN)) {
            if (tank.getLiquid() != null && tank.getLiquid().amount >= tank.getCapacity()) continue;
            return false;
        }
        return true;
    }

    public boolean areTanksEmpty() {
        return !this.isLiquidInTank();
    }

    public boolean isLiquidInTank() {
        for (ILiquidTank tank : this.getTanks(ForgeDirection.UNKNOWN)) {
            boolean empty;
            boolean bl = empty = tank.getLiquid() == null || tank.getLiquid().amount <= 0;
            if (empty) continue;
            return true;
        }
        return false;
    }

    public float getLiquidLevel() {
        int amount = 0;
        int capacity = 0;
        for (ILiquidTank tank : this.getTanks(ForgeDirection.UNKNOWN)) {
            LiquidStack liquid = tank.getLiquid();
            amount += liquid == null ? 0 : liquid.amount;
            capacity += tank.getCapacity();
        }
        return capacity == 0 ? 0.0f : (float)(amount / capacity);
    }

    public float getLiquidLevel(LiquidStack filter) {
        int amount = 0;
        int capacity = 0;
        for (ILiquidTank tank : this.getTanks(ForgeDirection.UNKNOWN)) {
            LiquidStack liquid = tank.getLiquid();
            if (liquid == null || !liquid.isLiquidEqual(filter)) continue;
            amount += liquid.amount;
            capacity += tank.getCapacity();
        }
        return capacity == 0 ? 0.0f : (float)amount / (float)capacity;
    }

    public boolean canPutLiquid(ForgeDirection from, LiquidStack liquid) {
        if (liquid == null) {
            return false;
        }
        return this.fill(from, liquid, false) > 0;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.tankContainer.fill(from, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.tankContainer.fill(tankIndex, resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankContainer.drain(from, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return this.tankContainer.drain(tankIndex, maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection side) {
        return this.tankContainer.getTanks(side);
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.tankContainer.getTank(direction, type);
    }
}

