/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.modules;

import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.detector.BlockDetector;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.carts.EntityCartTank;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.ItemNugget;
import mods.railcraft.common.items.ItemPlate;
import mods.railcraft.common.items.RailcraftToolItems;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.modules.RailcraftModule;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;

public class ModuleTransport
extends RailcraftModule {
    private boolean tankCartEnabled = false;

    @Override
    public void initFirst() {
        EnumCart cart;
        EnumMachineGamma liquidUnloader;
        EnumMachineGamma liquidLoader;
        EnumMachineGamma itemUnloader;
        EnumMachineGamma itemLoader;
        EnumMachineAlpha utility = EnumMachineAlpha.TANK_WATER;
        if (RailcraftConfig.isSubBlockEnabled(utility.getTag())) {
            RailcraftBlocks.registerBlockMachineAlpha();
            Block blockUtility = RailcraftBlocks.getBlockMachineAlpha();
            if (blockUtility != null) {
                ItemStack stack = utility.getItem();
                RailcraftLanguage.instance().registerItemName(stack, utility.getTag());
                CraftingPlugin.addShapedOreRecipe(utility.getItem(6), "WWW", "ISI", "WWW", Character.valueOf('I'), new ItemStack(Item.field_77703_o), Character.valueOf('S'), new ItemStack(Item.field_77761_aM), Character.valueOf('W'), "plankWood");
            }
        }
        this.initIronTank();
        this.initSteelTank();
        EnumMachineBeta voidChest = EnumMachineBeta.VOID_CHEST;
        if (RailcraftConfig.isSubBlockEnabled(voidChest.getTag())) {
            RailcraftBlocks.registerBlockMachineBeta();
            Block block = RailcraftBlocks.getBlockMachineBeta();
            if (block != null) {
                ItemStack stack = voidChest.getItem();
                RailcraftLanguage.instance().registerItemName(stack, voidChest.getTag());
                CraftingPlugin.addShapedRecipe(voidChest.getItem(), "OOO", "OPO", "OOO", Character.valueOf('O'), new ItemStack(Block.field_72089_ap), Character.valueOf('P'), new ItemStack(Item.field_77730_bn));
            }
        }
        if (RailcraftConfig.isSubBlockEnabled((itemLoader = EnumMachineGamma.ITEM_LOADER).getTag())) {
            RailcraftBlocks.registerBlockMachineGamma();
            Block blockUtility = RailcraftBlocks.getBlockMachineGamma();
            if (blockUtility != null) {
                ItemStack stack = itemLoader.getItem(1);
                Block blockDetector = RailcraftBlocks.getBlockDetector();
                if (blockDetector != null) {
                    CraftingPlugin.addShapedRecipe(stack, "L", "D", Character.valueOf('D'), new ItemStack(blockDetector, 1, BlockDetector.EnumDetector.ITEM.ordinal()), Character.valueOf('L'), Block.field_71958_P);
                } else {
                    CraftingPlugin.addShapedRecipe(stack, "L", "D", Character.valueOf('D'), Block.field_72044_aK, Character.valueOf('L'), Block.field_94340_cs);
                }
                RailcraftLanguage.instance().registerItemName(stack, itemLoader.getTag());
                itemLoader = EnumMachineGamma.ITEM_LOADER_ADVANCED;
                if (RailcraftConfig.isSubBlockEnabled(itemLoader.getTag())) {
                    ItemStack stackAdvanced = itemLoader.getItem(1);
                    CraftingPlugin.addShapedOreRecipe(stackAdvanced, "IRI", "RLR", "ISI", Character.valueOf('I'), "ingotSteel", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('S'), RailcraftToolItems.getSteelShovel(), Character.valueOf('L'), stack);
                    RailcraftLanguage.instance().registerItemName(stackAdvanced, itemLoader.getTag());
                }
            }
        }
        if (RailcraftConfig.isSubBlockEnabled((itemUnloader = EnumMachineGamma.ITEM_UNLOADER).getTag())) {
            RailcraftBlocks.registerBlockMachineGamma();
            Block blockUtility = RailcraftBlocks.getBlockMachineGamma();
            if (blockUtility != null) {
                ItemStack stack = itemUnloader.getItem(1);
                Block blockDetector = RailcraftBlocks.getBlockDetector();
                if (blockDetector != null) {
                    CraftingPlugin.addShapedRecipe(stack, "D", "L", Character.valueOf('D'), new ItemStack(blockDetector, 1, BlockDetector.EnumDetector.ITEM.ordinal()), Character.valueOf('L'), Block.field_71958_P);
                } else {
                    CraftingPlugin.addShapedRecipe(stack, "D", "L", Character.valueOf('D'), Block.field_72044_aK, Character.valueOf('L'), Block.field_94340_cs);
                }
                RailcraftLanguage.instance().registerItemName(stack, itemUnloader.getTag());
                itemUnloader = EnumMachineGamma.ITEM_UNLOADER_ADVANCED;
                if (RailcraftConfig.isSubBlockEnabled(itemUnloader.getTag())) {
                    ItemStack stackAdvanced = itemUnloader.getItem(1);
                    CraftingPlugin.addShapedOreRecipe(stackAdvanced, "IRI", "RLR", "ISI", Character.valueOf('I'), "ingotSteel", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('S'), RailcraftToolItems.getSteelShovel(), Character.valueOf('L'), stack);
                    RailcraftLanguage.instance().registerItemName(stackAdvanced, itemUnloader.getTag());
                }
            }
        }
        if (RailcraftConfig.isSubBlockEnabled((liquidLoader = EnumMachineGamma.LIQUID_LOADER).getTag())) {
            RailcraftBlocks.registerBlockMachineGamma();
            Block block = RailcraftBlocks.getBlockMachineGamma();
            if (block != null) {
                ItemStack stack = liquidLoader.getItem(1);
                Block blockDetector = RailcraftBlocks.getBlockDetector();
                ItemStack detector = blockDetector != null ? new ItemStack(blockDetector, 1, BlockDetector.EnumDetector.TANK.ordinal()) : new ItemStack(Block.field_72044_aK);
                CraftingPlugin.addShapedRecipe(liquidLoader.getItem(), "GLG", "G G", "GDG", Character.valueOf('D'), detector, Character.valueOf('G'), new ItemStack(Block.field_71946_M), Character.valueOf('L'), Block.field_94340_cs);
                RailcraftLanguage.instance().registerItemName(stack, liquidLoader.getTag());
            }
        }
        if (RailcraftConfig.isSubBlockEnabled((liquidUnloader = EnumMachineGamma.LIQUID_UNLOADER).getTag())) {
            RailcraftBlocks.registerBlockMachineGamma();
            Block block = RailcraftBlocks.getBlockMachineGamma();
            if (block != null) {
                ItemStack stack = liquidUnloader.getItem(1);
                Block blockDetector = RailcraftBlocks.getBlockDetector();
                ItemStack detector = blockDetector != null ? new ItemStack(blockDetector, 1, BlockDetector.EnumDetector.TANK.ordinal()) : new ItemStack(Block.field_72044_aK);
                CraftingPlugin.addShapedRecipe(liquidUnloader.getItem(), "GDG", "G G", "GLG", Character.valueOf('D'), detector, Character.valueOf('G'), new ItemStack(Block.field_71946_M), Character.valueOf('L'), Block.field_94340_cs);
                RailcraftLanguage.instance().registerItemName(stack, liquidUnloader.getTag());
            }
        }
        if ((cart = EnumCart.TANK).setup()) {
            this.tankCartEnabled = true;
            if (EnumMachineBeta.TANK_IRON_GAUGE.isEnabled()) {
                CraftingPlugin.addShapedRecipe(cart.getCartItem(), "T", "M", Character.valueOf('T'), EnumMachineBeta.TANK_IRON_GAUGE.getItem(), Character.valueOf('M'), Item.field_77773_az);
            } else {
                CraftingPlugin.addShapedRecipe(cart.getCartItem(), "GGG", "GMG", "GGG", Character.valueOf('G'), new ItemStack(Block.field_71946_M), Character.valueOf('M'), Item.field_77773_az);
            }
            CraftingPlugin.addShapelessRecipe(new ItemStack(Item.field_77773_az), cart.getCartItem());
        }
    }

    @Override
    public void postInit() {
        if (this.tankCartEnabled) {
            ItemStack stackCartTank = EnumCart.TANK.getCartItem();
            for (LiquidContainerData container : LiquidContainerRegistry.getRegisteredLiquidContainerData()) {
                ItemStack filteredCart = EntityCartTank.getCartItemForFilter(container.filled);
                CraftingManager.func_77594_a().func_77596_b(filteredCart, new Object[]{stackCartTank, container.filled});
                CraftingManager.func_77594_a().func_77596_b(stackCartTank, new Object[]{filteredCart});
            }
        }
    }

    private void addColorRecipes(ItemStack stack) {
        for (EnumColor color : EnumColor.VALUES) {
            ItemStack output = stack.func_77946_l();
            output.field_77994_a = 8;
            NBTTagCompound nbt = new NBTTagCompound("tag");
            output.func_77982_d(nbt);
            nbt.func_74774_a("color", (byte)color.ordinal());
            CraftingPlugin.addShapedOreRecipe(output, "OOO", "ODO", "OOO", Character.valueOf('O'), stack, Character.valueOf('D'), color.getDye());
        }
    }

    private void initIronTank() {
        EnumMachineBeta tankIronValve;
        EnumMachineBeta tankIronGauge;
        EnumMachineBeta tankIronWall = EnumMachineBeta.TANK_IRON_WALL;
        if (RailcraftConfig.isSubBlockEnabled(tankIronWall.getTag())) {
            RailcraftBlocks.registerBlockMachineBeta();
            Block block = RailcraftBlocks.getBlockMachineBeta();
            if (block != null) {
                ItemStack stack = tankIronWall.getItem();
                RailcraftLanguage.instance().registerItemName(stack, tankIronWall.getTag());
                CraftingPlugin.addShapedRecipe(tankIronWall.getItem(8), "PP", "PP", Character.valueOf('P'), ItemPlate.getPlate(ItemPlate.EnumPlate.IRON));
                this.addColorRecipes(tankIronWall.getItem());
                RailcraftCraftingManager.blastFurnace.addRecipe(stack, true, false, 640, ItemNugget.getNugget(ItemNugget.EnumNugget.STEEL, 4));
            }
        }
        if (RailcraftConfig.isSubBlockEnabled((tankIronGauge = EnumMachineBeta.TANK_IRON_GAUGE).getTag())) {
            RailcraftBlocks.registerBlockMachineBeta();
            Block block = RailcraftBlocks.getBlockMachineBeta();
            if (block != null) {
                ItemStack stack = tankIronGauge.getItem();
                RailcraftLanguage.instance().registerItemName(stack, tankIronGauge.getTag());
                CraftingPlugin.addShapedRecipe(tankIronGauge.getItem(8), "GPG", "PGP", "GPG", Character.valueOf('P'), ItemPlate.getPlate(ItemPlate.EnumPlate.IRON), Character.valueOf('G'), new ItemStack(Block.field_72003_bq));
                this.addColorRecipes(tankIronGauge.getItem());
                RailcraftCraftingManager.blastFurnace.addRecipe(stack, true, false, 640, ItemNugget.getNugget(ItemNugget.EnumNugget.STEEL, 4));
            }
        }
        if (RailcraftConfig.isSubBlockEnabled((tankIronValve = EnumMachineBeta.TANK_IRON_VALVE).getTag())) {
            RailcraftBlocks.registerBlockMachineBeta();
            Block block = RailcraftBlocks.getBlockMachineBeta();
            if (block != null) {
                ItemStack stack = tankIronValve.getItem();
                RailcraftLanguage.instance().registerItemName(stack, tankIronValve.getTag());
                CraftingPlugin.addShapedRecipe(tankIronValve.getItem(8), "GPG", "PLP", "GPG", Character.valueOf('P'), ItemPlate.getPlate(ItemPlate.EnumPlate.IRON), Character.valueOf('L'), new ItemStack(Block.field_72043_aJ), Character.valueOf('G'), new ItemStack(Block.field_72002_bp));
                this.addColorRecipes(tankIronValve.getItem());
                RailcraftCraftingManager.blastFurnace.addRecipe(stack, true, false, 640, ItemNugget.getNugget(ItemNugget.EnumNugget.STEEL, 4));
            }
        }
    }

    private void initSteelTank() {
        EnumMachineBeta tankSteelValve;
        EnumMachineBeta tankSteelGauge;
        EnumMachineBeta tankSteelWall = EnumMachineBeta.TANK_STEEL_WALL;
        if (RailcraftConfig.isSubBlockEnabled(tankSteelWall.getTag())) {
            RailcraftBlocks.registerBlockMachineBeta();
            Block block = RailcraftBlocks.getBlockMachineBeta();
            if (block != null) {
                ItemStack stack = tankSteelWall.getItem();
                RailcraftLanguage.instance().registerItemName(stack, tankSteelWall.getTag());
                CraftingPlugin.addShapedRecipe(tankSteelWall.getItem(8), "PP", "PP", Character.valueOf('P'), ItemPlate.getPlate(ItemPlate.EnumPlate.STEEL));
                this.addColorRecipes(tankSteelWall.getItem());
            }
        }
        if (RailcraftConfig.isSubBlockEnabled((tankSteelGauge = EnumMachineBeta.TANK_STEEL_GAUGE).getTag())) {
            RailcraftBlocks.registerBlockMachineBeta();
            Block block = RailcraftBlocks.getBlockMachineBeta();
            if (block != null) {
                ItemStack stack = tankSteelGauge.getItem();
                RailcraftLanguage.instance().registerItemName(stack, tankSteelGauge.getTag());
                CraftingPlugin.addShapedRecipe(tankSteelGauge.getItem(8), "GPG", "PGP", "GPG", Character.valueOf('P'), ItemPlate.getPlate(ItemPlate.EnumPlate.STEEL), Character.valueOf('G'), new ItemStack(Block.field_72003_bq));
                this.addColorRecipes(tankSteelGauge.getItem());
            }
        }
        if (RailcraftConfig.isSubBlockEnabled((tankSteelValve = EnumMachineBeta.TANK_STEEL_VALVE).getTag())) {
            RailcraftBlocks.registerBlockMachineBeta();
            Block block = RailcraftBlocks.getBlockMachineBeta();
            if (block != null) {
                ItemStack stack = tankSteelValve.getItem();
                RailcraftLanguage.instance().registerItemName(stack, tankSteelValve.getTag());
                CraftingPlugin.addShapedRecipe(tankSteelValve.getItem(8), "GPG", "PLP", "GPG", Character.valueOf('P'), ItemPlate.getPlate(ItemPlate.EnumPlate.STEEL), Character.valueOf('L'), new ItemStack(Block.field_72043_aJ), Character.valueOf('G'), new ItemStack(Block.field_72002_bp));
                this.addColorRecipes(tankSteelValve.getItem());
            }
        }
    }
}

