/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.buildcraft.actions;

import buildcraft.api.core.IIconProvider;
import buildcraft.api.gates.IAction;
import mods.railcraft.common.plugins.buildcraft.actions.Actions;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.Icon;

public abstract class ActionBase
implements IAction {
    private static final IIconProvider ICON_PROVIDER = new ActionIconProvider();
    private final int id;
    private Actions type;

    public ActionBase(int id) {
        this.id = id;
    }

    @Override
    public final int getId() {
        return this.id;
    }

    final void setEnum(Actions type) {
        this.type = type;
    }

    public final Actions getEnum() {
        return this.type;
    }

    @Override
    public final int getIconIndex() {
        return this.type.ordinal();
    }

    @Override
    public final IIconProvider getIconProvider() {
        return ICON_PROVIDER;
    }

    @Override
    public boolean hasParameter() {
        return false;
    }

    @Override
    public abstract String getDescription();

    private static class ActionIconProvider
    implements IIconProvider {
        private Icon[] icons;

        private ActionIconProvider() {
        }

        @Override
        public Icon getIcon(int iconIndex) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void registerIcons(IconRegister iconRegister) {
            this.icons = new Icon[Actions.VALUES.length];
            for (Actions action : Actions.VALUES) {
                this.icons[action.ordinal()] = iconRegister.func_94245_a("railcraft:buildcraft.gate.action." + action.toString());
            }
        }
    }
}

