/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.buildcraft.triggers;

import buildcraft.api.core.IIconProvider;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.TriggerParameter;
import java.util.EnumSet;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.common.blocks.machine.beta.TileEngine;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.plugins.buildcraft.triggers.Trigger;
import mods.railcraft.common.plugins.buildcraft.triggers.TriggerAspect;
import mods.railcraft.common.plugins.buildcraft.triggers.TriggerEngine;
import mods.railcraft.common.plugins.buildcraft.triggers.TriggerHasCart;
import mods.railcraft.common.plugins.buildcraft.triggers.TriggerHasWork;
import mods.railcraft.common.plugins.buildcraft.triggers.TriggerLowFuel;
import mods.railcraft.common.plugins.buildcraft.triggers.TriggerMaintenance;
import mods.railcraft.common.plugins.buildcraft.triggers.TriggerTemp;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public enum Triggers implements ITrigger
{
    HAS_WORK(400, "work", (Trigger)new TriggerHasWork()),
    HAS_CART(401, "cart", (Trigger)new TriggerHasCart()),
    ENGINE_BLUE(402, "engine.blue", (Trigger)new TriggerEngine(EnumSet.of(TileEngine.EnergyStage.BLUE))),
    ENGINE_GREEN(403, "engine.green", (Trigger)new TriggerEngine(EnumSet.of(TileEngine.EnergyStage.GREEN))),
    ENGINE_YELLOW(404, "engine.yellow", (Trigger)new TriggerEngine(EnumSet.of(TileEngine.EnergyStage.YELLOW))),
    ENGINE_ORANGE(405, "engine.orange", (Trigger)new TriggerEngine(EnumSet.of(TileEngine.EnergyStage.ORANGE))),
    ENGINE_RED(406, "engine.red", (Trigger)new TriggerEngine(EnumSet.of(TileEngine.EnergyStage.RED, TileEngine.EnergyStage.OVERHEAT))),
    LOW_FUEL(407, "fuel", (Trigger)new TriggerLowFuel()),
    TEMP_COLD(408, "temp.cold", (Trigger)new TriggerTemp(0, 100)),
    TEMP_WARM(409, "temp.warm", (Trigger)new TriggerTemp(100, 300)),
    TEMP_HOT(410, "temp.hot", (Trigger)new TriggerTemp(300, Integer.MAX_VALUE)),
    NEEDS_MAINT(411, "maintenance", (Trigger)new TriggerMaintenance()),
    ASPECT_GREEN(412, "aspect.green", (Trigger)new TriggerAspect(SignalAspect.GREEN)),
    ASPECT_BLINK_YELLOW(413, "aspect.yellow.blink", (Trigger)new TriggerAspect(SignalAspect.BLINK_YELLOW)),
    ASPECT_YELLOW(414, "aspect.yellow", (Trigger)new TriggerAspect(SignalAspect.YELLOW)),
    ASPECT_BLINK_RED(415, "aspect.red.blink", (Trigger)new TriggerAspect(SignalAspect.BLINK_RED)),
    ASPECT_RED(416, "aspect.red", (Trigger)new TriggerAspect(SignalAspect.RED)),
    ASPECT_OFF(417, "aspect.off", (Trigger)new TriggerAspect(SignalAspect.OFF));

    public static final Triggers[] VALUES;
    private static final IIconProvider ICON_PROVIDER;
    private final Trigger trigger;
    private final int id;
    private final String tag;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private Triggers(Trigger id) {
        void trigger;
        void tag;
        this.id = (int)id;
        this.tag = tag;
        this.trigger = trigger;
    }

    public static void init() {
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getIconIndex() {
        return this.ordinal();
    }

    @Override
    public IIconProvider getIconProvider() {
        return ICON_PROVIDER;
    }

    @Override
    public boolean hasParameter() {
        return false;
    }

    @Override
    public String getDescription() {
        return RailcraftLanguage.translate("gates.trigger." + this.tag);
    }

    @Override
    public boolean isTriggerActive(ForgeDirection side, TileEntity tile, ITriggerParameter parameter) {
        return this.trigger.isTriggerActive(side, tile, parameter);
    }

    @Override
    public ITriggerParameter createParameter() {
        return new TriggerParameter();
    }

    static {
        VALUES = Triggers.values();
        ICON_PROVIDER = new IconProvider();
    }

    private static class IconProvider
    implements IIconProvider {
        private Icon[] icons;

        private IconProvider() {
        }

        @Override
        public Icon getIcon(int iconIndex) {
            return this.icons[iconIndex];
        }

        @Override
        public void registerIcons(IconRegister iconRegister) {
            this.icons = new Icon[VALUES.length];
            for (Triggers trigger : VALUES) {
                this.icons[trigger.ordinal()] = iconRegister.func_94245_a("railcraft:buildcraft.gate.trigger." + trigger.tag);
            }
        }
    }
}

