/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.forestry;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import forestry.api.core.ItemInterface;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.EnumBackpackType;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.plugins.forestry.IceManTickHandler;
import mods.railcraft.common.plugins.forestry.IcemanBackpack;
import mods.railcraft.common.plugins.forestry.TrackmanBackpack;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.liquids.LiquidStack;

public class ForestryPlugin {
    public static Boolean modLoaded = null;
    public static Item trackmanBackpackT1;
    public static Item trackmanBackpackT2;
    public static Item icemanBackpackT1;
    public static Item icemanBackpackT2;

    public static ItemStack getItem(String tag) {
        if (!ForestryPlugin.isForestryInstalled()) {
            return null;
        }
        try {
            return ItemInterface.getItem(tag);
        }
        catch (Throwable error) {
            Game.logErrorAPI("Forestry", error);
            return null;
        }
    }

    public static void addBackpackItem(String pack, ItemStack stack) {
        if (stack == null) {
            return;
        }
        FMLInterModComms.sendMessage((String)"Forestry", (String)"add-backpack-items", (String)String.format("%s@%d:%d", pack, stack.field_77993_c, stack.func_77960_j()));
    }

    public static void addBackpackItem(String pack, int id, int meta) {
        FMLInterModComms.sendMessage((String)"Forestry", (String)"add-backpack-items", (String)String.format("%s@%d:%d", pack, id, meta));
    }

    public static void registerBackpacks() {
        try {
            ItemStack output;
            ItemStack silk;
            ItemStack output2;
            if (BackpackManager.backpackInterface == null) {
                return;
            }
            String tag = "railcraft.backpack.trackman.t1";
            int id = RailcraftConfig.getItemId(tag);
            if (id > 0) {
                trackmanBackpackT1 = BackpackManager.backpackInterface.addBackpack(id, TrackmanBackpack.getInstance(), EnumBackpackType.T1).func_77637_a(CreativePlugin.TAB);
                RailcraftLanguage.instance().registerItemName(trackmanBackpackT1, tag);
                output2 = new ItemStack(trackmanBackpackT1);
                ForestryPlugin.addBackpackTooltip(output2);
                CraftingPlugin.addShapedRecipe(output2, "X#X", "VYV", "X#X", Character.valueOf('#'), Block.field_72101_ab, Character.valueOf('V'), new ItemStack(Block.field_72056_aG), Character.valueOf('X'), Item.field_77683_K, Character.valueOf('Y'), new ItemStack((Block)Block.field_72077_au));
            }
            if ((id = RailcraftConfig.getItemId(tag = "railcraft.backpack.trackman.t2")) > 0) {
                trackmanBackpackT2 = BackpackManager.backpackInterface.addBackpack(id, TrackmanBackpack.getInstance(), EnumBackpackType.T2).func_77637_a(CreativePlugin.TAB);
                RailcraftLanguage.instance().registerItemName(trackmanBackpackT2, tag);
                silk = ForestryPlugin.getItem("craftingMaterial");
                if (silk != null) {
                    silk.func_77964_b(3);
                    output = new ItemStack(trackmanBackpackT2);
                    ForestryPlugin.addBackpackTooltip(output);
                    RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(Block.field_71943_B, 1000), null, output, new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Item.field_77702_n, Character.valueOf('W'), silk, Character.valueOf('T'), trackmanBackpackT1});
                }
            }
            if ((id = RailcraftConfig.getItemId(tag = "railcraft.backpack.iceman.t1")) > 0) {
                icemanBackpackT1 = BackpackManager.backpackInterface.addBackpack(id, IcemanBackpack.getInstance(), EnumBackpackType.T1).func_77637_a(CreativePlugin.TAB);
                RailcraftLanguage.instance().registerItemName(icemanBackpackT1, tag);
                output2 = new ItemStack(icemanBackpackT1);
                ForestryPlugin.addBackpackTooltip(output2);
                CraftingPlugin.addShapedRecipe(output2, "X#X", "VYV", "X#X", Character.valueOf('#'), Block.field_72101_ab, Character.valueOf('V'), new ItemStack(Block.field_72039_aU), Character.valueOf('X'), Item.field_77683_K, Character.valueOf('Y'), new ItemStack((Block)Block.field_72077_au));
            }
            if ((id = RailcraftConfig.getItemId(tag = "railcraft.backpack.iceman.t2")) > 0) {
                icemanBackpackT2 = BackpackManager.backpackInterface.addBackpack(id, IcemanBackpack.getInstance(), EnumBackpackType.T2).func_77637_a(CreativePlugin.TAB);
                RailcraftLanguage.instance().registerItemName(icemanBackpackT2, tag);
                silk = ForestryPlugin.getItem("craftingMaterial");
                if (silk != null) {
                    silk.func_77964_b(3);
                    output = new ItemStack(icemanBackpackT2);
                    ForestryPlugin.addBackpackTooltip(output);
                    RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(Block.field_71943_B, 1000), null, output, new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Item.field_77702_n, Character.valueOf('W'), silk, Character.valueOf('T'), icemanBackpackT1});
                }
            }
            if (icemanBackpackT1 != null || icemanBackpackT2 != null) {
                TickRegistry.registerTickHandler((ITickHandler)new IceManTickHandler(), (Side)Side.SERVER);
            }
        }
        catch (Throwable error) {
            Game.logErrorAPI("Forestry", error);
        }
    }

    private static void addBackpackTooltip(ItemStack stack) {
        NBTTagCompound nbt = InvTools.getItemData(stack);
        NBTTagCompound display = nbt.func_74775_l("display");
        nbt.func_74766_a("display", display);
        NBTTagList lore = display.func_74761_m("Lore");
        display.func_74782_a("Lore", (NBTBase)lore);
        lore.func_74742_a((NBTBase)new NBTTagString("madeby", "\u00a77\u00a7o" + RailcraftLanguage.translate("backpack.tooltip")));
    }

    public static void setupBackpackContents() {
        try {
            if (BackpackManager.backpackInterface == null) {
                return;
            }
            TrackmanBackpack.getInstance().setup();
            IcemanBackpack.getInstance().setup();
        }
        catch (Throwable error) {
            Game.logErrorAPI("Forestry", error);
        }
    }

    public static boolean isForestryInstalled() {
        if (modLoaded == null) {
            modLoaded = Loader.isModLoaded((String)"Forestry");
        }
        return modLoaded;
    }
}

