/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.inventory;

import buildcraft.api.inventory.ISelectiveInventory;
import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.transport.PipeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.util.inventory.InventoryMapper;
import mods.railcraft.common.util.inventory.ItemStackMap;
import mods.railcraft.common.util.inventory.SelectiveInventoryMapper;
import mods.railcraft.common.util.inventory.SpecialInventoryMapper;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import mods.railcraft.common.util.inventory.filters.ArrayStackFilter;
import mods.railcraft.common.util.inventory.filters.EnumStackFilter;
import mods.railcraft.common.util.inventory.filters.InvertedStackFilter;
import mods.railcraft.common.util.inventory.manipulators.InventoryManipulator;
import mods.railcraft.common.util.misc.EnumColor;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public abstract class InvTools {
    private static final String TAG_ID = "id";
    private static final String TAG_SIZE = "stackSize";
    private static final String TAG_DAMAGE = "Damage";
    private static final String TAG_COUNT = "Count";
    private static final String TAG_NBT = "tag";
    private static final String TAG_SLOT = "Slot";

    public static List getAdjacentInventories(World world, int i, int j, int k) {
        return InvTools.getAdjacentInventories(world, i, j, k, null);
    }

    public static List getAdjacentInventories(World world, int i, int j, int k, Class type) {
        ArrayList<IInventory> list = new ArrayList<IInventory>(5);
        for (int side = 0; side < 6; ++side) {
            IInventory inv = InvTools.getInventoryFromSide(world, i, j, k, ForgeDirection.getOrientation((int)side), type, null);
            if (inv == null) continue;
            list.add(inv);
        }
        return list;
    }

    public static Map getAdjacentInventoryMap(World world, int i, int j, int k) {
        return InvTools.getAdjacentInventoryMap(world, i, j, k, null);
    }

    public static Map getAdjacentInventoryMap(World world, int i, int j, int k, Class type) {
        TreeMap<Integer, IInventory> map = new TreeMap<Integer, IInventory>();
        for (int side = 0; side < 6; ++side) {
            IInventory inv = InvTools.getInventoryFromSide(world, i, j, k, ForgeDirection.getOrientation((int)side), type, null);
            if (inv == null) continue;
            map.put(side, inv);
        }
        return map;
    }

    public static IInventory getInventoryFromSide(World world, int x, int y, int z, ForgeDirection side, Class type, Class exclude) {
        TileEntity tile = world.func_72796_p(x = MiscTools.getXOnSide(x, side), y = MiscTools.getYOnSide(y, side), z = MiscTools.getZOnSide(z, side));
        if (tile == null || !(tile instanceof IInventory) || type != null && !type.isAssignableFrom(tile.getClass()) || exclude != null && exclude.isAssignableFrom(tile.getClass())) {
            return null;
        }
        if (!PipeManager.canExtractItems(null, world, x, y, z)) {
            return null;
        }
        IInventory inv = (IInventory)tile;
        ForgeDirection oppositeSide = side.getOpposite();
        if (inv instanceof ISelectiveInventory) {
            inv = new SelectiveInventoryMapper((ISelectiveInventory)inv, side);
        } else if (inv instanceof ISpecialInventory) {
            inv = new SpecialInventoryMapper((ISpecialInventory)inv, oppositeSide);
        } else if (inv instanceof ISidedInventory) {
            inv = new InventoryMapper((ISidedInventory)inv, oppositeSide);
        } else if (inv instanceof TileEntityChest) {
            for (int s = 2; s < 6; ++s) {
                tile = MiscTools.getBlockTileEntityOnSide(world, x, y, z, ForgeDirection.getOrientation((int)s));
                if (!(tile instanceof TileEntityChest)) continue;
                IInventory inv2 = (IInventory)tile;
                return new InventoryLargeChest("Large Chest", inv, inv2);
            }
        }
        return inv;
    }

    public static IInventory getInventoryFromTile(TileEntity tile, ForgeDirection side) {
        if (tile == null || !(tile instanceof IInventory)) {
            return null;
        }
        if (!PipeManager.canExtractItems(null, tile.field_70331_k, tile.field_70329_l, tile.field_70330_m, tile.field_70327_n)) {
            return null;
        }
        IInventory inv = (IInventory)tile;
        ForgeDirection oppositeSide = side.getOpposite();
        if (inv instanceof ISelectiveInventory) {
            inv = new SelectiveInventoryMapper((ISelectiveInventory)inv, oppositeSide);
        } else if (inv instanceof ISpecialInventory) {
            inv = new SpecialInventoryMapper((ISpecialInventory)inv, oppositeSide);
        } else if (inv instanceof ISidedInventory) {
            inv = new InventoryMapper((ISidedInventory)inv, oppositeSide);
        } else if (inv instanceof TileEntityChest) {
            for (int s = 2; s < 6; ++s) {
                tile = MiscTools.getBlockTileEntityOnSide(tile.field_70331_k, tile.field_70329_l, tile.field_70330_m, tile.field_70327_n, ForgeDirection.getOrientation((int)s));
                if (!(tile instanceof TileEntityChest)) continue;
                IInventory inv2 = (IInventory)tile;
                return new InventoryLargeChest("Large Chest", inv, inv2);
            }
        }
        return inv;
    }

    public static EnumColor getItemColor(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.field_77993_c == Block.field_72101_ab.field_71990_ca) {
            return EnumColor.fromId(15 - stack.func_77960_j());
        }
        if (stack.field_77993_c == Item.field_77756_aW.field_77779_bT) {
            return EnumColor.fromId(stack.func_77960_j());
        }
        return null;
    }

    public static boolean isSynthetic(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74764_b("synthetic");
    }

    public static void markItemSynthetic(ItemStack stack) {
        NBTTagCompound nbt = InvTools.getItemData(stack);
        nbt.func_74757_a("synthetic", true);
        NBTTagCompound display = nbt.func_74775_l("display");
        nbt.func_74766_a("display", display);
        NBTTagList lore = display.func_74761_m("Lore");
        display.func_74782_a("Lore", (NBTBase)lore);
        lore.func_74742_a((NBTBase)new NBTTagString("Synthetic", "\u00a77\u00a7o" + RailcraftLanguage.translate("item.synthetic")));
    }

    public static void addItemToolTip(ItemStack stack, String tag, String msg) {
        NBTTagCompound nbt = InvTools.getItemData(stack);
        NBTTagCompound display = nbt.func_74775_l("display");
        nbt.func_74766_a("display", display);
        NBTTagList lore = display.func_74761_m("Lore");
        display.func_74782_a("Lore", (NBTBase)lore);
        lore.func_74742_a((NBTBase)new NBTTagString(tag, msg));
    }

    public static NBTTagCompound getItemData(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound(TAG_NBT);
            stack.func_77982_d(nbt);
        }
        return nbt;
    }

    public static ItemStack depleteItem(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            return stack.func_77973_b().getContainerItemStack(stack);
        }
        stack.func_77979_a(1);
        return stack;
    }

    public static ItemStack damageItem(ItemStack stack, int damage) {
        if (!stack.func_77984_f()) {
            return stack;
        }
        int curDamage = stack.func_77960_j();
        stack.func_77964_b(curDamage += damage);
        if (stack.func_77960_j() >= stack.func_77958_k()) {
            --stack.field_77994_a;
            stack.func_77964_b(0);
        }
        if (stack.field_77994_a <= 0) {
            stack = null;
        }
        return stack;
    }

    public static void dropItem(ItemStack stack, World world, double x, double y, double z) {
        if (stack == null || stack.field_77994_a < 1) {
            return;
        }
        EntityItem entityItem = new EntityItem(world, x, y + 1.5, z, stack);
        entityItem.field_70293_c = 10;
        world.func_72838_d((Entity)entityItem);
    }

    public static void dropInventory(IInventory inv, World world, int x, int y, int z) {
        if (Game.isNotHost(world)) {
            return;
        }
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack stack = inv.func_70301_a(slot);
            if (stack == null) continue;
            float xOffset = MiscTools.getRand().nextFloat() * 0.8f + 0.1f;
            float yOffset = MiscTools.getRand().nextFloat() * 0.8f + 0.1f;
            float zOffset = MiscTools.getRand().nextFloat() * 0.8f + 0.1f;
            while (stack.field_77994_a > 0) {
                int numToDrop = MiscTools.getRand().nextInt(21) + 10;
                if (numToDrop > stack.field_77994_a) {
                    numToDrop = stack.field_77994_a;
                }
                ItemStack newStack = stack.func_77946_l();
                newStack.field_77994_a = numToDrop;
                stack.field_77994_a -= numToDrop;
                EntityItem entityItem = new EntityItem(world, (double)((float)x + xOffset), (double)((float)y + yOffset), (double)((float)z + zOffset), newStack);
                float variance = 0.05f;
                entityItem.field_70159_w = (float)MiscTools.getRand().nextGaussian() * variance;
                entityItem.field_70181_x = (float)MiscTools.getRand().nextGaussian() * variance + 0.2f;
                entityItem.field_70179_y = (float)MiscTools.getRand().nextGaussian() * variance;
                world.func_72838_d((Entity)entityItem);
            }
            inv.func_70299_a(slot, null);
        }
    }

    public static boolean isInventoryEmpty(IInventory inv) {
        ItemStack stack = null;
        for (int slot = 0; slot < inv.func_70302_i_() && (stack = inv.func_70301_a(slot)) == null; ++slot) {
        }
        return stack == null;
    }

    public static boolean isInventoryEmpty(IInventory inv, ForgeDirection side) {
        if (inv instanceof ISidedInventory) {
            ISidedInventory sided = (ISidedInventory)inv;
            inv = new InventoryMapper(inv, sided.getStartInventorySide(side), sided.getSizeInventorySide(side));
        }
        ItemStack stack = null;
        for (int slot = 0; slot < inv.func_70302_i_() && (stack = inv.func_70301_a(slot)) == null; ++slot) {
        }
        return stack == null;
    }

    public static boolean isInventoryFull(IInventory inv) {
        ItemStack stack = null;
        for (int slot = 0; slot < inv.func_70302_i_() && (stack = inv.func_70301_a(slot)) != null; ++slot) {
        }
        return stack != null;
    }

    public static boolean isInventoryFull(IInventory inv, ForgeDirection side) {
        if (inv instanceof ISidedInventory) {
            ISidedInventory sided = (ISidedInventory)inv;
            inv = new InventoryMapper(inv, sided.getStartInventorySide(side), sided.getSizeInventorySide(side));
        }
        ItemStack stack = null;
        for (int slot = 0; slot < inv.func_70302_i_() && (stack = inv.func_70301_a(slot)) != null; ++slot) {
        }
        return stack != null;
    }

    public static int countItems(IInventory inv) {
        int count = 0;
        ItemStack stack = null;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            stack = inv.func_70301_a(slot);
            if (stack == null) continue;
            count += stack.field_77994_a;
        }
        return count;
    }

    public static int countItems(IInventory inv, IStackFilter filter) {
        int count = 0;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack stack = inv.func_70301_a(slot);
            if (stack == null || !filter.matches(stack)) continue;
            count += stack.field_77994_a;
        }
        return count;
    }

    public static int countItems(IInventory inv, ItemStack ... filters) {
        if (inv instanceof InventoryMapper) {
            inv = ((InventoryMapper)inv).getBaseInventory();
        }
        boolean hasFilter = false;
        for (ItemStack filter : filters) {
            if (filter == null) continue;
            hasFilter = true;
            break;
        }
        if (!hasFilter) {
            return InvTools.countItems(inv);
        }
        int count = 0;
        ItemStack stack = null;
        block1: for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            stack = inv.func_70301_a(slot);
            if (stack == null) continue;
            for (ItemStack filter : filters) {
                if (filter == null || !InvTools.isItemEqual(stack, filter)) continue;
                count += stack.field_77994_a;
                continue block1;
            }
        }
        return count;
    }

    public static int countItems(Collection inventories, ItemStack ... filter) {
        int count = 0;
        for (IInventory inv : inventories) {
            count += InvTools.countItems(inv, filter);
        }
        return count;
    }

    public static boolean containsItem(IInventory inv, ItemStack item) {
        return InvTools.countItems(inv, item) > 0;
    }

    public static Map getManifest(IInventory inv) {
        ItemStackMap manifest = new ItemStackMap();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack slot = inv.func_70301_a(i);
            if (slot == null) continue;
            Integer count = (Integer)manifest.get(slot);
            if (count == null) {
                count = 0;
            }
            count = count + slot.field_77994_a;
            manifest.put(slot, count);
        }
        return manifest;
    }

    public static ItemStack moveOneItem(IInventory source, IInventory dest) {
        return InvTools.moveOneItem(source, dest, EnumStackFilter.ALL);
    }

    public static ItemStack moveOneItem(IInventory source, IInventory dest, ItemStack ... filters) {
        return InvTools.moveOneItem(source, dest, new ArrayStackFilter(filters));
    }

    public static ItemStack moveOneItem(IInventory source, IInventory dest, IStackFilter filter) {
        InventoryManipulator imDest;
        ItemStack remainder;
        InventoryManipulator imSource = InventoryManipulator.get(source);
        ItemStack stack = imSource.tryRemoveStack(filter);
        if (stack != null && (remainder = (imDest = InventoryManipulator.get(dest)).addStack(stack)) == null) {
            imSource.removeStack(filter);
            return stack;
        }
        return null;
    }

    public static ItemStack moveOneItem(List sources, IInventory dest, ItemStack ... filters) {
        for (IInventory inv : sources) {
            ItemStack moved = InvTools.moveOneItem(inv, dest, filters);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static ItemStack moveOneItem(IInventory source, List destinations, ItemStack ... filters) {
        for (IInventory dest : destinations) {
            ItemStack moved = InvTools.moveOneItem(source, dest, filters);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static ItemStack moveOneItemExcept(IInventory source, IInventory dest, ItemStack ... filters) {
        return InvTools.moveOneItem(source, dest, new InvertedStackFilter(new ArrayStackFilter(filters)));
    }

    public static ItemStack moveOneItemExcept(List sources, IInventory dest, ItemStack ... filters) {
        for (IInventory inv : sources) {
            ItemStack moved = InvTools.moveOneItemExcept(inv, dest, filters);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static ItemStack moveOneItemExcept(IInventory source, List destinations, ItemStack ... filters) {
        for (IInventory dest : destinations) {
            ItemStack moved = InvTools.moveOneItemExcept(source, dest, filters);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static boolean isWildcard(ItemStack stack) {
        return InvTools.isWildcard(stack.func_77960_j());
    }

    public static boolean isWildcard(int damage) {
        return damage == -1 || damage == Short.MAX_VALUE;
    }

    public static boolean isItemEqualStrict(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.field_77993_c != b.field_77993_c) {
            return false;
        }
        if (a.field_77994_a != b.field_77994_a) {
            return false;
        }
        if (a.func_77981_g() && a.func_77960_j() != b.func_77960_j()) {
            return false;
        }
        return a.field_77990_d == null || a.field_77990_d.equals((Object)b.field_77990_d);
    }

    public static boolean isItemEqual(ItemStack a, ItemStack b) {
        return InvTools.isItemEqual(a, b, true, true);
    }

    public static boolean isItemEqualIgnoreNBT(ItemStack a, ItemStack b) {
        return InvTools.isItemEqual(a, b, true, false);
    }

    public static boolean isItemEqual(ItemStack a, ItemStack b, boolean matchDamage, boolean matchNBT) {
        if (a == null || b == null) {
            return false;
        }
        if (a.field_77993_c != b.field_77993_c) {
            return false;
        }
        if (matchNBT && a.field_77990_d != null && !a.field_77990_d.equals((Object)b.field_77990_d)) {
            return false;
        }
        if (matchDamage && a.func_77981_g()) {
            if (InvTools.isWildcard(a) || InvTools.isWildcard(b)) {
                return true;
            }
            if (a.func_77960_j() != b.func_77960_j()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isItemEqual(ItemStack stack, ItemStack ... matches) {
        for (ItemStack match : matches) {
            if (!InvTools.isItemEqual(stack, match)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemEqual(ItemStack stack, Collection matches) {
        for (ItemStack match : matches) {
            if (!InvTools.isItemEqual(stack, match)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack moveItemStack(ItemStack stack, IInventory dest) {
        InventoryManipulator im = InventoryManipulator.get(dest);
        return im.addStack(stack);
    }

    public static boolean isRoomForStack(ItemStack stack, IInventory dest) {
        if (stack == null || dest == null) {
            return false;
        }
        InventoryManipulator im = InventoryManipulator.get(dest);
        return im.canAddStack(stack);
    }

    public static ItemStack[] removeItems(IInventory inv, int numItems) {
        if (inv instanceof ISpecialInventory) {
            return ((ISpecialInventory)inv).extractItem(true, ForgeDirection.UNKNOWN, numItems);
        }
        StandaloneInventory output = new StandaloneInventory(27);
        for (int i = 0; i < inv.func_70302_i_() && numItems > 0; ++i) {
            ItemStack slot = inv.func_70301_a(i);
            if (slot == null) continue;
            ItemStack removed = inv.func_70298_a(i, numItems);
            numItems -= removed.field_77994_a;
            ItemStack remainder = InvTools.moveItemStack(removed, output);
            if (remainder == null) continue;
            InvTools.moveItemStack(remainder, inv);
            numItems += remainder.field_77994_a;
            break;
        }
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        for (ItemStack stack : output.getContents()) {
            if (stack == null) continue;
            list.add(stack);
        }
        return list.toArray(new ItemStack[0]);
    }

    public static ItemStack removeOneItem(IInventory inv) {
        return InvTools.removeOneItem(inv, EnumStackFilter.ALL);
    }

    public static ItemStack removeOneItem(IInventory inv, ItemStack ... filter) {
        return InvTools.removeOneItem(inv, new ArrayStackFilter(filter));
    }

    public static ItemStack removeOneItem(IInventory inv, IStackFilter filter) {
        InventoryManipulator im = InventoryManipulator.get(inv);
        return im.removeStack(filter);
    }

    public static void writeInvToNBT(IInventory inv, String tag, NBTTagCompound data) {
        NBTTagList list = new NBTTagList();
        for (byte slot = 0; slot < inv.func_70302_i_(); slot = (byte)((byte)(slot + 1))) {
            ItemStack stack = inv.func_70301_a((int)slot);
            if (stack == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a(TAG_SLOT, slot);
            InvTools.writeItemToNBT(stack, itemTag);
            list.func_74742_a((NBTBase)itemTag);
        }
        data.func_74782_a(tag, (NBTBase)list);
    }

    public static void readInvFromNBT(IInventory inv, String tag, NBTTagCompound data) {
        NBTTagList list = data.func_74761_m(tag);
        for (int entry = 0; entry < list.func_74745_c(); entry = (int)((byte)(entry + 1))) {
            NBTTagCompound itemTag = (NBTTagCompound)list.func_74743_b(entry);
            byte slot = itemTag.func_74771_c(TAG_SLOT);
            if (slot < 0 || slot >= inv.func_70302_i_()) continue;
            ItemStack stack = InvTools.readItemFromNBT(itemTag);
            inv.func_70299_a((int)slot, stack);
        }
    }

    public static void writeItemToNBT(ItemStack stack, NBTTagCompound data) {
        if (stack == null || stack.field_77994_a <= 0) {
            return;
        }
        if (stack.field_77994_a > 127) {
            stack.field_77994_a = 127;
        }
        stack.func_77955_b(data);
    }

    public static ItemStack readItemFromNBT(NBTTagCompound data) {
        short itemID = data.func_74765_d(TAG_ID);
        short stackSize = data.func_74765_d(TAG_SIZE);
        short damage = data.func_74765_d(TAG_DAMAGE);
        if (stackSize <= 0) {
            stackSize = data.func_74771_c(TAG_COUNT);
        }
        if (itemID <= 0 || stackSize <= 0) {
            return null;
        }
        ItemStack stack = new ItemStack((int)itemID, (int)stackSize, (int)damage);
        if (data.func_74764_b(TAG_NBT)) {
            stack.field_77990_d = data.func_74775_l(TAG_NBT);
        }
        return stack.func_77973_b() != null ? stack : null;
    }
}

