/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.inventory.filters;

import mods.railcraft.api.core.items.IMinecartItem;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.api.core.items.ITrackItem;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.util.misc.BallastRegistry;
import net.minecraft.block.BlockRail;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;

public enum EnumStackFilter implements IStackFilter
{
    ALL,
    FUEL,
    TRACK,
    MINECART,
    BALLAST,
    FEED;


    public static void initialize() {
        for (EnumStackFilter type : EnumStackFilter.values()) {
            IStackFilter.filters.put(type.name(), type);
        }
    }

    @Override
    public boolean matches(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        switch (this) {
            case ALL: {
                return true;
            }
            case FUEL: {
                return FuelPlugin.getBurnTime(stack) > 0;
            }
            case TRACK: {
                return stack.func_77973_b() instanceof ITrackItem || stack.func_77973_b() instanceof ItemBlock && BlockRail.func_72184_d((int)stack.field_77993_c);
            }
            case MINECART: {
                return stack.func_77973_b() instanceof ItemMinecart || stack.func_77973_b() instanceof IMinecartItem;
            }
            case BALLAST: {
                return BallastRegistry.isItemBallast(stack);
            }
            case FEED: {
                return stack.func_77973_b() instanceof ItemFood || stack.field_77993_c == Item.field_77685_T.field_77779_bT || stack.func_77973_b() instanceof ItemSeeds;
            }
        }
        return false;
    }
}

