/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.inventory.manipulators;

import buildcraft.api.inventory.ISelectiveInventory;
import buildcraft.api.inventory.ISpecialInventory;
import java.util.Iterator;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.InventoryCopy;
import mods.railcraft.common.util.inventory.manipulators.SelectiveManipulator;
import mods.railcraft.common.util.inventory.manipulators.SpecialManipulator;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventoryManipulator {
    private final IInventory inv;

    public static InventoryManipulator get(IInventory inv) {
        if (inv instanceof ISelectiveInventory) {
            return new SelectiveManipulator((ISelectiveInventory)inv);
        }
        if (inv instanceof ISpecialInventory) {
            return new SpecialManipulator((ISpecialInventory)inv);
        }
        return new InventoryManipulator(inv);
    }

    protected InventoryManipulator(IInventory inv) {
        this.inv = inv;
    }

    protected Iterator getSlots() {
        return new Iterator(){
            private int current;

            @Override
            public boolean hasNext() {
                return this.current < InventoryManipulator.this.inv.func_70302_i_();
            }

            public Integer next() {
                int next = this.current++;
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove from this iterator.");
            }
        };
    }

    protected boolean canPutStackInSlot(ItemStack stack, int slot) {
        return this.inv.func_94041_b(slot, stack);
    }

    protected boolean canRemoveStackFromSlot(ItemStack stack, int slot) {
        return true;
    }

    public boolean canAddStack(ItemStack stack) {
        return this.tryAddStack(stack) == null;
    }

    public ItemStack tryAddStack(ItemStack stack) {
        InventoryCopy temp = new InventoryCopy(this.inv);
        return InventoryManipulator.get(temp).addStack(stack);
    }

    public ItemStack addStack(ItemStack stack) {
        boolean movedItem;
        if (stack == null || stack.field_77994_a <= 0) {
            return null;
        }
        stack = stack.func_77946_l();
        do {
            ItemStack destStack;
            int slot;
            movedItem = false;
            Iterator it = this.getSlots();
            while (it.hasNext()) {
                int maxStack;
                int room;
                slot = (Integer)it.next();
                if (!this.canPutStackInSlot(stack, slot) || (destStack = this.inv.func_70301_a(slot)) == null || !InvTools.isItemEqual(destStack, stack) || (room = (maxStack = Math.min((destStack = destStack.func_77946_l()).func_77976_d(), this.inv.func_70297_j_())) - destStack.field_77994_a) <= 0) continue;
                int move = Math.min(room, stack.field_77994_a);
                destStack.field_77994_a += move;
                stack.field_77994_a -= move;
                this.inv.func_70299_a(slot, destStack);
                if (stack.field_77994_a <= 0) {
                    return null;
                }
                movedItem = true;
            }
            if (movedItem) continue;
            it = this.getSlots();
            while (it.hasNext()) {
                slot = (Integer)it.next();
                if (!this.canPutStackInSlot(stack, slot) || (destStack = this.inv.func_70301_a(slot)) != null) continue;
                if (stack.field_77994_a <= this.inv.func_70297_j_()) {
                    this.inv.func_70299_a(slot, stack);
                    return null;
                }
                this.inv.func_70299_a(slot, stack.func_77979_a(this.inv.func_70297_j_()));
                movedItem = true;
            }
        } while (movedItem);
        return stack;
    }

    public boolean canRemoveStack(IStackFilter filter) {
        return this.tryRemoveStack(filter) == null;
    }

    public ItemStack tryRemoveStack(IStackFilter filter) {
        Iterator it = this.getSlots();
        while (it.hasNext()) {
            int slot = (Integer)it.next();
            ItemStack stack = this.inv.func_70301_a(slot);
            if (stack == null || !this.canRemoveStackFromSlot(stack, slot) || !filter.matches(stack)) continue;
            ItemStack output = stack.func_77946_l();
            output.field_77994_a = 1;
            return output;
        }
        return null;
    }

    public ItemStack removeStack(IStackFilter filter) {
        Iterator it = this.getSlots();
        while (it.hasNext()) {
            int slot = (Integer)it.next();
            ItemStack stack = this.inv.func_70301_a(slot);
            if (stack == null || !this.canRemoveStackFromSlot(stack, slot) || !filter.matches(stack)) continue;
            return this.inv.func_70298_a(slot, 1);
        }
        return null;
    }
}

