/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import cpw.mods.fml.common.network.PacketDispatcher;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import mods.railcraft.common.util.network.RailcraftPacket;
import net.minecraft.entity.Entity;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class PacketGuiReturn
extends RailcraftPacket {
    private IGuiReturnHandler obj;

    public PacketGuiReturn() {
    }

    public PacketGuiReturn(IGuiReturnHandler obj) {
        this.obj = obj;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.obj.getWorld().field_73011_w.field_76574_g);
        if (this.obj instanceof TileEntity) {
            TileEntity tile = (TileEntity)this.obj;
            data.writeBoolean(true);
            data.writeInt(tile.field_70329_l);
            data.writeInt(tile.field_70330_m);
            data.writeInt(tile.field_70327_n);
        } else if (this.obj instanceof Entity) {
            Entity entity = (Entity)this.obj;
            data.writeBoolean(false);
            data.writeInt(entity.field_70157_k);
        } else {
            return;
        }
        this.obj.writeGuiData(data);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        int dim = data.readInt();
        WorldServer world = DimensionManager.getWorld((int)dim);
        boolean tileReturn = data.readBoolean();
        if (tileReturn) {
            int z;
            int y;
            int x = data.readInt();
            TileEntity t = world.func_72796_p(x, y = data.readInt(), z = data.readInt());
            if (t instanceof IGuiReturnHandler) {
                ((IGuiReturnHandler)t).readGuiData(data);
            }
        } else {
            int entityId = data.readInt();
            Entity entity = world.func_73045_a(entityId);
            if (entity instanceof IGuiReturnHandler) {
                ((IGuiReturnHandler)entity).readGuiData(data);
            }
        }
    }

    public void sendPacket() {
        PacketDispatcher.sendPacketToServer((Packet)this.getPacket());
    }

    @Override
    public int getID() {
        return RailcraftPacket.PacketType.GUI_RETURN.ordinal();
    }
}

