/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.api;

import java.util.ArrayList;
import java.util.List;
import uristqwerty.CraftGuide.api.ItemFilter;
import uristqwerty.CraftGuide.api.NamedTexture;
import uristqwerty.CraftGuide.api.Renderer;
import uristqwerty.CraftGuide.api.Slot;
import uristqwerty.CraftGuide.api.SlotType;
import uristqwerty.CraftGuide.api.Util;

public class EUSlot
implements Slot {
    public static final int VALUE_UNSPECIFIED = Integer.MIN_VALUE;
    private int constantValue = Integer.MIN_VALUE;
    private int constantSize = Integer.MIN_VALUE;
    private final int x;
    private final int y;
    private static final int width = 16;
    private static final int height = 16;
    private static NamedTexture image;

    public EUSlot(int x, int y) {
        this.x = x;
        this.y = y;
        if (image == null) {
            image = Util.instance.getTexture("EU-icon");
        }
    }

    @Override
    public void draw(Renderer renderer, int recipeX, int recipeY, Object[] data, int dataIndex, boolean isMouseOver) {
        renderer.renderRect(recipeX + this.x, recipeY + this.y, 16, 16, image);
    }

    @Override
    public ItemFilter getClickedFilter(int x, int y, Object[] data, int dataIndex) {
        return null;
    }

    @Override
    public boolean isPointInBounds(int x, int y, Object[] data, int dataIndex) {
        return x >= this.x && x < this.x + 16 && y >= this.y && y < this.y + 16;
    }

    @Override
    public List getTooltip(int x, int y, Object[] data, int dataIndex) {
        int value = this.EUVaue(data[dataIndex]);
        int size = this.PacketSize(data[dataIndex]);
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add("\u00a7fIC2 energy");
        if (value != -1) {
            tooltip.add("\u00a77  " + Math.abs(value) + " EU " + (value > 0 ? "produced" : "used"));
        }
        if (size != -1) {
            tooltip.add("\u00a77  " + size + " EU/t");
        }
        return tooltip;
    }

    @Override
    public boolean matches(ItemFilter filter, Object[] data, int dataIndex, SlotType type) {
        return false;
    }

    public int EUVaue(Object data) {
        if (data instanceof Object[] && ((Object[])data)[0] instanceof Integer) {
            return (Integer)((Object[])data)[0];
        }
        if (this.constantValue != Integer.MIN_VALUE) {
            return this.constantValue;
        }
        if (data instanceof Integer) {
            return (Integer)data;
        }
        return Integer.MIN_VALUE;
    }

    public int PacketSize(Object data) {
        if (data instanceof Object[] && ((Object[])data)[1] instanceof Integer) {
            return (Integer)((Object[])data)[1];
        }
        if (this.constantSize != Integer.MIN_VALUE) {
            return this.constantSize;
        }
        if (data instanceof Integer) {
            return (Integer)data;
        }
        return Integer.MIN_VALUE;
    }

    public EUSlot setConstantEUValue(int value) {
        this.constantValue = value;
        return this;
    }

    public EUSlot setConstantPacketSize(int size) {
        this.constantSize = size;
        return this;
    }
}

