/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.api;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.List;
import net.minecraft.client.renderer.RenderEngine;
import net.minecraft.item.Item;
import net.minecraft.util.Icon;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;
import uristqwerty.CraftGuide.api.ItemFilter;
import uristqwerty.CraftGuide.api.LiquidFilter;
import uristqwerty.CraftGuide.api.NamedTexture;
import uristqwerty.CraftGuide.api.Renderer;
import uristqwerty.CraftGuide.api.Slot;
import uristqwerty.CraftGuide.api.SlotType;
import uristqwerty.CraftGuide.api.Util;

public class LiquidSlot
implements Slot {
    private int x;
    private int y;
    private int width = 16;
    private int height = 16;
    private SlotType slotType = SlotType.INPUT_SLOT;
    private static NamedTexture containerTexture = null;

    public LiquidSlot(int x, int y) {
        this.x = x;
        this.y = y;
        if (containerTexture == null) {
            containerTexture = Util.instance.getTexture("liquidFilterContainer");
        }
    }

    @Override
    public void draw(Renderer renderer, int recipeX, int recipeY, Object[] data, int dataIndex, boolean isMouseOver) {
        int x = recipeX + this.x;
        int y = recipeY + this.y;
        if (data[dataIndex] instanceof LiquidStack) {
            LiquidStack liquid = (LiquidStack)data[dataIndex];
            RenderEngine renderEngine = FMLClientHandler.instance().getClient().field_71446_o;
            if (Item.field_77698_e[liquid.itemID] != null) {
                Item item = Item.field_77698_e[liquid.itemID];
                Icon icon = liquid.getRenderingIcon();
                if (item.func_94901_k() == 0) {
                    renderEngine.func_98187_b("/terrain.png");
                } else {
                    renderEngine.func_98187_b("/gui/items.png");
                }
                double u = icon.func_94214_a(3.0);
                double u2 = icon.func_94214_a(13.0);
                double v = icon.func_94207_b(1.0);
                double v2 = icon.func_94207_b(15.0);
                GL11.glEnable((int)3553);
                GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
                GL11.glBegin((int)7);
                GL11.glTexCoord2d((double)u, (double)v);
                GL11.glVertex2i((int)(x + 3), (int)(y + 1));
                GL11.glTexCoord2d((double)u, (double)v2);
                GL11.glVertex2i((int)(x + 3), (int)(y + 15));
                GL11.glTexCoord2d((double)u2, (double)v2);
                GL11.glVertex2i((int)(x + 13), (int)(y + 15));
                GL11.glTexCoord2d((double)u2, (double)v);
                GL11.glVertex2i((int)(x + 13), (int)(y + 1));
                GL11.glEnd();
            }
        }
        renderer.renderRect(x - 1, y - 1, 18, 18, containerTexture);
    }

    @Override
    public ItemFilter getClickedFilter(int x, int y, Object[] data, int dataIndex) {
        if (data[dataIndex] instanceof LiquidStack) {
            return new LiquidFilter((LiquidStack)data[dataIndex]);
        }
        return null;
    }

    @Override
    public boolean isPointInBounds(int x, int y, Object[] data, int dataIndex) {
        return x >= this.x && x < this.x + this.width && y >= this.y && y < this.y + this.height;
    }

    @Override
    public List getTooltip(int x, int y, Object[] data, int dataIndex) {
        List tooltip = null;
        if (data[dataIndex] instanceof LiquidStack) {
            LiquidStack stack = (LiquidStack)data[dataIndex];
            tooltip = Util.instance.getItemStackText(stack.asItemStack());
            tooltip.set(0, (String)tooltip.get(0) + " (" + stack.amount + " milliBuckets)");
        }
        return tooltip;
    }

    @Override
    public boolean matches(ItemFilter filter, Object[] data, int dataIndex, SlotType type) {
        if (!(data[dataIndex] instanceof LiquidStack) || type != this.slotType && (type != SlotType.ANY_SLOT || this.slotType == SlotType.DISPLAY_SLOT || this.slotType == SlotType.HIDDEN_SLOT)) {
            return false;
        }
        LiquidStack stack = (LiquidStack)data[dataIndex];
        if (filter.matches(stack)) {
            return true;
        }
        for (LiquidContainerData liquidData : LiquidContainerRegistry.getRegisteredLiquidContainerData()) {
            if (!stack.isLiquidEqual(liquidData.stillLiquid) || !filter.matches(liquidData.filled)) continue;
            return true;
        }
        return filter.matches(stack.asItemStack());
    }

    public Slot setSlotType(SlotType type) {
        this.slotType = type;
        return this;
    }
}

