/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import cpw.mods.fml.common.network.PacketDispatcher;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.client.gui.GuiBasic;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.buttons.GuiToggleButton;
import mods.railcraft.common.blocks.signals.IAspectActionManager;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import mods.railcraft.common.util.network.PacketGuiReturn;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.network.packet.Packet;

public class GuiAspectAction
extends GuiBasic {
    private final IAspectActionManager tile;
    private final String action;
    private boolean[] aspects = new boolean[SignalAspect.values().length];

    public GuiAspectAction(String action, IAspectActionManager t) {
        super(t.func_70303_b());
        this.tile = t;
        this.action = action;
        for (SignalAspect aspect : SignalAspect.values()) {
            this.aspects[aspect.ordinal()] = this.tile.doesActionOnAspect(aspect);
        }
    }

    public void func_73866_w_() {
        if (this.tile == null) {
            return;
        }
        this.field_73887_h.clear();
        int w = (this.field_73880_f - this.xSize) / 2;
        int h = (this.field_73881_g - this.ySize) / 2;
        this.field_73887_h.add(new GuiToggleButton(0, w + 7, h + 35, 50, 20, "Green", this.aspects[SignalAspect.GREEN.ordinal()]));
        this.field_73887_h.add(new GuiToggleButton(1, w + 12, h + 60, 70, 20, "Blink Yellow", this.aspects[SignalAspect.BLINK_YELLOW.ordinal()]));
        this.field_73887_h.add(new GuiToggleButton(2, w + 63, h + 35, 50, 20, "Yellow", this.aspects[SignalAspect.YELLOW.ordinal()]));
        this.field_73887_h.add(new GuiToggleButton(3, w + 94, h + 60, 70, 20, "Blink Red", this.aspects[SignalAspect.BLINK_RED.ordinal()]));
        this.field_73887_h.add(new GuiToggleButton(4, w + 119, h + 35, 50, 20, "Red", this.aspects[SignalAspect.RED.ordinal()]));
    }

    @Override
    protected void drawExtras(int x, int y, float f) {
        GuiTools.drawCenteredString(this.field_73886_k, this.action, 20);
    }

    protected void func_73875_a(GuiButton button) {
        if (this.tile == null) {
            return;
        }
        SignalAspect aspect = SignalAspect.values()[button.field_73741_f];
        this.aspects[aspect.ordinal()] = !this.aspects[aspect.ordinal()];
        ((GuiToggleButton)button).active = this.aspects[aspect.ordinal()];
    }

    public void func_73874_b() {
        if (Game.isNotHost(this.tile.getWorld()) && this.tile instanceof IGuiReturnHandler) {
            for (SignalAspect aspect : SignalAspect.values()) {
                this.tile.doActionOnAspect(aspect, this.aspects[aspect.ordinal()]);
            }
            PacketGuiReturn pkt = new PacketGuiReturn((IGuiReturnHandler)((Object)this.tile));
            PacketDispatcher.sendPacketToServer((Packet)pkt.getPacket());
        }
    }
}

