/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import cpw.mods.fml.common.network.PacketDispatcher;
import mods.railcraft.client.gui.TileGui;
import mods.railcraft.client.gui.buttons.GuiToggleButtonSmall;
import mods.railcraft.common.blocks.machine.gamma.TileLiquidLoader;
import mods.railcraft.common.gui.containers.ContainerLiquidLoader;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketGuiReturn;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.network.packet.Packet;

public class GuiLoaderLiquid
extends TileGui {
    private static final String FILTER_LABEL = RailcraftLanguage.translate("gui.filters");
    private final TileLiquidLoader tile;
    private GuiToggleButtonSmall empty;
    private GuiToggleButtonSmall full;

    public GuiLoaderLiquid(InventoryPlayer inv, TileLiquidLoader tile) {
        super(tile, new ContainerLiquidLoader(inv, tile), "/mods/railcraft/textures/gui/gui_liquid_loader.png");
        this.tile = tile;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.tile == null) {
            return;
        }
        this.field_73887_h.clear();
        int w = (this.field_73880_f - this.field_74194_b) / 2;
        int h = (this.field_73881_g - this.field_74195_c) / 2;
        this.empty = new GuiToggleButtonSmall(0, w + 40, h + 45, 65, RailcraftLanguage.translate("gui.liquid.loader.empty"), this.tile.waitIfEmpty());
        this.field_73887_h.add(this.empty);
        this.full = new GuiToggleButtonSmall(1, w + 40, h + 62, 65, RailcraftLanguage.translate("gui.liquid.loader.fill"), this.tile.waitTillFull());
        this.field_73887_h.add(this.full);
    }

    protected void func_74189_g(int mouseX, int mouseY) {
        int sWidth = this.field_73886_k.func_78256_a(this.tile.func_70303_b());
        int sPos = this.field_74194_b / 2 - sWidth / 2;
        this.field_73886_k.func_78276_b(this.tile.func_70303_b(), sPos, 6, 0x404040);
        this.field_73886_k.func_78276_b(FILTER_LABEL, 85, 25, 0x404040);
    }

    protected void func_73875_a(GuiButton guibutton) {
        if (this.tile == null) {
            return;
        }
        if (guibutton.field_73741_f == 0) {
            this.setWaitIfEmpty(!this.tile.waitIfEmpty());
        }
        if (guibutton.field_73741_f == 1) {
            this.setWaitTillFull(!this.tile.waitTillFull());
        }
    }

    private void setWaitIfEmpty(boolean set) {
        this.tile.setWaitIfEmpty(set);
        this.empty.active = set;
        if (!set) {
            this.setWaitTillFull(false);
        }
    }

    private void setWaitTillFull(boolean set) {
        this.tile.setWaitTillFull(set);
        this.full.active = set;
        if (set) {
            this.setWaitIfEmpty(true);
        }
    }

    public void func_73874_b() {
        this.tile.setWaitIfEmpty(this.empty.active);
        this.tile.setWaitTillFull(this.full.active);
        if (Game.isNotHost(this.tile.getWorld())) {
            PacketGuiReturn pkt = new PacketGuiReturn(this.tile);
            PacketDispatcher.sendPacketToServer((Packet)pkt.getPacket());
        }
    }
}

