/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import java.util.ArrayList;
import mods.railcraft.client.gui.EntityGui;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.buttons.GuiToggleButtonSmall;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.carts.EntityLocomotiveSteam;
import mods.railcraft.common.gui.containers.ContainerLocomotiveSteam;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.StatCollector;

public class GuiLocomotiveSteam
extends EntityGui {
    private final EntityLocomotiveSteam loco;
    private GuiToggleButtonSmall running;
    private GuiToggleButtonSmall idle;
    private GuiToggleButtonSmall shutdown;
    private GuiToggleButtonSmall reverse;
    private GuiToggleButtonSmall slowest;
    private GuiToggleButtonSmall slower;
    private GuiToggleButtonSmall slow;
    private GuiToggleButtonSmall max;
    private EntityLocomotive.LocoMode mode;
    private EntityLocomotive.LocoSpeed speed;

    public GuiLocomotiveSteam(InventoryPlayer inv, EntityLocomotiveSteam loco) {
        super((Entity)loco, new ContainerLocomotiveSteam(inv, loco), "/mods/railcraft/textures/gui/gui_locomotive_steam.png");
        this.field_74195_c = 205;
        this.loco = loco;
        this.mode = loco.getMode();
        this.speed = loco.getSpeed();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.loco == null) {
            return;
        }
        this.field_73887_h.clear();
        int w = (this.field_73880_f - this.field_74194_b) / 2;
        int h = (this.field_73881_g - this.field_74195_c) / 2;
        ArrayList<GuiToggleButtonSmall> buttons = new ArrayList<GuiToggleButtonSmall>();
        this.running = new GuiToggleButtonSmall(0, 0, h + 76, 55, RailcraftLanguage.translate("gui.locomotive.mode.running"), this.mode == EntityLocomotive.LocoMode.RUNNING);
        buttons.add(this.running);
        this.idle = new GuiToggleButtonSmall(1, 0, h + 76, 45, RailcraftLanguage.translate("gui.locomotive.mode.idle"), this.mode == EntityLocomotive.LocoMode.IDLE);
        buttons.add(this.idle);
        this.shutdown = new GuiToggleButtonSmall(2, 0, h + 76, 55, RailcraftLanguage.translate("gui.locomotive.mode.shutdown"), this.mode == EntityLocomotive.LocoMode.SHUTDOWN);
        buttons.add(this.shutdown);
        GuiTools.newButtonRowAuto(this.field_73887_h, w + 3, 171, buttons);
        ArrayList<GuiToggleButtonSmall> speedButtons = new ArrayList<GuiToggleButtonSmall>();
        this.reverse = new GuiToggleButtonSmall(3, 0, h + 93, 12, "<", this.speed == EntityLocomotive.LocoSpeed.REVERSE);
        speedButtons.add(this.reverse);
        this.slowest = new GuiToggleButtonSmall(4, 0, h + 93, 12, ">", this.speed == EntityLocomotive.LocoSpeed.SLOWEST);
        speedButtons.add(this.slowest);
        this.slower = new GuiToggleButtonSmall(5, 0, h + 93, 17, ">>", this.speed == EntityLocomotive.LocoSpeed.SLOWER);
        speedButtons.add(this.slower);
        this.slow = new GuiToggleButtonSmall(6, 0, h + 93, 22, ">>>", this.speed == EntityLocomotive.LocoSpeed.SLOW);
        speedButtons.add(this.slow);
        this.max = new GuiToggleButtonSmall(7, 0, h + 93, 27, ">>>>", this.speed == EntityLocomotive.LocoSpeed.MAX);
        speedButtons.add(this.max);
        GuiTools.newButtonRow(this.field_73887_h, w + 35, 4, speedButtons);
    }

    protected void func_73875_a(GuiButton guibutton) {
        if (this.loco == null) {
            return;
        }
        switch (guibutton.field_73741_f) {
            case 0: {
                this.mode = EntityLocomotive.LocoMode.RUNNING;
                break;
            }
            case 1: {
                this.mode = EntityLocomotive.LocoMode.IDLE;
                break;
            }
            case 2: {
                this.mode = EntityLocomotive.LocoMode.SHUTDOWN;
                break;
            }
            case 3: {
                this.speed = EntityLocomotive.LocoSpeed.REVERSE;
                break;
            }
            case 4: {
                this.speed = EntityLocomotive.LocoSpeed.SLOWEST;
                break;
            }
            case 5: {
                this.speed = EntityLocomotive.LocoSpeed.SLOWER;
                break;
            }
            case 6: {
                this.speed = EntityLocomotive.LocoSpeed.SLOW;
                break;
            }
            case 7: {
                this.speed = EntityLocomotive.LocoSpeed.MAX;
            }
        }
        this.updateButtons();
        this.sendUpdatePacket();
    }

    private void updateButtons() {
        this.running.active = this.mode == EntityLocomotive.LocoMode.RUNNING;
        this.idle.active = this.mode == EntityLocomotive.LocoMode.IDLE;
        this.shutdown.active = this.mode == EntityLocomotive.LocoMode.SHUTDOWN;
        this.reverse.active = this.speed == EntityLocomotive.LocoSpeed.REVERSE;
        this.slowest.active = this.speed == EntityLocomotive.LocoSpeed.SLOWEST;
        this.slower.active = this.speed == EntityLocomotive.LocoSpeed.SLOWER;
        this.slow.active = this.speed == EntityLocomotive.LocoSpeed.SLOW;
        this.max.active = this.speed == EntityLocomotive.LocoSpeed.MAX;
    }

    public void func_73874_b() {
        this.sendUpdatePacket();
    }

    private void sendUpdatePacket() {
        this.loco.clientMode = this.mode;
        this.loco.clientSpeed = this.speed;
        PacketBuilder.getInstance().sendGuiReturnPacket(this.loco);
    }

    protected void func_74189_g(int mouseX, int mouseY) {
        GuiTools.drawCenteredString(this.field_73886_k, this.loco.func_70303_b(), 6);
        this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8, this.field_74195_c - 96 + 2, 0x404040);
    }

    @Override
    protected void func_74185_a(float par1, int par2, int par3) {
        super.func_74185_a(par1, par3, par3);
        int x = (this.field_73880_f - this.field_74194_b) / 2;
        int y = (this.field_73881_g - this.field_74195_c) / 2;
        if (this.loco.burnTime > 0.0f) {
            int scale = this.loco.getBurnProgressScaled(12);
            this.func_73729_b(x + 62, y + 34 - scale, 176, 59 - scale, 14, scale + 2);
        }
    }
}

