/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.buttons.GuiBetterButton;
import mods.railcraft.client.gui.buttons.GuiButtonRoutingTableNextPage;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.util.network.PacketCurrentItemNBT;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiRoutingTable
extends GuiScreen {
    public static final String TEXTURE = "/mods/railcraft/textures/gui/routing_table.png";
    public static final int WRAP_WIDTH = 226;
    private final EntityPlayer editingPlayer;
    private final ItemStack bookStack;
    private final boolean editable = true;
    private boolean bookModified;
    private boolean editingTitle;
    private boolean readingManual;
    private int updateCount;
    private int bookImageWidth = 256;
    private int bookImageHeight = 192;
    private int bookTotalPages = 1;
    private int currPage;
    private int currLine;
    private NBTTagList bookPages;
    private String bookTitle = "";
    private GuiButtonRoutingTableNextPage buttonNextPage;
    private GuiButtonRoutingTableNextPage buttonPreviousPage;
    private GuiBetterButton buttonDone;
    private GuiBetterButton buttonSign;
    private GuiBetterButton buttonHelp;

    public GuiRoutingTable(EntityPlayer player, ItemStack stack) {
        this.editingPlayer = player;
        this.bookStack = stack;
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            this.bookPages = nbt.func_74761_m("pages");
            if (this.bookPages != null) {
                this.bookPages = (NBTTagList)this.bookPages.func_74737_b();
                this.bookTotalPages = this.bookPages.func_74745_c();
                if (this.bookTotalPages < 1) {
                    this.bookTotalPages = 1;
                }
            }
            this.bookTitle = nbt.func_74779_i("title");
        }
        if (this.bookPages == null) {
            this.bookPages = new NBTTagList("pages");
            NBTTagList page = new NBTTagList("0");
            this.bookPages.func_74742_a((NBTBase)page);
            NBTTagString line = new NBTTagString("0", "");
            page.func_74742_a((NBTBase)line);
            this.bookTotalPages = 1;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        ++this.updateCount;
    }

    public void func_73866_w_() {
        this.field_73887_h.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        ArrayList<GuiBetterButton> buttons = new ArrayList<GuiBetterButton>();
        this.buttonSign = new GuiBetterButton(3, 0, 4 + this.bookImageHeight, 65, 20, RailcraftLanguage.translate("gui.routing.table.name"));
        buttons.add(this.buttonSign);
        this.buttonHelp = new GuiBetterButton(4, 0, 4 + this.bookImageHeight, 65, 20, RailcraftLanguage.translate("gui.help"));
        buttons.add(this.buttonHelp);
        this.buttonDone = new GuiBetterButton(0, 0, 4 + this.bookImageHeight, 65, 20, StatCollector.func_74838_a((String)"gui.done"));
        buttons.add(this.buttonDone);
        GuiTools.newButtonRowAuto(this.field_73887_h, this.field_73880_f / 2 - 100, 200, buttons);
        int xOffset = (this.field_73880_f - this.bookImageWidth) / 2;
        int yOffset = 2;
        this.buttonNextPage = new GuiButtonRoutingTableNextPage(1, xOffset + 180, yOffset + 154, true);
        this.field_73887_h.add(this.buttonNextPage);
        this.buttonPreviousPage = new GuiButtonRoutingTableNextPage(2, xOffset + 38, yOffset + 154, false);
        this.field_73887_h.add(this.buttonPreviousPage);
        this.updateButtons();
    }

    public void func_73874_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private void updateButtons() {
        boolean bl;
        if (!this.editingTitle && !this.readingManual) {
            if (this.currPage >= this.bookTotalPages - 1) {
                // empty if block
            }
            bl = true;
        } else {
            bl = false;
        }
        this.buttonNextPage.field_73748_h = bl;
        this.buttonPreviousPage.field_73748_h = !this.editingTitle && !this.readingManual && this.currPage > 0;
        this.buttonHelp.field_73744_e = this.readingManual ? StatCollector.func_74838_a((String)"gui.back") : RailcraftLanguage.translate("gui.help");
        this.buttonSign.field_73744_e = this.editingTitle ? StatCollector.func_74838_a((String)"gui.back") : RailcraftLanguage.translate("gui.routing.table.name");
    }

    private void sendBookToServer() {
        ((Object)((Object)this)).getClass();
        if (this.bookModified && this.bookPages != null) {
            for (int pageNum = this.bookPages.func_74745_c() - 1; pageNum >= 0; --pageNum) {
                NBTTagList page = (NBTTagList)this.bookPages.func_74743_b(pageNum);
                if (page == null) continue;
                for (int lineNum = page.func_74745_c() - 1; lineNum >= 0; --lineNum) {
                    NBTTagString line = (NBTTagString)page.func_74743_b(lineNum);
                    if (line == null || line.field_74751_a != null && !line.field_74751_a.equals("")) continue;
                    page.func_74744_a(lineNum);
                }
                if (page.func_74745_c() > 0) continue;
                this.bookPages.func_74744_a(pageNum);
            }
            NBTTagCompound nbt = this.bookStack.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound("tag");
                this.bookStack.func_77982_d(nbt);
            }
            nbt.func_74782_a("pages", (NBTBase)this.bookPages);
            nbt.func_74778_a("author", this.editingPlayer.field_71092_bJ);
            if (!this.bookTitle.equals("")) {
                nbt.func_74778_a("title", this.bookTitle);
            }
            PacketCurrentItemNBT pkt = new PacketCurrentItemNBT(this.bookStack);
            PacketDispatcher.sendPacketToServer((Packet)pkt.getPacket());
        }
    }

    protected void func_73875_a(GuiButton button) {
        if (button.field_73742_g) {
            if (button == this.buttonDone) {
                this.field_73882_e.func_71373_a((GuiScreen)null);
                this.sendBookToServer();
            } else if (button == this.buttonSign) {
                this.editingTitle = !this.editingTitle;
                this.readingManual = false;
            } else if (button == this.buttonHelp) {
                this.readingManual = !this.readingManual;
                this.editingTitle = false;
            } else if (button == this.buttonNextPage) {
                if (this.currPage < this.bookTotalPages - 1) {
                    ++this.currPage;
                } else {
                    ((Object)((Object)this)).getClass();
                    this.addNewPage();
                    if (this.currPage < this.bookTotalPages - 1) {
                        ++this.currPage;
                    }
                }
            } else if (button == this.buttonPreviousPage && this.currPage > 0) {
                --this.currPage;
            }
            this.updateButtons();
        }
    }

    private void addNewPage() {
        if (this.bookPages != null && this.bookPages.func_74745_c() < 50) {
            this.bookPages.func_74742_a((NBTBase)new NBTTagList("" + this.bookPages.func_74745_c()));
            this.addNewLine();
            ++this.bookTotalPages;
            this.bookModified = true;
        }
    }

    private void addNewLine() {
        NBTTagList page = this.getPage(this.currPage);
        if (page != null && page.func_74745_c() < 13) {
            page.func_74742_a((NBTBase)new NBTTagString("" + page.func_74745_c(), ""));
            this.bookModified = true;
        }
    }

    protected void func_73869_a(char c, int key) {
        super.func_73869_a(c, key);
        ((Object)((Object)this)).getClass();
        if (this.editingTitle) {
            this.keyTypedInTitle(c, key);
        } else {
            this.keyTypedInBook(c, key);
        }
    }

    private void keyTypedInBook(char c, int key) {
        switch (c) {
            case '\u0016': {
                this.addToBook(GuiScreen.func_73870_l());
                return;
            }
        }
        switch (key) {
            case 14: {
                String text = this.getLine(this.currLine);
                if (text.length() > 0) {
                    this.setLine(this.currPage, this.currLine, text.substring(0, text.length() - 1));
                }
                return;
            }
            case 28: 
            case 208: {
                NBTTagList page = this.getPage(this.currPage);
                if (page == null) {
                    return;
                }
                if (this.currLine < page.func_74745_c() - 1) {
                    ++this.currLine;
                } else {
                    ((Object)((Object)this)).getClass();
                    this.addNewLine();
                    if (this.currLine < page.func_74745_c() - 1) {
                        ++this.currLine;
                    }
                }
                return;
            }
            case 200: {
                if (this.currLine > 0) {
                    --this.currLine;
                }
                return;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)c)) {
            this.addToBook(Character.toString(c));
        }
    }

    private void keyTypedInTitle(char c, int key) {
        switch (key) {
            case 14: {
                if (this.bookTitle.length() > 0) {
                    this.bookTitle = this.bookTitle.substring(0, this.bookTitle.length() - 1);
                    this.updateButtons();
                }
                return;
            }
            case 28: {
                if (this.bookTitle.length() > 0) {
                    this.sendBookToServer();
                    this.field_73882_e.func_71373_a((GuiScreen)null);
                }
                return;
            }
        }
        if (this.bookTitle.length() < 16 && ChatAllowedCharacters.func_71566_a((char)c)) {
            this.bookTitle = this.bookTitle + Character.toString(c);
            this.updateButtons();
            this.bookModified = true;
        }
    }

    private NBTTagList getPage(int page) {
        if (this.bookPages != null && page >= 0 && page < this.bookPages.func_74745_c()) {
            return (NBTTagList)this.bookPages.func_74743_b(page);
        }
        return null;
    }

    private String getLine(int line) {
        NBTTagList page = this.getPage(this.currPage);
        if (page != null && line >= 0 && line < page.func_74745_c()) {
            return ((NBTTagString)page.func_74743_b(line)).toString();
        }
        return "";
    }

    private void setLine(int pageNum, int lineNum, String string) {
        if (this.bookPages != null && pageNum >= 0 && pageNum < this.bookPages.func_74745_c()) {
            NBTTagList page = (NBTTagList)this.bookPages.func_74743_b(pageNum);
            NBTTagString line = (NBTTagString)page.func_74743_b(lineNum);
            line.field_74751_a = string;
            this.bookModified = true;
        }
    }

    private void addToBook(String string) {
        String currentText = this.getLine(this.currLine);
        String newText = currentText + string;
        if (newText.length() < 37) {
            this.setLine(this.currPage, this.currLine, newText);
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b(TEXTURE);
        int xOffset = (this.field_73880_f - this.bookImageWidth) / 2;
        int yOffset = 2;
        this.func_73729_b(xOffset, yOffset, 0, 0, this.bookImageWidth, this.bookImageHeight);
        if (this.editingTitle) {
            String title = this.bookTitle;
            ((Object)((Object)this)).getClass();
            title = this.updateCount / 6 % 2 == 0 ? title + "" + EnumChatFormatting.BLACK + "_" : title + "" + EnumChatFormatting.GRAY + "_";
            String s1 = StatCollector.func_74838_a((String)"book.editTitle");
            int l = this.field_73886_k.func_78256_a(s1);
            this.field_73886_k.func_78276_b(s1, xOffset + 36 + (116 - l) / 2, yOffset + 16 + 16, 0);
            int i1 = this.field_73886_k.func_78256_a(title);
            this.field_73886_k.func_78276_b(title, xOffset + 36 + (116 - i1) / 2, yOffset + 48, 0);
            String s2 = String.format(StatCollector.func_74838_a((String)"book.byAuthor"), this.editingPlayer.field_71092_bJ);
            int j1 = this.field_73886_k.func_78256_a(s2);
            this.field_73886_k.func_78276_b(EnumChatFormatting.DARK_GRAY + s2, xOffset + 36 + (116 - j1) / 2, yOffset + 48 + 10, 0);
        } else if (this.readingManual) {
            GuiTools.drawCenteredString(this.field_73886_k, RailcraftLanguage.translate("gui.routing.table.manual.title"), yOffset + 16, this.field_73880_f);
            String text = RailcraftLanguage.translate("gui.routing.table.manual");
            this.field_73886_k.func_78279_b(text, xOffset + 16, yOffset + 16 + 16, 226, 0);
        } else {
            String pageNumString = String.format(StatCollector.func_74838_a((String)"book.pageIndicator"), this.currPage + 1, this.bookTotalPages);
            int pageNumStringWidth = this.field_73886_k.func_78256_a(pageNumString);
            this.field_73886_k.func_78276_b(pageNumString, xOffset - pageNumStringWidth + this.bookImageWidth - 44, yOffset + 16, 0);
            String text = "";
            if (this.bookPages == null || this.currPage < 0 || this.currPage >= this.bookPages.func_74745_c()) {
                return;
            }
            NBTTagList page = (NBTTagList)this.bookPages.func_74743_b(this.currPage);
            for (int lineNum = 0; lineNum < page.func_74745_c(); ++lineNum) {
                NBTTagString line = (NBTTagString)page.func_74743_b(lineNum);
                text = text + EnumChatFormatting.BLACK + line.toString();
                if (lineNum == this.currLine) {
                    text = this.field_73886_k.func_78260_a() ? text + "_" : (this.updateCount / 6 % 2 == 0 ? text + "" + EnumChatFormatting.BLACK + "_" : text + "" + EnumChatFormatting.GRAY + "_");
                }
                text = text + "\n";
            }
            this.field_73886_k.func_78279_b(text, xOffset + 16, yOffset + 16 + 16, 226, 0);
        }
        super.func_73863_a(par1, par2, par3);
    }
}

