/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.client.render.ICombinedRenderer;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.signals.BlockSignal;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.ItemSignal;
import mods.railcraft.common.blocks.signals.TileBoxBase;
import mods.railcraft.common.util.misc.FakeBlockRenderInfo;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;

public class RenderSignalBox
implements ICombinedRenderer {
    private FakeBlockRenderInfo info = new FakeBlockRenderInfo();

    public RenderSignalBox() {
        this.info.texture = new Icon[6];
        this.info.template = RailcraftBlocks.getBlockSignal();
    }

    @Override
    public void renderBlock(RenderBlocks renderblocks, IBlockAccess iBlockAccess, int x, int y, int z, Block block) {
        float maxZNS;
        Icon lamp;
        TileBoxBase tile = (TileBoxBase)iBlockAccess.func_72796_p(x, y, z);
        EnumSignal structure = tile.getSignalType();
        float pix = 0.0625f;
        this.info.texture[0] = BlockSignal.texturesBox[2];
        this.info.texture[1] = structure.getIcon();
        this.info.texture[2] = BlockSignal.texturesBox[0];
        this.info.texture[3] = BlockSignal.texturesBox[0];
        this.info.texture[4] = BlockSignal.texturesBox[0];
        this.info.texture[5] = BlockSignal.texturesBox[0];
        boolean eastWest = false;
        boolean northSouth = false;
        if (tile.connectToBoxAt(x - 1, y, z, 5) || tile.connectToBoxAt(x + 1, y, z, 4)) {
            eastWest = true;
        }
        if (tile.connectToBoxAt(x, y, z - 1, 3) || tile.connectToBoxAt(x, y, z + 1, 2)) {
            northSouth = true;
        }
        boolean side2 = tile.connectToBoxAt(x, y, z - 1, 5);
        boolean side3 = tile.connectToBoxAt(x, y, z + 1, 4);
        boolean side4 = tile.connectToBoxAt(x - 1, y, z, 3);
        boolean side5 = tile.connectToBoxAt(x + 1, y, z, 2);
        if (!eastWest && !northSouth) {
            eastWest = true;
        }
        if (side2) {
            this.info.texture[2] = BlockSignal.texturesBox[1];
        }
        if (side3) {
            this.info.texture[3] = BlockSignal.texturesBox[1];
        }
        if (side4) {
            this.info.texture[4] = BlockSignal.texturesBox[1];
        }
        if (side5) {
            this.info.texture[5] = BlockSignal.texturesBox[1];
        }
        this.info.setBlockBounds(2.0f * pix, 0.0f, 2.0f * pix, 14.0f * pix, 15.0f * pix, 14.0f * pix);
        RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        SignalAspect aspect = tile.getBoxSignalAspect();
        if (!aspect.isLit()) {
            aspect = SignalAspect.OFF;
        }
        this.info.texture[2] = lamp = BlockSignal.texturesLampBox[aspect.getTextureIndex()];
        this.info.texture[3] = lamp;
        this.info.texture[4] = lamp;
        this.info.texture[5] = lamp;
        this.info.renderSide[0] = false;
        this.info.renderSide[1] = false;
        this.info.renderSide[2] = !side2;
        this.info.renderSide[3] = !side3;
        this.info.renderSide[4] = !side4;
        this.info.renderSide[5] = !side5;
        this.info.brightness = aspect.getTextureBrightness();
        RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, this.info.brightness < 0, false);
        this.info.brightness = -1;
        this.info.setRenderAllSides();
        if (!iBlockAccess.func_72799_c(x, y + 1, z)) {
            this.info.texture[1] = BlockSignal.texturesBox[3];
            this.info.texture[2] = BlockSignal.texturesBox[0];
            this.info.texture[3] = BlockSignal.texturesBox[0];
            this.info.texture[4] = BlockSignal.texturesBox[0];
            this.info.texture[5] = BlockSignal.texturesBox[0];
            this.info.setBlockBounds(5.0f * pix, 15.0f * pix, 5.0f * pix, 11.0f * pix, 16.0f * pix, 11.0f * pix);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        }
        this.info.texture[0] = BlockSignal.texturesBox[4];
        this.info.texture[1] = BlockSignal.texturesBox[4];
        this.info.texture[2] = BlockSignal.texturesBox[5];
        this.info.texture[3] = BlockSignal.texturesBox[5];
        this.info.texture[4] = BlockSignal.texturesBox[5];
        this.info.texture[5] = BlockSignal.texturesBox[5];
        float min = 7.0f * pix;
        float max = 9.0f * pix;
        float minY = 10.0f * pix;
        float maxY = 12.0f * pix;
        float minXEW = side4 ? 0.0f : min;
        float maxXEW = side5 ? 1.0f : max;
        float minZNS = side2 ? 0.0f : min;
        float f = maxZNS = side3 ? 1.0f : max;
        if (eastWest) {
            this.info.setBlockBounds(minXEW, minY, min, maxXEW, maxY, max);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        }
        if (northSouth) {
            this.info.setBlockBounds(min, minY, minZNS, max, maxY, maxZNS);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        }
        minY = 5.0f * pix;
        maxY = 7.0f * pix;
        if (eastWest) {
            this.info.setBlockBounds(minXEW, minY, min, maxXEW, maxY, max);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        }
        if (northSouth) {
            this.info.setBlockBounds(min, minY, minZNS, max, maxY, maxZNS);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        }
    }

    @Override
    public void renderItem(RenderBlocks renderblocks, ItemStack item, IItemRenderer.ItemRenderType renderType) {
        if (!(item.func_77973_b() instanceof ItemSignal)) {
            return;
        }
        EnumSignal structure = EnumSignal.fromId(item.func_77960_j());
        float pix = 0.0625f;
        this.info.setBlockBounds(2.0f * pix, 0.0f, 2.0f * pix, 14.0f * pix, 15.0f * pix, 14.0f * pix);
        this.info.texture[0] = BlockSignal.texturesBox[2];
        this.info.texture[1] = structure.getIcon();
        this.info.texture[2] = BlockSignal.texturesBox[0];
        this.info.texture[3] = BlockSignal.texturesBox[0];
        this.info.texture[4] = BlockSignal.texturesBox[0];
        this.info.texture[5] = BlockSignal.texturesBox[0];
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        int texture = SignalAspect.RED.getTextureIndex();
        this.info.renderSide[0] = false;
        this.info.renderSide[1] = false;
        this.info.texture[2] = BlockSignal.texturesLampBox[texture];
        this.info.texture[3] = BlockSignal.texturesLampBox[texture];
        this.info.texture[4] = BlockSignal.texturesLampBox[texture];
        this.info.texture[5] = BlockSignal.texturesLampBox[texture];
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.setRenderAllSides();
    }
}

