/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import java.util.Random;
import mods.railcraft.common.carts.EntityCartTank;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderTankCartItem
implements IItemRenderer {
    RenderItem renderItem = new RenderItem();

    public boolean handleRenderType(ItemStack stack, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.ENTITY || type == IItemRenderer.ItemRenderType.EQUIPPED;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack stack, IItemRenderer.ItemRendererHelper helper) {
        return helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.render(IItemRenderer.ItemRenderType.INVENTORY, stack);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            this.renderAsEntity(stack);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            GL11.glPushMatrix();
            this.renderEquiped(stack, (EntityLiving)data[1]);
            ItemStack filter = EntityCartTank.getFilterFromCartItem(stack);
            if (filter != null) {
                float scale = 0.6f;
                GL11.glScalef((float)scale, (float)scale, (float)1.1f);
                GL11.glTranslatef((float)0.7f, (float)0.0f, (float)0.001f);
                this.renderEquiped(filter, (EntityLiving)data[1]);
            }
            GL11.glPopMatrix();
        }
    }

    private void renderEquiped(ItemStack stack, EntityLiving entity) {
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        int meta = stack.func_77960_j();
        for (int pass = 0; pass < stack.func_77973_b().getRenderPasses(meta); ++pass) {
            Icon texture = stack.func_77973_b().func_77618_c(meta, pass);
            int color = stack.func_77973_b().func_82790_a(stack, pass);
            float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
            float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
            float c3 = (float)(color & 0xFF) / 255.0f;
            if (this.renderItem.field_77024_a) {
                GL11.glColor4f((float)c1, (float)c2, (float)c3, (float)1.0f);
            }
            float uv1 = texture.func_94209_e();
            float uv2 = texture.func_94212_f();
            float uv3 = texture.func_94206_g();
            float uv4 = texture.func_94210_h();
            this.renderItemIn3D(tessellator, uv2, uv3, uv1, uv4);
        }
        GL11.glPopMatrix();
    }

    private void renderItemIn3D(Tessellator par1Tessellator, float par2, float par3, float par4, float par5) {
        float var11;
        float var10;
        float var9;
        int var8;
        float var6 = 1.0f;
        float var7 = 0.0625f;
        par1Tessellator.func_78382_b();
        par1Tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        par1Tessellator.func_78374_a(0.0, 0.0, 0.0, (double)par2, (double)par5);
        par1Tessellator.func_78374_a((double)var6, 0.0, 0.0, (double)par4, (double)par5);
        par1Tessellator.func_78374_a((double)var6, 1.0, 0.0, (double)par4, (double)par3);
        par1Tessellator.func_78374_a(0.0, 1.0, 0.0, (double)par2, (double)par3);
        par1Tessellator.func_78381_a();
        par1Tessellator.func_78382_b();
        par1Tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        par1Tessellator.func_78374_a(0.0, 1.0, (double)(0.0f - var7), (double)par2, (double)par3);
        par1Tessellator.func_78374_a((double)var6, 1.0, (double)(0.0f - var7), (double)par4, (double)par3);
        par1Tessellator.func_78374_a((double)var6, 0.0, (double)(0.0f - var7), (double)par4, (double)par5);
        par1Tessellator.func_78374_a(0.0, 0.0, (double)(0.0f - var7), (double)par2, (double)par5);
        par1Tessellator.func_78381_a();
        par1Tessellator.func_78382_b();
        par1Tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        for (var8 = 0; var8 < 16; ++var8) {
            var9 = (float)var8 / 16.0f;
            var10 = par2 + (par4 - par2) * var9 - 0.001953125f;
            var11 = var6 * var9;
            par1Tessellator.func_78374_a((double)var11, 0.0, (double)(0.0f - var7), (double)var10, (double)par5);
            par1Tessellator.func_78374_a((double)var11, 0.0, 0.0, (double)var10, (double)par5);
            par1Tessellator.func_78374_a((double)var11, 1.0, 0.0, (double)var10, (double)par3);
            par1Tessellator.func_78374_a((double)var11, 1.0, (double)(0.0f - var7), (double)var10, (double)par3);
        }
        par1Tessellator.func_78381_a();
        par1Tessellator.func_78382_b();
        par1Tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        for (var8 = 0; var8 < 16; ++var8) {
            var9 = (float)var8 / 16.0f;
            var10 = par2 + (par4 - par2) * var9 - 0.001953125f;
            var11 = var6 * var9 + 0.0625f;
            par1Tessellator.func_78374_a((double)var11, 1.0, (double)(0.0f - var7), (double)var10, (double)par3);
            par1Tessellator.func_78374_a((double)var11, 1.0, 0.0, (double)var10, (double)par3);
            par1Tessellator.func_78374_a((double)var11, 0.0, 0.0, (double)var10, (double)par5);
            par1Tessellator.func_78374_a((double)var11, 0.0, (double)(0.0f - var7), (double)var10, (double)par5);
        }
        par1Tessellator.func_78381_a();
        par1Tessellator.func_78382_b();
        par1Tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        for (var8 = 0; var8 < 16; ++var8) {
            var9 = (float)var8 / 16.0f;
            var10 = par5 + (par3 - par5) * var9 - 0.001953125f;
            var11 = var6 * var9 + 0.0625f;
            par1Tessellator.func_78374_a(0.0, (double)var11, 0.0, (double)par2, (double)var10);
            par1Tessellator.func_78374_a((double)var6, (double)var11, 0.0, (double)par4, (double)var10);
            par1Tessellator.func_78374_a((double)var6, (double)var11, (double)(0.0f - var7), (double)par4, (double)var10);
            par1Tessellator.func_78374_a(0.0, (double)var11, (double)(0.0f - var7), (double)par2, (double)var10);
        }
        par1Tessellator.func_78381_a();
        par1Tessellator.func_78382_b();
        par1Tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        for (var8 = 0; var8 < 16; ++var8) {
            var9 = (float)var8 / 16.0f;
            var10 = par5 + (par3 - par5) * var9 - 0.001953125f;
            var11 = var6 * var9;
            par1Tessellator.func_78374_a((double)var6, (double)var11, 0.0, (double)par4, (double)var10);
            par1Tessellator.func_78374_a(0.0, (double)var11, 0.0, (double)par2, (double)var10);
            par1Tessellator.func_78374_a(0.0, (double)var11, (double)(0.0f - var7), (double)par2, (double)var10);
            par1Tessellator.func_78374_a((double)var6, (double)var11, (double)(0.0f - var7), (double)par4, (double)var10);
        }
        par1Tessellator.func_78381_a();
    }

    private void renderAsEntity(ItemStack item) {
        GL11.glPushMatrix();
        int iterations = item.field_77994_a;
        if (iterations > 3) {
            iterations = 3;
        }
        Random rand = new Random(187L);
        for (int ii = 0; ii < iterations; ++ii) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(180.0f - RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            if (ii > 0) {
                float var12 = (rand.nextFloat() * 2.0f - 1.0f) * 0.3f;
                float var13 = (rand.nextFloat() * 2.0f - 1.0f) * 0.3f;
                float var14 = (rand.nextFloat() * 2.0f - 1.0f) * 0.3f;
                GL11.glTranslatef((float)var12, (float)var13, (float)var14);
            }
            GL11.glTranslatef((float)0.5f, (float)0.8f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)0.0625f, (float)0.0625f, (float)1.0f);
            this.render(IItemRenderer.ItemRenderType.ENTITY, item);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private void render(IItemRenderer.ItemRenderType type, ItemStack stack) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        Icon cartTexture = stack.func_77954_c();
        this.renderItem.func_94149_a(0, 0, cartTexture, 16, 16);
        ItemStack filter = EntityCartTank.getFilterFromCartItem(stack);
        if (filter != null) {
            int meta = filter.func_77960_j();
            float scale = 0.6f;
            GL11.glScalef((float)scale, (float)scale, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)11.0f, (float)0.0f);
            if (type == IItemRenderer.ItemRenderType.ENTITY) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
            }
            for (int pass = 0; pass < filter.func_77973_b().getRenderPasses(meta); ++pass) {
                Icon bucketTexture = filter.func_77973_b().func_77618_c(meta, pass);
                int color = filter.func_77973_b().func_82790_a(filter, pass);
                float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
                float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
                float c3 = (float)(color & 0xFF) / 255.0f;
                if (this.renderItem.field_77024_a) {
                    GL11.glColor4f((float)c1, (float)c2, (float)c3, (float)1.0f);
                }
                this.renderItem.func_94149_a(0, 0, bucketTexture, 16, 16);
            }
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }
}

