/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.util.effects;

import cpw.mods.fml.client.FMLClientHandler;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Set;
import mods.railcraft.api.signals.SignalTools;
import mods.railcraft.client.core.AuraKeyHandler;
import mods.railcraft.client.particles.EntityChimneyFX;
import mods.railcraft.client.particles.EntityChunkLoaderFX;
import mods.railcraft.client.particles.EntitySteamFX;
import mods.railcraft.client.particles.EntityTuningFX;
import mods.railcraft.common.items.ItemGoggles;
import mods.railcraft.common.util.effects.CommonProxy;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketEffect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public class ClientProxy
extends CommonProxy {
    public static final short TELEPORT_PARTICLES = 64;

    public ClientProxy() {
        SignalTools.effectManager = this;
    }

    private void doTeleport(DataInputStream data) throws IOException {
        double startX = data.readDouble();
        double startY = data.readDouble();
        double startZ = data.readDouble();
        double destX = data.readDouble();
        double destY = data.readDouble();
        double destZ = data.readDouble();
        for (int i = 0; i < 64; ++i) {
            double travel = (double)i / 63.0;
            float vX = (rand.nextFloat() - 0.5f) * 0.2f;
            float vY = (rand.nextFloat() - 0.5f) * 0.2f;
            float vZ = (rand.nextFloat() - 0.5f) * 0.2f;
            double pX = startX + (destX - startX) * travel + (rand.nextDouble() - 0.5) * 2.0;
            double pY = startY + (destY - startY) * travel + (rand.nextDouble() - 0.5) * 2.0;
            double pZ = startZ + (destZ - startZ) * travel + (rand.nextDouble() - 0.5) * 2.0;
            Game.getWorld().func_72869_a("portal", pX, pY, pZ, (double)vX, (double)vY, (double)vZ);
        }
    }

    @Override
    public boolean isAnchorAuraActive() {
        if (ItemGoggles.areEnabled()) {
            ItemStack goggles = ItemGoggles.getGoggles((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            return ItemGoggles.getCurrentAura(goggles) == ItemGoggles.Aura.ANCHOR;
        }
        return AuraKeyHandler.isAnchorAuraEnabled();
    }

    @Override
    public boolean isTuningAuraActive() {
        if (ItemGoggles.areEnabled()) {
            ItemStack goggles = ItemGoggles.getGoggles((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            return ItemGoggles.getCurrentAura(goggles) == ItemGoggles.Aura.TUNING;
        }
        return AuraKeyHandler.isTuningAuraEnabled();
    }

    @Override
    public void tuningEffect(TileEntity start, TileEntity dest) {
        if (rand.nextInt(2) == 0) {
            double px = (double)start.field_70329_l + 0.5 + rand.nextGaussian() * 0.1;
            double py = (double)start.field_70330_m + 0.5 + rand.nextGaussian() * 0.1;
            double pz = (double)start.field_70327_n + 0.5 + rand.nextGaussian() * 0.1;
            EntityTuningFX particle = new EntityTuningFX(start.field_70331_k, px, py, pz, EffectManager.getEffectSource(dest));
            this.spawnParticle(particle);
        }
    }

    @Override
    public void handleEffectPacket(DataInputStream data) throws IOException {
        byte effectId = data.readByte();
        if (effectId < 0) {
            return;
        }
        PacketEffect.Effect effect = PacketEffect.Effect.values()[effectId];
        switch (effect) {
            case TELEPORT: {
                this.doTeleport(data);
            }
        }
    }

    @Override
    public void chunkLoaderEffect(World world, Object source, Set chunks) {
        if (!this.isAnchorAuraActive()) {
            return;
        }
        EffectManager.IEffectSource es = EffectManager.getEffectSource(source);
        if (FMLClientHandler.instance().getClient().field_71439_g.func_70092_e(es.getX(), es.getY(), es.getZ()) > 25600.0) {
            return;
        }
        for (ChunkCoordIntPair chunk : chunks) {
            int xCorner = chunk.field_77276_a * 16;
            int zCorner = chunk.field_77275_b * 16;
            double yCorner = es.getY() - 8.0;
            if (rand.nextInt(3) != 0) continue;
            double xParticle = (float)xCorner + rand.nextFloat() * 16.0f;
            double yParticle = yCorner + (double)(rand.nextFloat() * 16.0f);
            double zParticle = (float)zCorner + rand.nextFloat() * 16.0f;
            EntityChunkLoaderFX particle = new EntityChunkLoaderFX(world, xParticle, yParticle, zParticle, es);
            this.spawnParticle(particle);
        }
    }

    @Override
    public void steamEffect(World world, Object source, double yOffset) {
        EffectManager.IEffectSource es = EffectManager.getEffectSource(source);
        double vx = rand.nextGaussian() * 0.1;
        double vy = rand.nextDouble() * 0.01;
        double vz = rand.nextGaussian() * 0.1;
        this.spawnParticle(new EntitySteamFX(world, es.getX(), es.getY() + yOffset, es.getZ(), vx, vy, vz));
    }

    @Override
    public void chimneyEffect(World world, double x, double y, double z) {
        this.spawnParticle(new EntityChimneyFX(world, x, y, z));
    }

    @Override
    protected void spawnParticle(EntityFX particle) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        mc.field_71452_i.func_78873_a(particle);
    }
}

