/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.util.textures;

import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureStitched;
import net.minecraft.client.texturepacks.ITexturePack;
import net.minecraft.util.Icon;

public class SheetTextureStitched
extends TextureStitched {
    private final int index;
    private final int rows;
    private final int columns;

    public static Icon[] unstitchIcons(IconRegister iconRegister, String name, int numIcons) {
        return SheetTextureStitched.unstitchIcons(iconRegister, name, numIcons, 1);
    }

    public static Icon[] unstitchIcons(IconRegister iconRegister, String name, int columns, int rows) {
        TextureMap textureMap = (TextureMap)iconRegister;
        int numIcons = rows * columns;
        Icon[] icons = new Icon[numIcons];
        for (int i = 0; i < numIcons; ++i) {
            String texName = name + "." + i;
            SheetTextureStitched texture = new SheetTextureStitched(texName, i, rows, columns);
            textureMap.setTextureEntry(texName, (TextureStitched)texture);
            icons[i] = texture;
        }
        return icons;
    }

    private SheetTextureStitched(String name, int index, int rows, int columns) {
        super(name);
        this.index = index;
        this.rows = rows;
        this.columns = columns;
    }

    public boolean loadTexture(TextureManager manager, ITexturePack texturepack, String name, String fileName, BufferedImage image, ArrayList textures) {
        BufferedImage subImage;
        fileName = fileName.replace("." + this.index, "");
        try {
            image = ImageIO.read(texturepack.func_77532_a("/" + fileName));
        }
        catch (IOException ex) {
            Game.log(Level.WARNING, "Failed to load sub-texture from {0}: {1}", fileName, ex.getLocalizedMessage());
            return true;
        }
        int size = image.getHeight() / this.rows;
        int x = this.index % this.columns;
        int y = this.index / this.columns;
        try {
            subImage = image.getSubimage(x * size, y * size, size, size);
        }
        catch (RasterFormatException ex) {
            Game.log(Level.WARNING, "Failed to load sub-texture from {0}: {1}", fileName, ex.getLocalizedMessage());
            throw ex;
        }
        Texture texture = new Texture(name, 2, size, size, 10496, 6408, 9728, 9728, subImage);
        textures.add(texture);
        return true;
    }
}

