/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.brick;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import mods.railcraft.client.util.textures.SheetTextureStitched;
import mods.railcraft.common.blocks.aesthetics.brick.ItemBrick;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.aesthetics.cube.ReplacerCube;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.plugins.buildcraft.BuildcraftPlugin;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class BlockBrick
extends Block {
    public static BlockBrick infernal;
    public static BlockBrick abyssal;
    public static BlockBrick sandy;
    public static BlockBrick frostbound;
    public static BlockBrick bloodstained;
    public static BlockBrick quarried;
    public static BlockBrick bleachedbone;
    private Icon[] icons;
    private final String theme;

    public static BlockBrick getBlock() {
        return infernal;
    }

    public static void setupBlock() {
        if (infernal == null) {
            infernal = BlockBrick.defineBrick("infernal");
            ((ReplacerCube)EnumCube.INFERNAL_BRICK.getBlock()).block = infernal;
            CraftingPlugin.addShapedRecipe(new ItemStack((Block)infernal, 2, 2), "MB", "BM", Character.valueOf('B'), new ItemStack(Block.field_72033_bA), Character.valueOf('M'), new ItemStack(Block.field_72013_bc));
        }
        if (abyssal == null) {
            abyssal = BlockBrick.defineBrick("abyssal");
            if (EnumCube.ABYSSAL_STONE.isEnabled()) {
                CraftingPlugin.addFurnaceRecipe(EnumCube.ABYSSAL_STONE.getItem(), new ItemStack((Block)abyssal, 1, 2), 0.2f);
            }
        }
        if (sandy == null) {
            sandy = BlockBrick.defineBrick("sandy");
            ((ReplacerCube)EnumCube.SANDY_BRICK.getBlock()).block = sandy;
            CraftingPlugin.addShapedRecipe(new ItemStack((Block)sandy, 1, 2), "BM", "MB", Character.valueOf('B'), new ItemStack(Item.field_77772_aH), Character.valueOf('M'), new ItemStack(Block.field_71939_E));
        }
        if (frostbound == null) {
            frostbound = BlockBrick.defineBrick("frostbound");
            CraftingPlugin.addShapedRecipe(new ItemStack((Block)frostbound, 8, 2), "III", "ILI", "III", Character.valueOf('I'), new ItemStack(Block.field_72036_aT), Character.valueOf('L'), new ItemStack(Item.field_77756_aW, 1, 4));
        }
        if (quarried == null) {
            quarried = BlockBrick.defineBrick("quarried");
            if (EnumCube.QUARRIED_STONE.isEnabled()) {
                CraftingPlugin.addFurnaceRecipe(EnumCube.QUARRIED_STONE.getItem(), new ItemStack((Block)quarried, 1, 2), 0.2f);
            }
        }
        if (bleachedbone == null) {
            bleachedbone = BlockBrick.defineBrick("bleachedbone");
            CraftingPlugin.addShapedRecipe(new ItemStack((Block)bleachedbone, 1, 2), "BM", "MB", Character.valueOf('B'), new ItemStack(Item.field_77772_aH), Character.valueOf('M'), new ItemStack(Item.field_77756_aW, 1, 15));
        }
        if (bloodstained == null) {
            bloodstained = BlockBrick.defineBrick("bloodstained");
            CraftingPlugin.addShapelessRecipe(new ItemStack((Block)bloodstained, 1, 2), new ItemStack(Block.field_71957_Q, 1, 2), new ItemStack(Item.field_77737_bm));
            CraftingPlugin.addShapelessRecipe(new ItemStack((Block)bloodstained, 1, 2), new ItemStack(Block.field_71957_Q, 1, 2), new ItemStack(Item.field_77741_bi));
        }
    }

    private static BlockBrick defineBrick(String theme) {
        int id = RailcraftConfig.getBlockId("block.brick." + theme);
        if (id > 0) {
            BlockBrick block = new BlockBrick(id, theme);
            block.func_71864_b("railcraft.brick." + theme);
            GameRegistry.registerBlock((Block)block, ItemBrick.class, (String)block.func_71917_a());
            for (BrickVariant variant : BrickVariant.VALUES) {
                ForestryPlugin.addBackpackItem("builder", block.getItemStack(variant, 1));
                BuildcraftPlugin.addFacade(block, variant.ordinal());
                RailcraftLanguage.instance().registerItemName(block.getItemStack(variant, 1), "brick." + theme + "." + (Object)((Object)variant));
            }
            CraftingPlugin.addShapelessRecipe(block.getItemStack(BrickVariant.BRICK, 1), block.getItemStack(BrickVariant.FITTED, 1));
            CraftingPlugin.addShapelessRecipe(block.getItemStack(BrickVariant.FITTED, 1), block.getItemStack(BrickVariant.BLOCK, 1));
            CraftingPlugin.addShapedRecipe(block.getItemStack(BrickVariant.ORNATE, 8), "III", "I I", "III", Character.valueOf('I'), block.getItemStack(BrickVariant.BLOCK, 1));
            CraftingPlugin.addShapelessRecipe(block.getItemStack(BrickVariant.ETCHED, 1), block.getItemStack(BrickVariant.BLOCK, 1), new ItemStack(Item.field_77677_M));
            return block;
        }
        return null;
    }

    public BlockBrick(int id, String theme) {
        super(id, Material.field_76246_e);
        this.theme = theme;
        this.func_71894_b(15.0f);
        this.func_71848_c(5.0f);
        this.func_71884_a(Block.field_71976_h);
        this.func_71849_a(CreativePlugin.TAB);
    }

    public ItemStack getItemStack(BrickVariant v, int qty) {
        return new ItemStack((Block)this, qty, v.ordinal());
    }

    public int func_71899_b(int meta) {
        return meta;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.icons = SheetTextureStitched.unstitchIcons(iconRegister, "railcraft:brick." + this.theme, BrickVariant.VALUES.length);
    }

    public Icon func_71858_a(int side, int meta) {
        return this.icons[meta];
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (BrickVariant variant : BrickVariant.VALUES) {
            list.add(this.getItemStack(variant, 1));
        }
    }

    public static enum BrickVariant {
        BRICK,
        FITTED,
        BLOCK,
        ORNATE,
        ETCHED;

        public static final BrickVariant[] VALUES;

        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        static {
            VALUES = BrickVariant.values();
        }
    }
}

