/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import java.util.Locale;
import mods.railcraft.api.core.items.ITrackItem;
import mods.railcraft.client.util.textures.SheetTextureStitched;
import mods.railcraft.common.blocks.detector.TileDetector;
import mods.railcraft.common.blocks.detector.TileDetectorAdvanced;
import mods.railcraft.common.blocks.detector.TileDetectorAnimal;
import mods.railcraft.common.blocks.detector.TileDetectorItem;
import mods.railcraft.common.blocks.detector.TileDetectorLocomotive;
import mods.railcraft.common.blocks.detector.TileDetectorSheep;
import mods.railcraft.common.blocks.detector.TileDetectorTank;
import mods.railcraft.common.blocks.detector.TileDetectorTrain;
import mods.railcraft.common.blocks.detector.TileDetectorVillager;
import mods.railcraft.common.items.IActivationBlockingItem;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockRail;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;

public class BlockDetector
extends BlockContainer {
    public BlockDetector(int blockID) {
        super(blockID, Material.field_76246_e);
        this.func_71894_b(4.5f);
        this.func_71848_c(2.0f);
        this.func_71884_a(field_71976_h);
        this.func_71849_a(CreativePlugin.TAB);
        GameRegistry.registerTileEntity(TileDetector.class, (String)"RCDetectorTile");
        GameRegistry.registerTileEntity(TileDetectorItem.class, (String)"RCDetectorItemTile");
        GameRegistry.registerTileEntity(TileDetectorAdvanced.class, (String)"RCDetectorAdvancedTile");
        GameRegistry.registerTileEntity(TileDetectorTank.class, (String)"RCDetectorTankTile");
        GameRegistry.registerTileEntity(TileDetectorAnimal.class, (String)"RCDetectorAnimalTile");
        GameRegistry.registerTileEntity(TileDetectorTrain.class, (String)"RCDetectorTrainTile");
        GameRegistry.registerTileEntity(TileDetectorSheep.class, (String)"RCDetectorSheepTile");
        GameRegistry.registerTileEntity(TileDetectorVillager.class, (String)"RCDetectorVillagerTile");
        GameRegistry.registerTileEntity(TileDetectorLocomotive.class, (String)"RCDetectorLocomotiveTile");
        MinecraftForge.setBlockHarvestLevel((Block)this, (String)"pickaxe", (int)2);
        MinecraftForge.setBlockHarvestLevel((Block)this, (String)"crowbar", (int)0);
    }

    public static String getBlockNameFromMetadata(int meta) {
        StringBuilder name = new StringBuilder("detector.");
        name.append(EnumDetector.fromOrdinal(meta).name().toLowerCase(Locale.ENGLISH));
        return name.toString();
    }

    public boolean isBlockNormalCube(World world, int i, int j, int k) {
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int i, int j, int k, ForgeDirection side) {
        return true;
    }

    public int func_71899_b(int meta) {
        return meta;
    }

    public TileEntity func_72274_a(World var1) {
        return null;
    }

    public TileEntity createTileEntity(World var1, int meta) {
        switch (EnumDetector.values()[meta]) {
            case ITEM: {
                return new TileDetectorItem();
            }
            case ADVANCED: {
                return new TileDetectorAdvanced();
            }
            case TANK: {
                return new TileDetectorTank();
            }
            case ANIMAL: {
                return new TileDetectorAnimal();
            }
            case TRAIN: {
                return new TileDetectorTrain();
            }
            case SHEEP: {
                return new TileDetectorSheep();
            }
            case VILLAGER: {
                return new TileDetectorVillager();
            }
            case LOCOMOTIVE: {
                return new TileDetectorLocomotive();
            }
        }
        return new TileDetector();
    }

    public void func_71860_a(World world, int i, int j, int k, EntityLiving entityliving, ItemStack stack) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileDetector) {
            ((TileDetector)tile).direction = MiscTools.getSideClosestToPlayer(world, i, j, k, entityliving);
            ((TileDetector)tile).onBlockPlacedBy(entityliving);
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float u1, float u2, float u3) {
        TileEntity tile;
        if (player.func_70093_af()) {
            return false;
        }
        ItemStack current = player.func_71045_bC();
        if (current != null) {
            Item item = current.func_77973_b();
            if (item instanceof IActivationBlockingItem) {
                return false;
            }
            if (item.field_77779_bT < Block.field_71973_m.length && BlockRail.func_72184_d((int)item.field_77779_bT) || item instanceof ITrackItem) {
                return false;
            }
        }
        if ((tile = world.func_72796_p(x, y, z)) instanceof TileDetector) {
            return ((TileDetector)tile).blockActivated(player);
        }
        return false;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileDetector) {
            TileDetector detector = (TileDetector)tile;
            detector.direction = detector.direction == axis ? axis.getOpposite() : axis;
            world.func_72845_h(x, y, z);
            return true;
        }
        return false;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        return ForgeDirection.VALID_DIRECTIONS;
    }

    public void func_94332_a(IconRegister iconRegister) {
        for (EnumDetector det : EnumDetector.VALUES) {
            String name = "railcraft:detector." + det.name().toLowerCase(Locale.ENGLISH);
            EnumDetector.access$002(det, SheetTextureStitched.unstitchIcons(iconRegister, name, 3));
        }
    }

    public Icon func_71895_b(IBlockAccess world, int i, int j, int k, int side) {
        int meta = world.func_72805_g(i, j, k);
        EnumDetector det = EnumDetector.fromOrdinal(meta);
        TileEntity t = world.func_72796_p(i, j, k);
        if (t instanceof TileDetector && ((TileDetector)t).direction.ordinal() == side) {
            if (((TileDetector)t).powerState != 0) {
                return det.textures[2];
            }
            return det.textures[1];
        }
        return det.textures[0];
    }

    public Icon func_71858_a(int side, int meta) {
        EnumDetector det = EnumDetector.fromOrdinal(meta);
        if (side == 3) {
            return det.textures[2];
        }
        return det.textures[0];
    }

    public boolean func_71853_i() {
        return true;
    }

    public int func_71865_a(IBlockAccess world, int i, int j, int k, int side) {
        TileEntity t = world.func_72796_p(i, j, k);
        if (t instanceof TileDetector) {
            TileDetector tile = (TileDetector)t;
            if (tile.direction == MiscTools.getOppositeSide(side)) {
                return tile.powerState;
            }
        }
        return 0;
    }

    public void func_71861_g(World world, int i, int j, int k) {
        super.func_71861_g(world, i, j, k);
        world.func_72845_h(i, j, k);
        if (Game.isNotHost(world)) {
            return;
        }
        world.func_72898_h(i + 1, j, k, this.field_71990_ca);
        world.func_72898_h(i - 1, j, k, this.field_71990_ca);
        world.func_72898_h(i, j, k + 1, this.field_71990_ca);
        world.func_72898_h(i, j, k - 1, this.field_71990_ca);
        world.func_72898_h(i, j - 1, k, this.field_71990_ca);
        world.func_72898_h(i, j + 1, k, this.field_71990_ca);
    }

    public void func_71852_a(World world, int i, int j, int k, int id, int metadata) {
        super.func_71852_a(world, i, j, k, id, metadata);
        if (Game.isNotHost(world)) {
            return;
        }
        TileEntity t = world.func_72796_p(i, j, k);
        if (t instanceof TileDetector) {
            TileDetector tile = (TileDetector)t;
            tile.onBlockRemoval();
        }
        world.func_72898_h(i + 1, j, k, this.field_71990_ca);
        world.func_72898_h(i - 1, j, k, this.field_71990_ca);
        world.func_72898_h(i, j, k + 1, this.field_71990_ca);
        world.func_72898_h(i, j, k - 1, this.field_71990_ca);
        world.func_72898_h(i, j - 1, k, this.field_71990_ca);
        world.func_72898_h(i, j + 1, k, this.field_71990_ca);
    }

    public boolean canConnectRedstone(IBlockAccess world, int i, int j, int k, int dir) {
        TileEntity t = world.func_72796_p(i, j, k);
        if (t instanceof TileDetector) {
            TileDetector tile = (TileDetector)t;
            if (dir == 1 && tile.direction.ordinal() == 5) {
                return true;
            }
            if (dir == 3 && tile.direction.ordinal() == 4) {
                return true;
            }
            if (dir == 2 && tile.direction.ordinal() == 3) {
                return true;
            }
            if (dir == 0 && tile.direction.ordinal() == 2) {
                return true;
            }
        }
        return false;
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (EnumDetector d : EnumDetector.values()) {
            if (d == EnumDetector.ENERGY && !ModuleManager.isModuleLoaded(ModuleManager.Module.IC2) || d == EnumDetector.TRAIN && !ModuleManager.isModuleLoaded(ModuleManager.Module.TRAIN)) continue;
            list.add(new ItemStack(this.field_71990_ca, 1, d.ordinal()));
        }
    }

    public static enum EnumDetector {
        ITEM,
        ANY,
        EMPTY,
        MOB,
        POWERED,
        PLAYER,
        EXPLOSIVE,
        ANIMAL,
        TANK,
        ADVANCED,
        ENERGY,
        AGE,
        TRAIN,
        SHEEP,
        VILLAGER,
        LOCOMOTIVE;

        public static final EnumDetector[] VALUES;
        private Icon[] textures;

        public static EnumDetector fromOrdinal(int meta) {
            if (meta >= VALUES.length) {
                meta = 0;
            }
            return VALUES[meta];
        }

        static /* synthetic */ Icon[] access$002(EnumDetector x0, Icon[] x1) {
            x0.textures = x1;
            return x1;
        }

        static {
            VALUES = EnumDetector.values();
        }
    }
}

