/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.detector;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.detector.TileDetector;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class TileDetectorTrain
extends TileDetector
implements IGuiReturnHandler {
    private short trainSize = (short)5;

    @Override
    public int testCarts() {
        LinkageManager lm = LinkageManager.instance(this.field_70331_k);
        List carts = CartTools.getMinecartsOnAllSides(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0.2f);
        for (EntityMinecart cart : carts) {
            if (lm.countCartsInTrain(cart) < this.getTrainSize()) continue;
            return 15;
        }
        return 0;
    }

    @Override
    protected short updateInterval() {
        return 4;
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.DETECTOR_TRAIN, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74777_a("size", this.getTrainSize());
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.setTrainSize(data.func_74765_d("size"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeShort(this.getTrainSize());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.setTrainSize(data.readShort());
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeShort(this.getTrainSize());
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        this.setTrainSize(data.readShort());
    }

    public short getTrainSize() {
        return this.trainSize;
    }

    public void setTrainSize(short trainSize) {
        this.trainSize = trainSize;
    }
}

