/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.util.misc.AdjacentTileCache;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.misc.Timer;
import mods.railcraft.common.util.network.PacketTileRequest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileMultiBlock
extends TileMachineBase {
    private static final int UNKNOWN_STATE_RECHECK = 256;
    private static final int NETWORK_RECHECK = 64;
    protected boolean isMaster;
    private byte patternX;
    private byte patternY;
    private byte patternZ;
    private boolean tested;
    private boolean requestPacket;
    protected int update = MiscTools.getRand().nextInt();
    private Timer netTimer = new Timer();
    private MultiBlockState state;
    private TileMultiBlock masterBlock;
    private MultiBlockPattern currentPattern;
    private final List patterns;
    private final AdjacentTileCache tileCache = new AdjacentTileCache(this);

    public TileMultiBlock(List patterns) {
        this.patterns = patterns;
        this.currentPattern = (MultiBlockPattern)patterns.get(0);
        this.tested = FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER;
    }

    protected void onPatternLock(MultiBlockPattern pattern) {
    }

    public final char getPatternMarker() {
        if (this.currentPattern == null || !this.isStructureValid()) {
            return 'O';
        }
        return this.currentPattern.getPatternMarker(this.patternX, this.patternY, this.patternZ);
    }

    public final int getPatternPositionX() {
        return this.patternX;
    }

    public final int getPatternPositionY() {
        return this.patternY;
    }

    public final int getPatternPositionZ() {
        return this.patternZ;
    }

    private void setPatternPosition(byte x, byte y, byte z) {
        this.patternX = x;
        this.patternY = y;
        this.patternZ = z;
    }

    public final void setPattern(MultiBlockPattern pattern) {
        this.currentPattern = pattern;
        this.onPatternLock(pattern);
    }

    public final MultiBlockPattern getPattern() {
        return this.currentPattern;
    }

    public final byte getPatternIndex() {
        return (byte)this.patterns.indexOf(this.currentPattern);
    }

    protected int getMaxRecursionDepth() {
        return 12;
    }

    @Override
    public final boolean canUpdate() {
        return true;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        ++this.update;
        if (Game.isHost(this.field_70331_k)) {
            if (!(this.tested || this.state == MultiBlockState.UNKNOWN && this.update % 256 != 0)) {
                this.testIfMasterBlock();
            }
        } else if (this.requestPacket && this.netTimer.hasTriggered(this.field_70331_k, 64)) {
            PacketTileRequest pkt = new PacketTileRequest(this);
            PacketDispatcher.sendPacketToServer((Packet)pkt.getPacket());
            this.requestPacket = false;
        }
    }

    private void testIfMasterBlock() {
        this.state = this.getMasterBlockState();
        this.tested = true;
        if (this.state == MultiBlockState.UNKNOWN) {
            this.tested = false;
        } else if (this.state == MultiBlockState.VALID) {
            this.isMaster = true;
            byte by = this.currentPattern.getPatternWidthX();
            byte by2 = this.currentPattern.getPatternWidthZ();
            byte by3 = this.currentPattern.getPatternHeight();
            int xOffset = this.field_70329_l - this.currentPattern.getMasterOffsetX();
            int yOffset = this.field_70330_m - this.currentPattern.getMasterOffsetY();
            int zOffset = this.field_70327_n - this.currentPattern.getMasterOffsetZ();
            for (byte px = 0; px < by; px = (byte)((byte)(px + 1))) {
                for (byte py = 0; py < by3; py = (byte)((byte)(py + 1))) {
                    for (byte pz = 0; pz < by2; pz = (byte)((byte)(pz + 1))) {
                        char marker = this.currentPattern.getPatternMarker(px, py, pz);
                        if (this.isMapPositionOtherBlock(marker)) continue;
                        int x = px + xOffset;
                        int y = py + yOffset;
                        int z = pz + zOffset;
                        TileEntity tile = this.field_70331_k.func_72796_p(x, y, z);
                        if (tile instanceof TileMultiBlock) {
                            TileMultiBlock multiBlock = (TileMultiBlock)tile;
                            multiBlock.masterBlock = this;
                            multiBlock.tested = true;
                            multiBlock.setPattern(this.currentPattern);
                            multiBlock.setPatternPosition(px, py, pz);
                            multiBlock.sendUpdateToClient();
                            continue;
                        }
                        return;
                    }
                }
            }
        } else if (this.isMaster) {
            this.isMaster = false;
            this.onMasterReset();
            this.sendUpdateToClient();
        }
    }

    protected void onMasterReset() {
    }

    protected boolean isMapPositionOtherBlock(char mapPos) {
        switch (mapPos) {
            case 'A': 
            case 'O': {
                return true;
            }
        }
        return false;
    }

    protected boolean isMapPositionValid(int i, int j, int k, char mapPos) {
        int id = this.field_70331_k.func_72798_a(i, j, k);
        switch (mapPos) {
            case 'O': {
                if (id != this.getBlockId() || this.field_70331_k.func_72805_g(i, j, k) != this.func_70322_n()) break;
                return false;
            }
            case 'B': 
            case 'W': {
                if (id == this.getBlockId() && this.field_70331_k.func_72805_g(i, j, k) == this.func_70322_n()) break;
                return false;
            }
            case 'A': {
                if (this.field_70331_k.func_72799_c(i, j, k)) break;
                return false;
            }
        }
        return true;
    }

    private MultiBlockState getMasterBlockState() {
        for (MultiBlockPattern map : this.patterns) {
            boolean valid = true;
            int xWidth = map.getPatternWidthX();
            int zWidth = map.getPatternWidthZ();
            int height = map.getPatternHeight();
            int xOffset = this.field_70329_l - map.getMasterOffsetX();
            int yOffset = this.field_70330_m - map.getMasterOffsetY();
            int zOffset = this.field_70327_n - map.getMasterOffsetZ();
            for (int x = 0; x < xWidth && valid; ++x) {
                block2: for (int y = 0; y < height && valid; ++y) {
                    for (int z = 0; z < zWidth; ++z) {
                        int xx = x + xOffset;
                        int yy = y + yOffset;
                        int zz = z + zOffset;
                        if (!this.field_70331_k.func_72899_e(xx, yy, zz)) {
                            return MultiBlockState.UNKNOWN;
                        }
                        if (this.isMapPositionValid(xx, yy, zz, map.getPatternMarker(x, y, z))) continue;
                        valid = false;
                        continue block2;
                    }
                }
            }
            if (!valid) continue;
            AxisAlignedBB entityCheckBounds = map.getEntityCheckBounds(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            if (entityCheckBounds != null && !this.field_70331_k.func_72872_a(Entity.class, entityCheckBounds).isEmpty()) {
                return MultiBlockState.INVALID;
            }
            this.currentPattern = map;
            return MultiBlockState.VALID;
        }
        return MultiBlockState.INVALID;
    }

    @Override
    public void onBlockAdded() {
        super.onBlockAdded();
        if (Game.isNotHost(this.field_70331_k)) {
            return;
        }
        this.onBlockChange();
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        if (Game.isNotHost(this.field_70331_k)) {
            return;
        }
        this.onBlockChange();
        this.isMaster = false;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (Game.isNotHost(this.field_70331_k)) {
            return;
        }
        this.tested = false;
        this.scheduleMasterRetest();
    }

    public void func_70313_j() {
        if (this.field_70331_k != null && Game.isNotHost(this.field_70331_k)) {
            return;
        }
        this.tileCache.purge();
        this.tested = false;
        this.scheduleMasterRetest();
        super.func_70313_j();
    }

    public void func_70312_q() {
        this.tileCache.purge();
        super.func_70312_q();
    }

    private void onBlockChange() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.tileCache.getTileOnSide(side);
            if (!(tile instanceof TileMultiBlock)) continue;
            ((TileMultiBlock)tile).onBlockChange(this.getMaxRecursionDepth());
        }
    }

    private void onBlockChange(int depth) {
        if (--depth < 0) {
            return;
        }
        if (this.tested) {
            this.tested = false;
            TileMultiBlock mBlock = this.getMasterBlock();
            if (mBlock != null) {
                mBlock.onBlockChange(this.getMaxRecursionDepth());
                return;
            }
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = this.tileCache.getTileOnSide(side);
                if (!this.isStructureTile(tile)) continue;
                ((TileMultiBlock)tile).onBlockChange(depth);
            }
        }
    }

    protected boolean isStructureTile(TileEntity tile) {
        return tile != null && tile.getClass() == this.getClass();
    }

    public void func_70296_d() {
        TileMultiBlock mBlock;
        super.func_70296_d();
        if (!this.isMaster && (mBlock = this.getMasterBlock()) != null) {
            mBlock.func_70296_d();
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74757_a("master", this.isMaster);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.isMaster = data.func_74767_n("master");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        boolean hasMaster = this.getMasterBlock() != null;
        data.writeBoolean(hasMaster);
        if (hasMaster) {
            byte patternIndex = this.getPatternIndex();
            data.writeByte(patternIndex);
            data.writeByte(this.patternX);
            data.writeByte(this.patternY);
            data.writeByte(this.patternZ);
        }
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.requestPacket = false;
        boolean needsRenderUpdate = false;
        boolean hasMaster = data.readBoolean();
        if (hasMaster) {
            byte patternIndex = data.readByte();
            patternIndex = (byte)Math.max(patternIndex, 0);
            patternIndex = (byte)Math.min(patternIndex, this.patterns.size() - 1);
            MultiBlockPattern pat = (MultiBlockPattern)this.patterns.get(patternIndex);
            byte pX = data.readByte();
            byte pY = data.readByte();
            byte pZ = data.readByte();
            if (this.patternX != pX || this.patternY != pY || this.patternZ != pZ) {
                this.patternX = pX;
                this.patternY = pY;
                this.patternZ = pZ;
                needsRenderUpdate = true;
            }
            this.isMaster = pX == pat.getMasterOffsetX() && pY == pat.getMasterOffsetY() && pZ == pat.getMasterOffsetZ();
            this.setPattern(pat);
            int masterX = pat.getMasterRelativeX(this.field_70329_l, pX);
            int masterY = pat.getMasterRelativeY(this.field_70330_m, pY);
            int masterZ = pat.getMasterRelativeZ(this.field_70327_n, pZ);
            TileEntity tile = null;
            if (this.field_70331_k != null) {
                tile = this.field_70331_k.func_72796_p(masterX, masterY, masterZ);
            }
            if (tile != null && this.masterBlock != tile && this.isStructureTile(tile)) {
                needsRenderUpdate = true;
                this.masterBlock = (TileMultiBlock)tile;
            }
            if (this.getMasterBlock() == null) {
                this.requestPacket = true;
            }
        } else if (this.masterBlock != null) {
            needsRenderUpdate = true;
            this.masterBlock = null;
            this.isMaster = false;
        }
        if (needsRenderUpdate) {
            this.markBlockForUpdate();
        }
    }

    public final boolean isMaster() {
        return this.isMaster;
    }

    public final void setMaster(boolean m) {
        this.isMaster = m;
    }

    public final void scheduleMasterRetest() {
        if (this.masterBlock != null) {
            this.masterBlock.tested = false;
        }
    }

    public final boolean isStructureValid() {
        return this.masterBlock != null && this.masterBlock.tested && this.masterBlock.isMaster && !this.masterBlock.func_70320_p();
    }

    public final TileMultiBlock getMasterBlock() {
        if (this.masterBlock != null && !this.isStructureValid()) {
            this.masterBlock = null;
            this.sendUpdateToClient();
        }
        return this.masterBlock;
    }

    @Override
    public boolean canCreatureSpawn(EnumCreatureType type) {
        return this.isStructureValid() && this.getPatternPositionY() < 2 ? false : super.canCreatureSpawn(type);
    }

    private static enum MultiBlockState {
        VALID,
        INVALID,
        UNKNOWN;

    }
}

