/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.TileBoilerFirebox;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.liquids.LiquidFilter;
import mods.railcraft.common.liquids.LiquidManager;
import mods.railcraft.common.plugins.buildcraft.triggers.INeedsFuel;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.InventoryCopy;
import mods.railcraft.common.util.inventory.InventoryMapper;
import mods.railcraft.common.util.inventory.filters.EnumStackFilter;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class TileBoilerFireboxSolid
extends TileBoilerFirebox
implements ISidedInventory,
INeedsFuel {
    private static final int SLOT_BURN = 2;
    private static final int SLOT_FUEL_A = 3;
    private static final int SLOT_FUEL_B = 4;
    private static final int SLOT_FUEL_C = 5;
    private IInventory invBurn = new InventoryMapper(this, 2, 1);
    private IInventory invStock = new InventoryMapper(this, 3, 3);
    private IInventory invFuel = new InventoryMapper(this, 2, 4);
    private ItemStack bucket = new ItemStack(Item.field_77788_aw);
    private boolean testNearbyChests = true;
    private List nearbyChests = new ArrayList();

    public TileBoilerFireboxSolid() {
        super(6);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineBeta.BOILER_FIREBOX_SOLID;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        TileMultiBlock mBlock = this.getMasterBlock();
        if (mBlock != null) {
            GuiHandler.openGui(EnumGui.BOILER_SOLID, player, this.field_70331_k, mBlock.field_70329_l, mBlock.field_70330_m, mBlock.field_70327_n);
            return true;
        }
        return false;
    }

    @Override
    protected void process() {
        InvTools.moveOneItem(this.invStock, this.invBurn);
        InvTools.moveOneItem(this.invBurn, this.invWaterOutput, this.bucket);
    }

    @Override
    public void func_70316_g() {
        block2: {
            IInventory nearby;
            TileBoilerFireboxSolid mBlock;
            super.func_70316_g();
            if (Game.isNotHost(this.getWorld())) {
                return;
            }
            if (!this.needsFuel() || (mBlock = (TileBoilerFireboxSolid)this.getMasterBlock()) == null) break block2;
            Iterator i$ = this.getNearbyChests().iterator();
            while (i$.hasNext() && InvTools.moveOneItem(nearby = (IInventory)i$.next(), mBlock.invStock, EnumStackFilter.FUEL) == null) {
            }
        }
    }

    private List getNearbyChests() {
        if (this.testNearbyChests) {
            this.testNearbyChests = false;
            this.nearbyChests.clear();
            for (int side = 2; side < 6; ++side) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)side);
                IInventory inv = InvTools.getInventoryFromSide(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, dir, null, TileBoilerFirebox.class);
                if (inv == null || inv.func_70302_i_() < 27) continue;
                this.nearbyChests.add(inv);
            }
        }
        return this.nearbyChests;
    }

    @Override
    public void onNeighborBlockChange(int id) {
        super.onNeighborBlockChange(id);
        this.testNearbyChests = true;
    }

    @Override
    protected float getMoreFuel() {
        ItemStack fuel = this.func_70301_a(2);
        int burn = FuelPlugin.getBurnTime(fuel);
        if (burn > 0) {
            this.func_70299_a(2, InvTools.depleteItem(fuel));
        }
        return burn;
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 0;
            }
        }
        return 2;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 2;
            }
        }
        return 4;
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (stack == null) {
            return 0;
        }
        if (FuelPlugin.getBurnTime(stack) > 0) {
            ItemStack remainder;
            IInventory inv = this.invFuel;
            if (!doAdd) {
                inv = new InventoryCopy(inv);
            }
            if ((remainder = InvTools.moveItemStack(stack, inv)) == null) {
                return stack.field_77994_a;
            }
            return stack.field_77994_a - remainder.field_77994_a;
        }
        if (LiquidManager.instance().isFilledContainer(stack) && LiquidManager.instance().containsLiquid(stack, LiquidFilter.WATER)) {
            ItemStack remainder;
            IInventory inv = this.invWaterInput;
            if (!doAdd) {
                inv = new InventoryCopy(inv);
            }
            if ((remainder = InvTools.moveItemStack(stack, inv)) == null) {
                return stack.field_77994_a;
            }
            return stack.field_77994_a - remainder.field_77994_a;
        }
        return 0;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        IInventory inv = this.invWaterOutput;
        if (!doRemove) {
            inv = new InventoryCopy(inv);
        }
        return InvTools.removeItems(inv, maxItemCount);
    }

    @Override
    public boolean needsFuel() {
        TileBoilerFireboxSolid mBlock = (TileBoilerFireboxSolid)this.getMasterBlock();
        if (mBlock != null) {
            int amount = InvTools.countItems(mBlock.invFuel);
            return amount < 64;
        }
        return false;
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot >= 2) {
            return FuelPlugin.getBurnTime(stack) > 0;
        }
        if (slot == 0) {
            return LiquidManager.instance().isFilledContainer(stack) && LiquidManager.instance().containsLiquid(stack, LiquidFilter.WATER);
        }
        return false;
    }
}

