/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.machine.beta.TileBoiler;
import mods.railcraft.common.blocks.machine.beta.TileBoilerFirebox;
import mods.railcraft.common.liquids.tanks.FakeTank;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public abstract class TileBoilerTank
extends TileBoiler {
    private boolean isConnected;

    protected TileBoilerTank() {
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.isStructureValid());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.isConnected = data.readBoolean();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return 0;
    }

    @Override
    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    @Override
    public ITankContainer getOutputOnSide(ForgeDirection side) {
        TileEntity tile = MiscTools.getBlockTileEntityOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, side);
        if (tile instanceof TileBoiler) {
            return null;
        }
        if (tile instanceof ITankContainer) {
            return (ITankContainer)tile;
        }
        return null;
    }

    public ILiquidTank getTank(ForgeDirection side, LiquidStack type) {
        TileBoilerFirebox mBlock = (TileBoilerFirebox)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager.getTank(1);
        }
        return FakeTank.INSTANCE;
    }
}

