/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineItem;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.BlockChest;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TileChestVoid
extends TileMachineItem {
    private static final ForgeDirection[] UP_DOWN_AXES = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
    private static final int TICK_PER_SYNC = 64;
    private static final int TICK_PER_VOID = 8;
    private ForgeDirection facing = ForgeDirection.EAST;
    public float lidAngle;
    public float prevLidAngle;
    public int numUsingPlayers;
    private int update;

    public TileChestVoid() {
        super(27);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineBeta.VOID_CHEST;
    }

    @Override
    public void onBlockPlacedBy(EntityLiving entityliving) {
        super.onBlockPlacedBy(entityliving);
        this.facing = MiscTools.getHorizontalSideClosestToPlayer(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, entityliving);
    }

    public ForgeDirection getFacing() {
        return this.facing;
    }

    @Override
    public boolean rotateBlock(ForgeDirection axis) {
        if (axis == ForgeDirection.UP || axis == ForgeDirection.DOWN) {
            return false;
        }
        this.facing = this.facing == axis ? axis.getOpposite() : axis;
        this.markBlockForUpdate();
        return true;
    }

    @Override
    public ForgeDirection[] getValidRotations() {
        return UP_DOWN_AXES;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        if (this.field_70331_k.isBlockSolidOnSide(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n, ForgeDirection.DOWN)) {
            return false;
        }
        if (BlockChest.func_72292_n((World)this.field_70331_k, (int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n)) {
            return false;
        }
        player.func_71007_a((IInventory)this);
        return true;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        ++this.update;
        if (this.update % 64 == 0) {
            this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockId(), 1, this.numUsingPlayers);
        }
        this.prevLidAngle = this.lidAngle;
        float angleChange = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "random.chestopen", 0.5f, this.field_70331_k.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float openAngle;
            float angle = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += angleChange) : (this.lidAngle -= angleChange);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (openAngle = 0.5f) && angle >= openAngle) {
                this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "random.chestclosed", 0.5f, this.field_70331_k.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
        if (this.update % 8 == 0 && Game.isHost(this.field_70331_k)) {
            for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
                ItemStack stack = this.func_70301_a(slot);
                if (stack == null) continue;
                this.func_70298_a(slot, 1);
                break;
            }
        }
    }

    public boolean func_70315_b(int id, int value) {
        if (id == 1) {
            this.numUsingPlayers = value;
            return true;
        }
        return super.func_70315_b(id, value);
    }

    @Override
    public void func_70295_k_() {
        ++this.numUsingPlayers;
        this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockId(), 1, this.numUsingPlayers);
    }

    @Override
    public void func_70305_f() {
        --this.numUsingPlayers;
        this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockId(), 1, this.numUsingPlayers);
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74774_a("facing", (byte)this.facing.ordinal());
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.facing = ForgeDirection.getOrientation((int)data.func_74771_c("facing"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte((byte)this.facing.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.facing = ForgeDirection.getOrientation((int)data.readByte());
    }
}

