/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.common.blocks.machine.ITankTile;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.beta.IronTank;
import mods.railcraft.common.blocks.machine.beta.MetalTank;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.gui.slots.SlotLiquidContainer;
import mods.railcraft.common.liquids.LiquidManager;
import mods.railcraft.common.liquids.TankManager;
import mods.railcraft.common.liquids.tanks.StandardTank;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import mods.railcraft.common.util.misc.EnumColor;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.liquids.ILiquidTank;

public abstract class TileTankIron
extends TileMultiBlock
implements ITankTile {
    public static final int CAPACITY_PER_BLOCK_IRON = 16000;
    public static final int CAPACITY_PER_BLOCK_STEEL = 32000;
    private static final MetalTank IRON_TANK = new IronTank();
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_OUTPUT = 1;
    protected final TankManager tankManager = new TankManager();
    private static final List patterns = TileTankIron.buildPatterns();
    private final StandaloneInventory inv;
    private EnumColor color = EnumColor.WHITE;

    protected TileTankIron() {
        super(patterns);
        this.inv = new StandaloneInventory(2, "gui.tank.iron", this);
        StandardTank tank = new StandardTank(64000, this);
        this.tankManager.addTank(tank);
    }

    public MetalTank getTankType() {
        return IRON_TANK;
    }

    @Override
    public IInventory getInventory() {
        return this.inv;
    }

    @Override
    public Slot getInputSlot(IInventory inv, int slotNum, int x, int y) {
        return new SlotLiquidContainer(inv, slotNum, x, y);
    }

    @Override
    public float getResistance(Entity exploder) {
        return this.getTankType().getResistance(exploder);
    }

    @Override
    protected int getMaxRecursionDepth() {
        return 500;
    }

    @Override
    public String getTitle() {
        return this.getTankType().getTitle();
    }

    @Override
    public void initFromItem(ItemStack stack) {
        super.initFromItem(stack);
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("color")) {
            this.recolourBlock(nbt.func_74771_c("color"));
        }
    }

    @Override
    public boolean canSilkHarvest(EntityPlayer player) {
        return true;
    }

    @Override
    public ArrayList getBlockDroppedSilkTouch(int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack drop = this.getMachineType().getItem();
        NBTTagCompound nbt = InvTools.getItemData(drop);
        nbt.func_74774_a("color", (byte)this.color.ordinal());
        items.add(drop);
        return items;
    }

    @Override
    public boolean recolourBlock(int cID) {
        EnumColor c = EnumColor.fromId(cID);
        if (this.color != c) {
            this.color = c;
            this.markBlockForUpdate();
            return true;
        }
        return false;
    }

    @Override
    public int colorMultiplier() {
        return this.color.getHexColor();
    }

    @Override
    protected boolean isStructureTile(TileEntity tile) {
        return tile instanceof TileTankIron;
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        ItemStack current = player.func_71045_bC();
        if (Game.isHost(this.field_70331_k) ? this.isStructureValid() && LiquidManager.instance().handleRightClick(this.getTankManager(), 0, player, true, true) : LiquidManager.instance().isContainer(current)) {
            return true;
        }
        if (current != null && current.field_77993_c == Item.field_77769_aE.field_77779_bT) {
            return true;
        }
        return super.blockActivated(player, side);
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        TileMultiBlock mBlock = this.getMasterBlock();
        if (mBlock != null) {
            GuiHandler.openGui(EnumGui.TANK, player, this.field_70331_k, mBlock.field_70329_l, mBlock.field_70330_m, mBlock.field_70327_n);
            return true;
        }
        return false;
    }

    @Override
    public TankManager getTankManager() {
        TileTankIron mBlock = (TileTankIron)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager;
        }
        return null;
    }

    @Override
    public ILiquidTank getTank() {
        TileTankIron mBlock = (TileTankIron)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager.getTank(0);
        }
        return null;
    }

    public int getCapacityPerBlock() {
        return 16000;
    }

    @Override
    protected void onPatternLock(MultiBlockPattern pattern) {
        if (this.isMaster) {
            int capacity = (pattern.getPatternWidthX() - 2) * (pattern.getPatternHeight() - pattern.getMasterOffsetY() * 2) * (pattern.getPatternWidthZ() - 2) * this.getCapacityPerBlock();
            this.tankManager.setCapacity(0, capacity);
        }
    }

    @Override
    protected boolean isMapPositionValid(int x, int y, int z, char mapPos) {
        switch (mapPos) {
            case 'O': {
                int id = this.field_70331_k.func_72798_a(x, y, z);
                if (id == this.getBlockId()) {
                    int meta = this.field_70331_k.func_72805_g(x, y, z);
                    if (this.getTankType().isTankBlock(meta)) {
                        return false;
                    }
                }
                return true;
            }
            case 'W': {
                int id = this.field_70331_k.func_72798_a(x, y, z);
                if (id != this.getBlockId()) {
                    return false;
                }
                int meta = this.field_70331_k.func_72805_g(x, y, z);
                return this.getTankType().isTankBlock(meta);
            }
            case 'B': {
                int id = this.field_70331_k.func_72798_a(x, y, z);
                if (id != this.getBlockId()) {
                    return false;
                }
                int meta = this.field_70331_k.func_72805_g(x, y, z);
                return this.getTankType().isWallBlock(meta);
            }
            case 'M': 
            case 'T': {
                int id = this.field_70331_k.func_72798_a(x, y, z);
                if (id != this.getBlockId()) {
                    return false;
                }
                int meta = this.field_70331_k.func_72805_g(x, y, z);
                if (!this.getTankType().isTankBlock(meta)) {
                    return false;
                }
                TileEntity tile = this.field_70331_k.func_72796_p(x, y, z);
                if (!(tile instanceof TileMultiBlock)) {
                    this.field_70331_k.func_72932_q(x, y, z);
                    return true;
                }
                return !((TileMultiBlock)tile).isStructureValid();
            }
            case 'A': {
                return this.field_70331_k.func_72799_c(x, y, z);
            }
        }
        return true;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isHost(this.field_70331_k) && this.isMaster) {
            if (this.update % 8 == 0) {
                LiquidManager.instance().processContainers(this.tankManager.getTank(0), this.inv, 0, 1);
            }
            if (this.update % 128 == 0) {
                this.sendUpdateToClient();
            }
        }
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        this.tankManager.getTank(0).setLiquid(null);
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.tankManager.writeTanksToNBT(data);
        this.inv.writeToNBT("inv", data);
        data.func_74774_a("color", (byte)this.color.ordinal());
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.tankManager.readTanksFromNBT(data);
        this.inv.readFromNBT("inv", data);
        if (data.func_74764_b("color")) {
            this.color = EnumColor.fromId(data.func_74771_c("color"));
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.color.ordinal());
        this.tankManager.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        EnumColor c = EnumColor.fromId(data.readByte());
        this.tankManager.readPacketData(data);
        if (this.color != c) {
            this.color = c;
            this.markBlockForUpdate();
        }
    }

    public double func_82115_m() {
        return 32767.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public boolean shouldRenderInPass(int pass) {
        return this.isMaster ? pass == 0 : pass == 1;
    }

    private static List buildPatterns() {
        AxisAlignedBB entityCheck;
        char[][][] map;
        int i;
        ArrayList<MultiBlockPattern> pats = new ArrayList<MultiBlockPattern>();
        boolean client = FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
        int xOffset = 2;
        int yOffset = 0;
        int zOffset = 2;
        char[][] bottom = new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'M', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}};
        char[][] middle = new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'W', 'A', 'W', 'O'}, {'O', 'B', 'W', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}};
        char[][] top = new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'T', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}};
        char[][] border = new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}};
        for (i = 4; i <= 8; ++i) {
            map = TileTankIron.buildMap(i, bottom, middle, top, border);
            entityCheck = AxisAlignedBB.func_72330_a((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)(i - 1), (double)1.0);
            pats.add(TileTankIron.buildPattern(map, xOffset, yOffset, zOffset, entityCheck));
        }
        if (client || RailcraftConfig.getMaxTankSize() >= 5) {
            zOffset = 3;
            xOffset = 3;
            bottom = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'M', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            middle = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'W', 'W', 'W', 'B', 'O'}, {'O', 'W', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'W', 'O'}, {'O', 'B', 'W', 'W', 'W', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            top = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'T', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            border = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            for (i = 4; i <= 8; ++i) {
                map = TileTankIron.buildMap(i, bottom, middle, top, border);
                entityCheck = AxisAlignedBB.func_72330_a((double)-1.0, (double)1.0, (double)-1.0, (double)2.0, (double)(i - 1), (double)2.0);
                pats.add(TileTankIron.buildPattern(map, xOffset, yOffset, zOffset, entityCheck));
            }
        }
        if (client || RailcraftConfig.getMaxTankSize() >= 7) {
            zOffset = 4;
            xOffset = 4;
            bottom = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'M', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            middle = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            top = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'T', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            border = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            for (i = 4; i <= 8; ++i) {
                map = TileTankIron.buildMap(i, bottom, middle, top, border);
                entityCheck = AxisAlignedBB.func_72330_a((double)-2.0, (double)1.0, (double)-2.0, (double)3.0, (double)(i - 1), (double)3.0);
                pats.add(TileTankIron.buildPattern(map, xOffset, yOffset, zOffset, entityCheck));
            }
        }
        if (client || RailcraftConfig.getMaxTankSize() >= 9) {
            zOffset = 5;
            xOffset = 5;
            bottom = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'M', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            middle = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'W', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'W', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            top = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'T', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'B', 'O'}, {'O', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            border = new char[][]{{'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O'}};
            for (i = 4; i <= 8; ++i) {
                map = TileTankIron.buildMap(i, bottom, middle, top, border);
                entityCheck = AxisAlignedBB.func_72330_a((double)-3.0, (double)1.0, (double)-3.0, (double)4.0, (double)(i - 1), (double)4.0);
                pats.add(TileTankIron.buildPattern(map, xOffset, yOffset, zOffset, entityCheck));
            }
        }
        return pats;
    }

    private static MultiBlockPattern buildPattern(char[][][] map, int xOffset, int yOffset, int zOffset, AxisAlignedBB entityCheck) {
        if (!RailcraftConfig.allowTankStacking()) {
            entityCheck.func_72317_d(0.0, 1.0, 0.0);
            yOffset = 1;
        }
        return new MultiBlockPattern(map, xOffset, yOffset, zOffset, entityCheck);
    }

    private static char[][][] buildMap(int height, char[][] bottom, char[][] mid, char[][] top, char[][] border) {
        char[][][] map;
        if (RailcraftConfig.allowTankStacking()) {
            map = new char[height][][];
            map[0] = bottom;
            map[height - 1] = top;
            for (int i = 1; i < height - 1; ++i) {
                map[i] = mid;
            }
        } else {
            map = new char[height + 2][][];
            map[0] = border;
            map[1] = bottom;
            map[height] = top;
            map[height + 1] = border;
            for (int i = 2; i < height; ++i) {
                map[i] = mid;
            }
        }
        return map;
    }
}

