/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.core.items.IMinecartItem;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineItem;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.InventoryCopy;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class TileDispenserCart
extends TileMachineItem
implements ISidedInventory {
    protected ForgeDirection direction = ForgeDirection.NORTH;
    protected boolean powered;
    protected int timeSinceLastSpawn;

    public TileDispenserCart() {
        super(3);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.DISPENSER_CART;
    }

    @Override
    public Icon getBlockTexture(int side) {
        if (this.direction.ordinal() == side) {
            return this.getMachineType().getTexture(3);
        }
        if (side != 0 && side != 1) {
            return this.getMachineType().getTexture(2);
        }
        return this.getMachineType().getTexture(1);
    }

    @Override
    public boolean rotateBlock(ForgeDirection axis) {
        this.direction = this.direction == axis ? axis.getOpposite() : axis;
        this.markBlockForUpdate();
        return true;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.CART_DISPENSER, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    public void onBlockPlacedBy(EntityLiving entityliving) {
        super.onBlockPlacedBy(entityliving);
        this.direction = MiscTools.getSideClosestToPlayer(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, entityliving);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this.timeSinceLastSpawn < Integer.MAX_VALUE) {
            ++this.timeSinceLastSpawn;
        }
    }

    @Override
    public void onNeighborBlockChange(int id) {
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        boolean newPower = PowerPlugin.isBlockBeingPowered(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (!this.powered && newPower) {
            this.powered = newPower;
            EntityMinecart cart = CartTools.getMinecartOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0.0f, this.direction);
            if (cart == null) {
                if (this.timeSinceLastSpawn > RailcraftConfig.getCartDispenserMinDelay() * 20) {
                    for (int ii = 0; ii < this.func_70302_i_(); ++ii) {
                        ItemStack cartStack = this.func_70301_a(ii);
                        if (cartStack == null) continue;
                        int x = MiscTools.getXOnSide(this.field_70329_l, this.direction);
                        int y = MiscTools.getYOnSide(this.field_70330_m, this.direction);
                        int z = MiscTools.getZOnSide(this.field_70327_n, this.direction);
                        boolean minecartItem = cartStack.func_77973_b() instanceof IMinecartItem;
                        if (cartStack.func_77973_b() instanceof ItemMinecart || minecartItem) {
                            boolean canPlace = true;
                            if (minecartItem) {
                                canPlace = ((IMinecartItem)cartStack.func_77973_b()).canBePlacedByNonPlayer(cartStack);
                            }
                            if (!canPlace) continue;
                            ItemStack placedStack = cartStack.func_77946_l();
                            EntityMinecart placedCart = CartTools.placeCart(this.getOwner(), placedStack, this.field_70331_k, x, y, z);
                            if (placedCart == null) continue;
                            this.func_70298_a(ii, 1);
                            this.timeSinceLastSpawn = 0;
                            break;
                        }
                        float rx = MiscTools.getRand().nextFloat() * 0.8f + 0.1f;
                        float ry = MiscTools.getRand().nextFloat() * 0.8f + 0.1f;
                        float rz = MiscTools.getRand().nextFloat() * 0.8f + 0.1f;
                        EntityItem item = new EntityItem(this.field_70331_k, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), cartStack);
                        float factor = 0.05f;
                        item.field_70159_w = (float)MiscTools.getRand().nextGaussian() * factor;
                        item.field_70181_x = (float)MiscTools.getRand().nextGaussian() * factor + 0.2f;
                        item.field_70179_y = (float)MiscTools.getRand().nextGaussian() * factor;
                        if (!this.field_70331_k.func_72838_d((Entity)item)) continue;
                        this.func_70299_a(ii, null);
                    }
                }
            } else if (!cart.field_70128_L && cart.getCartItem() != null) {
                InventoryCopy testInv = new InventoryCopy(this);
                ItemStack cartStack = InvTools.moveItemStack(cart.getCartItem(), testInv);
                if (cartStack == null) {
                    InvTools.moveItemStack(cart.getCartItem(), this);
                    if (cart.field_70153_n != null) {
                        cart.field_70153_n.func_70078_a(null);
                    }
                    cart.func_70106_y();
                }
            }
        } else if (this.powered ^ newPower) {
            this.powered = newPower;
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74757_a("powered", this.powered);
        data.func_74774_a("direction", (byte)this.direction.ordinal());
        data.func_74768_a("time", this.timeSinceLastSpawn);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.powered = data.func_74767_n("powered");
        this.direction = ForgeDirection.getOrientation((int)data.func_74771_c("direction"));
        this.timeSinceLastSpawn = data.func_74762_e("time");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.direction.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.direction = ForgeDirection.getOrientation((int)data.readByte());
        this.markBlockForUpdate();
    }

    public boolean getPowered() {
        return this.powered;
    }

    public void setPowered(boolean power) {
        this.powered = power;
    }

    public int getStartInventorySide(ForgeDirection side) {
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return this.func_70302_i_();
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }
}

