/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import buildcraft.api.inventory.ISpecialInventory;
import java.util.Iterator;
import java.util.Map;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.core.items.IMinecartItem;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.TileDispenserCart;
import mods.railcraft.common.carts.ItemCartAnchor;
import mods.railcraft.common.carts.ItemLocomotive;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.InventoryCopy;
import mods.railcraft.common.util.inventory.InventoryMapper;
import mods.railcraft.common.util.inventory.ItemStackSet;
import mods.railcraft.common.util.inventory.PhantomInventory;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class TileDispenserTrain
extends TileDispenserCart
implements ISpecialInventory {
    public static final int PATTERN_SIZE = 9;
    public static final int BUFFER_SIZE = 18;
    private byte patternIndex;
    private boolean spawningTrain = false;
    private EntityMinecart lastCart;
    private PhantomInventory invPattern = new PhantomInventory(9, this);
    private IInventory invStock = new InventoryMapper(this);
    private int update = MiscTools.getRand().nextInt();

    public TileDispenserTrain() {
        this.setInventorySize(18);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.DISPENSER_TRAIN;
    }

    public PhantomInventory getPattern() {
        return this.invPattern;
    }

    @Override
    public Icon getBlockTexture(int side) {
        if (this.direction.ordinal() == side) {
            return this.getMachineType().getTexture(3);
        }
        if (side != 0 && side != 1) {
            return this.getMachineType().getTexture(2);
        }
        return this.getMachineType().getTexture(1);
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.TRAIN_DISPENSER, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    private boolean canBuildTrain() {
        Map pattern = InvTools.getManifest(this.getPattern());
        Map buffer = InvTools.getManifest(this);
        for (Map.Entry entry : pattern.entrySet()) {
            Integer count = (Integer)buffer.get(entry.getKey());
            if (count != null && count >= (Integer)entry.getValue()) continue;
            return false;
        }
        return true;
    }

    private boolean spawnNextCart() {
        ItemStack cartItem;
        ItemStack spawn = this.getPattern().func_70301_a(this.patternIndex);
        if (spawn == null) {
            this.resetSpawnSequence();
            return false;
        }
        MinecartItemType filter = new MinecartItemType(spawn);
        if (InvTools.countItems(this.invStock, filter) == 0) {
            this.resetSpawnSequence();
            return false;
        }
        int x = MiscTools.getXOnSide(this.field_70329_l, this.direction);
        int y = MiscTools.getYOnSide(this.field_70330_m, this.direction);
        int z = MiscTools.getZOnSide(this.field_70327_n, this.direction);
        if ((spawn.func_77973_b() instanceof ItemMinecart || spawn.func_77973_b() instanceof IMinecartItem) && CartTools.getMinecartOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0.0f, this.direction) == null && (cartItem = InvTools.removeOneItem(this.invStock, filter)) != null) {
            EntityMinecart cartPlaced = CartTools.placeCart(this.getOwner(), cartItem, this.field_70331_k, x, y, z);
            if (cartPlaced != null) {
                CartTools.getLinkageManager(this.field_70331_k).createLink(cartPlaced, this.lastCart);
                this.lastCart = cartPlaced;
                this.patternIndex = (byte)(this.patternIndex + 1);
                if (this.patternIndex >= this.getPattern().func_70302_i_()) {
                    this.resetSpawnSequence();
                }
                return true;
            }
            InvTools.moveItemStack(cartItem, this.invStock);
        }
        return false;
    }

    private void resetSpawnSequence() {
        this.patternIndex = 0;
        this.spawningTrain = false;
        this.timeSinceLastSpawn = 0;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        ++this.update;
        if (this.spawningTrain && this.update % 4 == 0) {
            this.spawnNextCart();
        }
    }

    @Override
    public void onNeighborBlockChange(int id) {
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        boolean newPower = PowerPlugin.isBlockBeingPowered(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (!this.powered && newPower) {
            this.powered = newPower;
            EntityMinecart cart = CartTools.getMinecartOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0.0f, this.direction);
            if (cart == null && !this.spawningTrain && this.canBuildTrain() && this.timeSinceLastSpawn > RailcraftConfig.getCartDispenserMinDelay() * 20) {
                this.spawningTrain = true;
            }
        } else if (this.powered ^ newPower) {
            this.powered = newPower;
        }
    }

    @Override
    public int getStartInventorySide(ForgeDirection side) {
        return 0;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection side) {
        return 18;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74757_a("spawningTrain", this.spawningTrain);
        data.func_74774_a("patternIndex", this.patternIndex);
        this.getPattern().writeToNBT("invPattern", data);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.spawningTrain = data.func_74767_n("spawningTrain");
        this.patternIndex = data.func_74771_c("patternIndex");
        if (data.func_74764_b("pattern")) {
            NBTTagCompound pattern = data.func_74775_l("pattern");
            this.getPattern().readFromNBT("Items", pattern);
        } else {
            this.getPattern().readFromNBT("invPattern", data);
        }
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        ItemStack leftOver;
        if (InvTools.isInventoryEmpty(this.getPattern())) {
            return 0;
        }
        IInventory inv = this.invStock;
        if (!doAdd) {
            inv = new InventoryCopy(inv);
        }
        if ((leftOver = InvTools.moveItemStack(stack, inv)) == null) {
            return stack.field_77994_a;
        }
        return stack.field_77994_a - leftOver.field_77994_a;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        Iterator i$;
        ItemStackSet patternSet = new ItemStackSet();
        ItemStackSet bufferSet = new ItemStackSet();
        for (ItemStack stack : this.getPattern().getContents()) {
            if (stack == null) continue;
            patternSet.add(stack);
        }
        for (ItemStack stack : this.getInventory().getContents()) {
            if (stack == null) continue;
            bufferSet.add(stack);
        }
        bufferSet.removeAll(patternSet);
        IInventory inv = this.invStock;
        if (!doRemove) {
            inv = new InventoryCopy(inv);
        }
        if ((i$ = bufferSet.iterator()).hasNext()) {
            ItemStack[] itemStackArray;
            ItemStack stack = (ItemStack)i$.next();
            ItemStack removed = InvTools.removeOneItem(inv, stack);
            if (removed != null) {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = removed;
            } else {
                itemStackArray = new ItemStack[]{};
            }
            return itemStackArray;
        }
        return new ItemStack[0];
    }

    private static class MinecartItemType
    implements IStackFilter {
        private final ItemStack original;

        public MinecartItemType(ItemStack cart) {
            this.original = cart;
        }

        @Override
        public boolean matches(ItemStack stack) {
            if (stack == null) {
                return false;
            }
            if (InvTools.isItemEqual(stack, this.original)) {
                return true;
            }
            if (stack.func_77973_b() instanceof ItemCartAnchor || stack.func_77973_b() instanceof ItemLocomotive) {
                return InvTools.isItemEqual(stack, this.original, false, false);
            }
            return false;
        }
    }
}

